/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import java.util.function.BiConsumer;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import phanastrae.operation_starcleave.OperationStarcleave;
import phanastrae.operation_starcleave.block.BisreedBlock;
import phanastrae.operation_starcleave.block.BlessedBedBlock;
import phanastrae.operation_starcleave.block.BlessedClothBlock;
import phanastrae.operation_starcleave.block.BlessedClothCarpetBlock;
import phanastrae.operation_starcleave.block.BlessedClothCurtainBlock;
import phanastrae.operation_starcleave.block.CoagulatedPlasmaBlock;
import phanastrae.operation_starcleave.block.CustomStairBlock;
import phanastrae.operation_starcleave.block.HolyMossBlock;
import phanastrae.operation_starcleave.block.ImbuedStarbleachedTilesBlock;
import phanastrae.operation_starcleave.block.MulchborneTuftBlock;
import phanastrae.operation_starcleave.block.NetheritePumpkinBlock;
import phanastrae.operation_starcleave.block.NucleicFissureleavesBlock;
import phanastrae.operation_starcleave.block.NucleicFissurerootBlock;
import phanastrae.operation_starcleave.block.NucleosyntheseedBlock;
import phanastrae.operation_starcleave.block.PetrichoricPlasmaLiquidBlock;
import phanastrae.operation_starcleave.block.PetrichoricVaporBlock;
import phanastrae.operation_starcleave.block.PhlogisticFireBlock;
import phanastrae.operation_starcleave.block.PlasmaIceBlock;
import phanastrae.operation_starcleave.block.ShortHolyMossBlock;
import phanastrae.operation_starcleave.block.StarbleachCauldronBlock;
import phanastrae.operation_starcleave.block.StarbleachedLeavesBlock;
import phanastrae.operation_starcleave.block.StarbleachedPearlBlock;
import phanastrae.operation_starcleave.block.StardustClusterBlock;
import phanastrae.operation_starcleave.block.StellarFarmlandBlock;
import phanastrae.operation_starcleave.block.StellarMulchBlock;
import phanastrae.operation_starcleave.block.StellarRepulsorBlock;
import phanastrae.operation_starcleave.block.StellarSedimentBlock;
import phanastrae.operation_starcleave.fluid.OperationStarcleaveFluids;

public class OperationStarcleaveBlocks {
    protected static final BlockBehaviour.StatePredicate ALWAYS = (blockState, blockView, blockPos) -> true;
    protected static final BlockBehaviour.StatePredicate NEVER = (blockState, blockView, blockPos) -> false;
    protected static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> SPAWN_ALWAYS = (blockState, blockView, blockPos, entityType) -> true;
    protected static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> SPAWN_NEVER = (blockState, blockView, blockPos, entityType) -> true;
    public static final Block NETHERITE_PUMPKIN = new NetheritePumpkinBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_BLACK, SoundType.NETHERITE_BLOCK).requiresCorrectToolForDrops().strength(10.0f, 1200.0f).isValidSpawn(SPAWN_ALWAYS).pushReaction(PushReaction.DESTROY));
    public static final Block STELLAR_SEDIMENT = new StellarSedimentBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_PURPLE, SoundType.SAND, NoteBlockInstrument.BASEDRUM, 1.15f, 2.0f, 2).isValidSpawn(SPAWN_NEVER));
    public static final Block STELLAR_FARMLAND = new StellarFarmlandBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_PURPLE, SoundType.SAND, NoteBlockInstrument.BASEDRUM, 1.25f, 2.0f).lightLevel(b -> (Integer)b.getValue((Property)FarmBlock.MOISTURE) == 7 ? 15 : 2).isValidSpawn(SPAWN_NEVER).isViewBlocking(ALWAYS).isSuffocating(ALWAYS).randomTicks());
    public static final Block BISREEDS = new BisreedBlock(OperationStarcleaveBlocks.settings().mapColor(MapColor.COLOR_PINK).sound(SoundType.CROP).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak());
    public static final Block STELLAR_MULCH = new StellarMulchBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_PURPLE, SoundType.MUD, NoteBlockInstrument.BASEDRUM, 1.15f, 2.0f, 4).isValidSpawn(SPAWN_NEVER).randomTicks());
    public static final Block MULCHBORNE_TUFT = new MulchborneTuftBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_MAGENTA, SoundType.GRASS).lightLevel(OperationStarcleaveBlocks.constant(6)).offsetType(BlockBehaviour.OffsetType.XYZ).pushReaction(PushReaction.DESTROY).replaceable().noCollission().instabreak());
    public static final Block HOLY_MOSS = new HolyMossBlock(OperationStarcleaveBlocks.settings(MapColor.SAND, SoundType.MOSS, NoteBlockInstrument.BASEDRUM, 1.15f, 2.0f, 13).isValidSpawn(SPAWN_NEVER).randomTicks());
    public static final Block SHORT_HOLY_MOSS = new ShortHolyMossBlock(OperationStarcleaveBlocks.settings(MapColor.SAND, SoundType.MOSS).lightLevel(OperationStarcleaveBlocks.constant(13)).offsetType(BlockBehaviour.OffsetType.XYZ).pushReaction(PushReaction.DESTROY).replaceable().noCollission().instabreak());
    public static final Block STARDUST_BLOCK = new ColoredFallingBlock(new ColorRGBA(-274739201), OperationStarcleaveBlocks.settings(MapColor.ICE, SoundType.SAND, NoteBlockInstrument.BASEDRUM, 0.2f, 0.1f, 9).isValidSpawn(SPAWN_NEVER));
    public static final Block STARDUST_CLUSTER = new StardustClusterBlock(OperationStarcleaveBlocks.settings().lightLevel(OperationStarcleaveBlocks.constant(15)).replaceable().instabreak().noLootTable().noOcclusion());
    public static final Block STARBLEACHED_LOG = new RotatedPillarBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_GRAY, SoundType.STONE, NoteBlockInstrument.BASEDRUM, 2.0f, 6.0f, 8, true).isValidSpawn(SPAWN_NEVER));
    public static final Block STARBLEACHED_WOOD = new RotatedPillarBlock(OperationStarcleaveBlocks.copyShallow((BlockBehaviour)STARBLEACHED_LOG));
    public static final Block STARBLEACHED_LEAVES = new StarbleachedLeavesBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_GRAY, SoundType.STONE, NoteBlockInstrument.BASEDRUM, 0.25f, 2.0f, 11, true).isValidSpawn(SPAWN_NEVER).isSuffocating(NEVER).isViewBlocking(NEVER).isRedstoneConductor(NEVER).noOcclusion());
    public static final Block STARBLEACHED_TILES = new Block(OperationStarcleaveBlocks.settings(MapColor.COLOR_GRAY, SoundType.STONE, NoteBlockInstrument.BASEDRUM, 1.5f, 6.0f, 8, true).isValidSpawn(SPAWN_NEVER));
    public static final Block STARBLEACHED_TILE_STAIRS = OperationStarcleaveBlocks.stairsOf(STARBLEACHED_TILES);
    public static final Block STARBLEACHED_TILE_SLAB = OperationStarcleaveBlocks.slabOf((BlockBehaviour)STARBLEACHED_TILES);
    public static final Block STARBLEACHED_TILE_WALL = OperationStarcleaveBlocks.wallOf((BlockBehaviour)STARBLEACHED_TILES);
    public static final Block CHISELED_STARBLEACHED_TILES = new Block(OperationStarcleaveBlocks.settings(MapColor.COLOR_GRAY, SoundType.STONE, NoteBlockInstrument.BASEDRUM, 1.5f, 6.0f, 8, true).isValidSpawn(SPAWN_NEVER));
    public static final Block IMBUED_STARBLEACHED_TILES = new ImbuedStarbleachedTilesBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_CYAN, SoundType.STONE, NoteBlockInstrument.BASEDRUM, 1.25f, 6.0f, 15, true).isValidSpawn(SPAWN_NEVER));
    public static final Block STARBLEACHED_PEARL_BLOCK = new StarbleachedPearlBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_CYAN, SoundType.GLASS, NoteBlockInstrument.BASEDRUM, 1.3f, 6.0f, 12, true).isValidSpawn(SPAWN_NEVER));
    public static final Block STARBLEACH_CAULDRON = new StarbleachCauldronBlock(OperationStarcleaveBlocks.copyShallow((BlockBehaviour)Blocks.CAULDRON).lightLevel(OperationStarcleaveBlocks.constant(13)));
    public static final Block STELLAR_TILES = new Block(OperationStarcleaveBlocks.settings(MapColor.COLOR_PURPLE, SoundType.DEEPSLATE, NoteBlockInstrument.BASEDRUM, 1.75f, 6.0f, 2).isValidSpawn(SPAWN_NEVER));
    public static final Block STELLAR_TILE_SLAB = OperationStarcleaveBlocks.slabOf((BlockBehaviour)STELLAR_TILES);
    public static final Block STELLAR_REPULSOR = new StellarRepulsorBlock(OperationStarcleaveBlocks.settings(MapColor.SAND, SoundType.WOOL, NoteBlockInstrument.BASEDRUM, 1.75f, 6.0f, 13).isValidSpawn(SPAWN_NEVER));
    public static final Block BLESSED_CLOTH_BLOCK = new BlessedClothBlock(OperationStarcleaveBlocks.settings(MapColor.SAND, SoundType.WOOL, NoteBlockInstrument.GUITAR).strength(0.8f));
    public static final Block BLESSED_CLOTH_CARPET = new BlessedClothCarpetBlock(OperationStarcleaveBlocks.settings(MapColor.SAND, SoundType.WOOL).strength(0.1f));
    public static final Block BLESSED_CLOTH_CURTAIN = new BlessedClothCurtainBlock(OperationStarcleaveBlocks.settings(MapColor.SAND, SoundType.WOOL, NoteBlockInstrument.GUITAR).strength(0.8f).noOcclusion());
    public static final Block BLESSED_BED = new BlessedBedBlock(OperationStarcleaveBlocks.settings(MapColor.SAND, SoundType.WOOD).strength(0.2f).pushReaction(PushReaction.DESTROY).noOcclusion());
    public static final Block PHLOGISTIC_FIRE = new PhlogisticFireBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_LIGHT_GREEN, SoundType.WOOL).lightLevel(OperationStarcleaveBlocks.constant(15)).pushReaction(PushReaction.DESTROY).replaceable().noCollission().instabreak());
    public static final Block PETRICHORIC_PLASMA = new PetrichoricPlasmaLiquidBlock(OperationStarcleaveFluids.FLOWING_PETRICHORIC_PLASMA, OperationStarcleaveBlocks.settings().mapColor(MapColor.COLOR_LIGHT_GREEN).replaceable().noCollission().randomTicks().strength(100.0f).lightLevel(OperationStarcleaveBlocks.constant(15)).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY));
    public static final Block PETRICHORIC_VAPOR = new PetrichoricVaporBlock(OperationStarcleaveBlocks.settings(MapColor.COLOR_LIGHT_GREEN, SoundType.EMPTY).strength(100.0f).lightLevel(OperationStarcleaveBlocks.constant(15)).pushReaction(PushReaction.DESTROY).emissiveRendering(OperationStarcleaveBlocks::always).noLootTable().noOcclusion().noCollission());
    public static final Block NUCLEOSYNTHESEED = new NucleosyntheseedBlock(OperationStarcleaveBlocks.settings().strength(5.0f).mapColor(DyeColor.GREEN).sound(SoundType.NETHER_WOOD).lightLevel(OperationStarcleaveBlocks.constant(13)).requiresCorrectToolForDrops().randomTicks());
    public static final Block NUCLEIC_FISSUREROOT = new NucleicFissurerootBlock(OperationStarcleaveBlocks.settings().strength(2.5f).mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? MapColor.COLOR_GREEN : MapColor.COLOR_LIGHT_GREEN).sound(SoundType.NETHER_WOOD).instrument(NoteBlockInstrument.BASS).lightLevel(OperationStarcleaveBlocks.constant(9)).requiresCorrectToolForDrops().randomTicks());
    public static final Block NUCLEIC_FISSURELEAVES = new NucleicFissureleavesBlock(OperationStarcleaveBlocks.settings().strength(0.2f).mapColor(MapColor.COLOR_LIGHT_GREEN).sound(SoundType.GRASS).lightLevel(OperationStarcleaveBlocks.constant(12)).isValidSpawn(OperationStarcleaveBlocks::never).isSuffocating(OperationStarcleaveBlocks::never).isViewBlocking(OperationStarcleaveBlocks::never).isRedstoneConductor(OperationStarcleaveBlocks::never).pushReaction(PushReaction.DESTROY).noOcclusion().randomTicks());
    public static final Block COAGULATED_PLASMA = new CoagulatedPlasmaBlock(OperationStarcleaveBlocks.settings().strength(3.0f, 6.0f).mapColor(MapColor.TERRACOTTA_GREEN).sound(SoundType.DEEPSLATE).instrument(NoteBlockInstrument.BASEDRUM).lightLevel(OperationStarcleaveBlocks.constant(8)).requiresCorrectToolForDrops().randomTicks());
    public static final Block PLASMA_ICE = new PlasmaIceBlock(OperationStarcleaveBlocks.settings().randomTicks().mapColor(MapColor.COLOR_LIGHT_GREEN).lightLevel(OperationStarcleaveBlocks.constant(13)).strength(2.8f).friction(0.989f).sound(SoundType.GLASS));

    public static void init(BiConsumer<ResourceLocation, Block> r) {
        r.accept(OperationStarcleaveBlocks.id("netherite_pumpkin"), NETHERITE_PUMPKIN);
        r.accept(OperationStarcleaveBlocks.id("stellar_sediment"), STELLAR_SEDIMENT);
        r.accept(OperationStarcleaveBlocks.id("stellar_farmland"), STELLAR_FARMLAND);
        r.accept(OperationStarcleaveBlocks.id("bisreeds"), BISREEDS);
        r.accept(OperationStarcleaveBlocks.id("stellar_mulch"), STELLAR_MULCH);
        r.accept(OperationStarcleaveBlocks.id("mulchborne_tuft"), MULCHBORNE_TUFT);
        r.accept(OperationStarcleaveBlocks.id("holy_moss"), HOLY_MOSS);
        r.accept(OperationStarcleaveBlocks.id("short_holy_moss"), SHORT_HOLY_MOSS);
        r.accept(OperationStarcleaveBlocks.id("stardust_block"), STARDUST_BLOCK);
        r.accept(OperationStarcleaveBlocks.id("stardust_cluster"), STARDUST_CLUSTER);
        r.accept(OperationStarcleaveBlocks.id("starbleached_log"), STARBLEACHED_LOG);
        r.accept(OperationStarcleaveBlocks.id("starbleached_wood"), STARBLEACHED_WOOD);
        r.accept(OperationStarcleaveBlocks.id("starbleached_leaves"), STARBLEACHED_LEAVES);
        r.accept(OperationStarcleaveBlocks.id("starbleached_tiles"), STARBLEACHED_TILES);
        r.accept(OperationStarcleaveBlocks.id("starbleached_tile_stairs"), STARBLEACHED_TILE_STAIRS);
        r.accept(OperationStarcleaveBlocks.id("starbleached_tile_slab"), STARBLEACHED_TILE_SLAB);
        r.accept(OperationStarcleaveBlocks.id("starbleached_tile_wall"), STARBLEACHED_TILE_WALL);
        r.accept(OperationStarcleaveBlocks.id("chiseled_starbleached_tiles"), CHISELED_STARBLEACHED_TILES);
        r.accept(OperationStarcleaveBlocks.id("imbued_starbleached_tiles"), IMBUED_STARBLEACHED_TILES);
        r.accept(OperationStarcleaveBlocks.id("starbleached_pearl_block"), STARBLEACHED_PEARL_BLOCK);
        r.accept(OperationStarcleaveBlocks.id("starbleach_cauldron"), STARBLEACH_CAULDRON);
        r.accept(OperationStarcleaveBlocks.id("stellar_tiles"), STELLAR_TILES);
        r.accept(OperationStarcleaveBlocks.id("stellar_tile_slab"), STELLAR_TILE_SLAB);
        r.accept(OperationStarcleaveBlocks.id("stellar_repulsor"), STELLAR_REPULSOR);
        r.accept(OperationStarcleaveBlocks.id("blessed_cloth_block"), BLESSED_CLOTH_BLOCK);
        r.accept(OperationStarcleaveBlocks.id("blessed_cloth_carpet"), BLESSED_CLOTH_CARPET);
        r.accept(OperationStarcleaveBlocks.id("blessed_cloth_curtain"), BLESSED_CLOTH_CURTAIN);
        r.accept(OperationStarcleaveBlocks.id("blessed_bed"), BLESSED_BED);
        r.accept(OperationStarcleaveBlocks.id("phlogistic_fire"), PHLOGISTIC_FIRE);
        r.accept(OperationStarcleaveBlocks.id("petrichoric_plasma"), PETRICHORIC_PLASMA);
        r.accept(OperationStarcleaveBlocks.id("petrichoric_vapor"), PETRICHORIC_VAPOR);
        r.accept(OperationStarcleaveBlocks.id("nucleosyntheseed"), NUCLEOSYNTHESEED);
        r.accept(OperationStarcleaveBlocks.id("nucleic_fissureroot"), NUCLEIC_FISSUREROOT);
        r.accept(OperationStarcleaveBlocks.id("nucleic_fissureleaves"), NUCLEIC_FISSURELEAVES);
        r.accept(OperationStarcleaveBlocks.id("coagulated_plasma"), COAGULATED_PLASMA);
        r.accept(OperationStarcleaveBlocks.id("plasma_ice"), PLASMA_ICE);
    }

    private static ResourceLocation id(String path) {
        return OperationStarcleave.id(path);
    }

    protected static ToIntFunction<BlockState> constant(int t) {
        return b -> t;
    }

    protected static BlockBehaviour.Properties copyShallow(BlockBehaviour settings) {
        return BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)settings);
    }

    protected static BlockBehaviour.Properties settings() {
        return BlockBehaviour.Properties.of();
    }

    protected static BlockBehaviour.Properties settings(MapColor mapColor) {
        return BlockBehaviour.Properties.of().mapColor(mapColor);
    }

    protected static BlockBehaviour.Properties settings(MapColor mapColor, SoundType soundGroup) {
        return BlockBehaviour.Properties.of().mapColor(mapColor).sound(soundGroup);
    }

    protected static BlockBehaviour.Properties settings(MapColor mapColor, SoundType soundGroup, NoteBlockInstrument instrument) {
        return BlockBehaviour.Properties.of().mapColor(mapColor).sound(soundGroup).instrument(instrument);
    }

    protected static BlockBehaviour.Properties settings(MapColor mapColor, SoundType soundGroup, NoteBlockInstrument instrument, float hardness, float resistance) {
        return BlockBehaviour.Properties.of().mapColor(mapColor).sound(soundGroup).instrument(instrument).strength(hardness, resistance);
    }

    protected static BlockBehaviour.Properties settings(MapColor mapColor, SoundType soundGroup, NoteBlockInstrument instrument, float hardness, float resistance, int luminance) {
        return BlockBehaviour.Properties.of().mapColor(mapColor).sound(soundGroup).instrument(instrument).strength(hardness, resistance).lightLevel(OperationStarcleaveBlocks.constant(luminance));
    }

    protected static BlockBehaviour.Properties settings(MapColor mapColor, SoundType soundGroup, NoteBlockInstrument instrument, float hardness, float resistance, int luminance, boolean requiresTool) {
        BlockBehaviour.Properties settings = BlockBehaviour.Properties.of().mapColor(mapColor).sound(soundGroup).instrument(instrument).strength(hardness, resistance).lightLevel(OperationStarcleaveBlocks.constant(luminance));
        if (requiresTool) {
            settings.requiresCorrectToolForDrops();
        }
        return settings;
    }

    protected static StairBlock stairsOf(Block block) {
        return new CustomStairBlock(block.defaultBlockState(), OperationStarcleaveBlocks.copyShallow((BlockBehaviour)block));
    }

    protected static SlabBlock slabOf(BlockBehaviour block) {
        return new SlabBlock(OperationStarcleaveBlocks.copyShallow(block));
    }

    protected static WallBlock wallOf(BlockBehaviour block) {
        return new WallBlock(OperationStarcleaveBlocks.copyShallow(block).forceSolidOn());
    }

    private static Boolean always(BlockState state, BlockGetter blockGetter, BlockPos pos, EntityType<?> entity) {
        return true;
    }

    private static Boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    private static boolean always(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    private static boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }
}

