/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import phanastrae.operation_starcleave.block.NetheritePumpkinBlock;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.block.StarbleachCauldronBlock;
import phanastrae.operation_starcleave.item.OperationStarcleaveItems;

public class OperationStarcleaveDispenserBehavior {
    public static void init() {
        OperationStarcleaveDispenserBehavior.register((ItemLike)OperationStarcleaveBlocks.NETHERITE_PUMPKIN, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource pointer, ItemStack stack) {
                ServerLevel world = pointer.level();
                BlockPos blockPos = pointer.pos().relative((Direction)pointer.state().getValue((Property)DispenserBlock.FACING));
                NetheritePumpkinBlock netheritePumpkinBlock = (NetheritePumpkinBlock)OperationStarcleaveBlocks.NETHERITE_PUMPKIN;
                if (world.isEmptyBlock(blockPos) && netheritePumpkinBlock.canSpawnGolem((LevelReader)world, blockPos)) {
                    if (!world.isClientSide) {
                        world.setBlock(blockPos, netheritePumpkinBlock.defaultBlockState(), 3);
                        world.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, blockPos);
                    }
                    stack.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ArmorItem.dispenseArmor((BlockSource)pointer, (ItemStack)stack));
                }
                return stack;
            }
        });
        OperationStarcleaveDispenserBehavior.register((ItemLike)OperationStarcleaveItems.STARBLEACH_BOTTLE, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior fallbackBehavior = new DefaultDispenseItemBehavior();

            private ItemStack replace(BlockSource pointer, ItemStack oldStack, ItemStack newStack) {
                pointer.level().gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pointer.pos());
                return this.consumeWithRemainder(pointer, oldStack, newStack);
            }

            public ItemStack execute(BlockSource pointer, ItemStack stack) {
                BlockPos blockPos;
                ServerLevel world = pointer.level();
                if (StarbleachCauldronBlock.canFillCauldron((Level)world, blockPos = pointer.pos().relative((Direction)pointer.state().getValue((Property)DispenserBlock.FACING)))) {
                    StarbleachCauldronBlock.fillCauldron((Level)world, blockPos);
                    this.setSuccess(true);
                    return this.replace(pointer, stack, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                }
                return super.execute(pointer, stack);
            }
        });
        DispenserBlock.registerProjectileBehavior((ItemLike)OperationStarcleaveItems.STARBLEACHED_PEARL);
        DispenserBlock.registerProjectileBehavior((ItemLike)OperationStarcleaveItems.SPLASH_STARBLEACH_BOTTLE);
        DispenserBlock.registerProjectileBehavior((ItemLike)OperationStarcleaveItems.FIRMAMENT_REJUVENATOR);
    }

    public static void register(ItemLike provider, DispenseItemBehavior behavior) {
        DispenserBlock.registerBehavior((ItemLike)provider, (DispenseItemBehavior)behavior);
    }
}

