/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import phanastrae.operation_starcleave.block.AbstractPetrichoricBlock;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;

public class PetrichoricVaporBlock
extends AbstractPetrichoricBlock {
    public static final MapCodec<PetrichoricVaporBlock> CODEC = PetrichoricVaporBlock.simpleCodec(PetrichoricVaporBlock::new);
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"distance", (int)0, (int)3);

    protected MapCodec<? extends PetrichoricVaporBlock> codec() {
        return CODEC;
    }

    public PetrichoricVaporBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)DISTANCE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE});
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        level.scheduleTick(pos, (Block)this, PetrichoricVaporBlock.getDelay(level.getRandom()));
        super.onPlace(state, level, pos, oldState, notify);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        level.scheduleTick(pos, (Block)this, PetrichoricVaporBlock.getDelay(level.getRandom()));
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public static int getDelay(RandomSource random) {
        return 1 + random.nextInt(2);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        PetrichoricVaporBlock.absorbWater((Level)level, pos, random);
        int distance = PetrichoricVaporBlock.getDistance(state);
        BlockPos downPos = pos.below();
        BlockState downState = level.getBlockState(downPos);
        if (downState.is(OperationStarcleaveBlocks.PETRICHORIC_VAPOR)) {
            int downDistance = PetrichoricVaporBlock.getDistance(downState);
            int desiredDistance = downDistance + 1;
            if (distance != desiredDistance) {
                level.setBlockAndUpdate(pos, this.getStateForDistance(desiredDistance));
            }
        } else {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    public static int getDistance(BlockState state) {
        if (state.hasProperty((Property)DISTANCE)) {
            return (Integer)state.getValue((Property)DISTANCE);
        }
        return 0;
    }

    public BlockState getStateForDistance(int distance) {
        if (distance > 3) {
            return Blocks.AIR.defaultBlockState();
        }
        if (distance < 0) {
            distance = 0;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)DISTANCE, (Comparable)Integer.valueOf(distance));
    }
}

