/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import phanastrae.operation_starcleave.block.NucleosyntheseedBlock;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.block.tag.OperationStarcleaveBlockTags;
import phanastrae.operation_starcleave.entity.OperationStarcleaveDamageTypes;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityAttachment;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityTypeTags;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.services.XPlatInterface;

public class PhlogisticFireBlock
extends BaseFireBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<PhlogisticFireBlock> CODEC = PhlogisticFireBlock.simpleCodec(PhlogisticFireBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, BooleanProperty> DIRECTION_PROPERTIES = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(entry -> entry.getKey() != Direction.DOWN).collect(Util.toMap());
    private static final VoxelShape UP_SHAPE = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesByState;

    public MapCodec<PhlogisticFireBlock> codec() {
        return CODEC;
    }

    public PhlogisticFireBlock(BlockBehaviour.Properties settings) {
        super(settings, 3.0f);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapesByState = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().filter(state -> (Integer)state.getValue((Property)AGE) == 0 && (Boolean)state.getValue((Property)WATERLOGGED) == false).collect(Collectors.toMap(Function.identity(), PhlogisticFireBlock::getShapeForState)));
    }

    private static VoxelShape getShapeForState(BlockState state) {
        VoxelShape voxelShape = Shapes.empty();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            voxelShape = UP_SHAPE;
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)EAST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)WEST_SHAPE);
        }
        return voxelShape.isEmpty() ? DOWN_AABB : voxelShape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapesByState.get(((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.areBlocksAroundValidSupports((BlockGetter)level, pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.getStateForPosition((BlockGetter)ctx.getLevel(), ctx.getClickedPos());
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, level, pos, oldState, notify);
        int age = (Integer)state.getValue((Property)AGE);
        boolean waterlogged = (Boolean)state.getValue((Property)WATERLOGGED);
        level.scheduleTick(pos, (Block)this, PhlogisticFireBlock.getFireTickDelay(level.random, age, waterlogged));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        boolean canPlaceAt = this.canSurvive(state, (LevelReader)level, pos);
        if (canPlaceAt) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            }
            return PhlogisticFireBlock.getStateWithAge(level, pos, (Integer)state.getValue((Property)AGE));
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!entity.getType().is(OperationStarcleaveEntityTypeTags.PHLOGISTIC_FIRE_IMMUNE)) {
            OperationStarcleaveEntityAttachment osea = OperationStarcleaveEntityAttachment.fromEntity(entity);
            osea.setPhlogisticFireTicks(osea.getPhlogisticFireTicks() + 1);
            if (osea.getPhlogisticFireTicks() == 0) {
                osea.setOnPhlogisticFireFor(8.0f);
            }
        }
        entity.hurt(OperationStarcleaveDamageTypes.source(level, OperationStarcleaveDamageTypes.IN_PHLOGISTIC_FIRE), 3.0f);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        boolean waterlogged = (Boolean)state.getValue((Property)WATERLOGGED);
        level.scheduleTick(pos, (Block)this, PhlogisticFireBlock.getFireTickDelay(level.random, age, waterlogged));
        if (level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            boolean worldInfiniburn;
            if (!state.canSurvive((LevelReader)level, pos)) {
                level.removeBlock(pos, false);
                return;
            }
            int newAge = Math.min(7, age + random.nextInt(4) / 3);
            if (age != newAge) {
                state = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge));
                level.setBlock(pos, state, 4);
            }
            if (!(worldInfiniburn = state.is(level.dimensionType().infiniburn()))) {
                BlockPos floorPos = pos.below();
                if (age > 2 && !this.areBlocksAroundFlammable((BlockGetter)level, pos) && !level.getBlockState(floorPos).isFaceSturdy((BlockGetter)level, floorPos, Direction.UP)) {
                    level.removeBlock(pos, false);
                    return;
                }
                if (random.nextInt(age + 7) > 9) {
                    int nearbyFire = 0;
                    BlockPos.MutableBlockPos mutable = pos.mutable();
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            for (int y = -1; y <= 1; ++y) {
                                if (x == 0 && y == 0 && z == 0) continue;
                                mutable.setWithOffset((Vec3i)pos, x, y, z);
                                if (!level.getBlockState((BlockPos)mutable).is(this.asBlock())) continue;
                                ++nearbyFire;
                            }
                        }
                    }
                    if (nearbyFire > 8 - age) {
                        level.removeBlock(pos, false);
                    }
                }
            }
            this.spread((Level)level, pos, random, age);
            this.burn((Level)level, pos, random, age);
        }
    }

    protected void spread(Level level, BlockPos pos, RandomSource random, int age) {
        for (Direction direction : UPDATE_SHAPE_ORDER) {
            int spreadFactor = direction.getAxis() == Direction.Axis.Y ? 125 : 150;
            this.trySpreadingFire(level, pos.relative(direction), direction.getOpposite(), spreadFactor, random, age);
        }
    }

    protected void burn(Level level, BlockPos pos, RandomSource random, int age) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 4; ++y) {
                    int modifiedBurnChance;
                    int burnChance;
                    if (x == 0 && y == 0 && z == 0) continue;
                    mutable.setWithOffset((Vec3i)pos, x, y, z);
                    int o = 100;
                    if (y > 1) {
                        o += (y - 1) * 100;
                    }
                    if ((burnChance = this.getBurnChance((LevelReader)level, (BlockPos)mutable)) <= 0 || (modifiedBurnChance = (burnChance + 60 + level.getDifficulty().getId() * 7) / (7 + age * age)) <= 0 || random.nextInt(o) > modifiedBurnChance) continue;
                    int newAge = Math.min(7, age + random.nextInt(4) / 3);
                    level.setBlock((BlockPos)mutable, PhlogisticFireBlock.withWaterlogged(PhlogisticFireBlock.getStateWithAge((LevelAccessor)level, (BlockPos)mutable, newAge), PhlogisticFireBlock.shouldWaterlog((BlockGetter)level, (BlockPos)mutable)), 3);
                }
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(24) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
        }
        if (this.isValidSupport((BlockGetter)level, pos, Direction.DOWN)) {
            for (int i = 0; i < 2; ++i) {
                double x = (double)pos.getX() + random.nextDouble();
                double y = (double)pos.getY() + random.nextDouble() * 0.5 + 0.5;
                double z = (double)pos.getZ() + random.nextDouble();
                level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.LARGE_GLIMMER_SMOKE, x, y, z, 0.0, 0.0, 0.0);
            }
        } else {
            for (Direction direction : UPDATE_SHAPE_ORDER) {
                if (!this.isValidSupport((BlockGetter)level, pos, direction)) continue;
                double dx = random.nextDouble();
                double dy = random.nextDouble();
                double dz = random.nextDouble();
                if (direction.getAxis() == Direction.Axis.X) {
                    dx = 0.5 + (double)direction.getStepX() * (0.1 * dx + 0.4);
                }
                if (direction.getAxis() == Direction.Axis.Y) {
                    dy = 0.5 + (double)direction.getStepY() * (0.1 * dy + 0.4);
                }
                if (direction.getAxis() == Direction.Axis.Z) {
                    dz = 0.5 + (double)direction.getStepZ() * (0.1 * dz + 0.4);
                }
                level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.LARGE_GLIMMER_SMOKE, (double)pos.getX() + dx, (double)pos.getY() + dy, (double)pos.getZ() + dz, 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean isHyperflammable(BlockState state) {
        return state.is(OperationStarcleaveBlockTags.PHLOGISTIC_HYPERFLAMMABLES);
    }

    protected boolean canBurn(BlockState state) {
        if (PhlogisticFireBlock.isHyperflammable(state)) {
            return true;
        }
        return XPlatInterface.INSTANCE.canBurn(state);
    }

    protected boolean isValidSupport(BlockGetter level, BlockPos blockPos, Direction direction) {
        BlockPos groundPos = blockPos.relative(direction);
        BlockState groundState = level.getBlockState(groundPos);
        return this.canBurn(groundState) || groundState.isFaceSturdy(level, blockPos, direction.getOpposite());
    }

    protected boolean areBlocksAroundFlammable(BlockGetter level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canBurn(level.getBlockState(pos.relative(direction)))) continue;
            return true;
        }
        return false;
    }

    protected boolean areBlocksAroundValidSupports(BlockGetter level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.isValidSupport(level, pos, direction)) continue;
            return true;
        }
        return false;
    }

    private int getBurnChance(LevelReader level, BlockPos pos) {
        if (!level.isEmptyBlock(pos) && !level.isWaterAt(pos)) {
            return 0;
        }
        int maxBurnChance = 0;
        for (Direction direction : Direction.values()) {
            BlockPos adjPos = pos.relative(direction);
            BlockState blockState = level.getBlockState(adjPos);
            maxBurnChance = Math.max(this.getBurnChance(blockState, (BlockGetter)level, adjPos, direction.getOpposite()), maxBurnChance);
        }
        return maxBurnChance;
    }

    private int getSpreadChance(BlockState state, BlockGetter blockGetter, BlockPos blockPos, Direction face) {
        if (PhlogisticFireBlock.isHyperflammable(state)) {
            return 100;
        }
        return XPlatInterface.INSTANCE.getFireSpreadChance(state, blockGetter, blockPos, face);
    }

    private int getBurnChance(BlockState state, BlockGetter blockGetter, BlockPos blockPos, Direction face) {
        return XPlatInterface.INSTANCE.getFireBurnChance(state, blockGetter, blockPos, face);
    }

    private void trySpreadingFire(Level level, BlockPos pos, Direction originDirection, int spreadFactor, RandomSource random, int currentAge) {
        int spreadChance = this.getSpreadChance(level.getBlockState(pos), (BlockGetter)level, pos, originDirection);
        if (random.nextInt(spreadFactor) < spreadChance) {
            BlockState blockState = level.getBlockState(pos);
            if (random.nextInt(currentAge + 5) < 13) {
                int newAge = Math.min(7, currentAge + random.nextInt(5) / 2);
                if (PhlogisticFireBlock.isHyperflammable(blockState)) {
                    newAge = Math.min(newAge, 2);
                }
                level.setBlock(pos, PhlogisticFireBlock.withWaterlogged(PhlogisticFireBlock.getStateWithAge((LevelAccessor)level, pos, newAge), PhlogisticFireBlock.shouldWaterlog((BlockGetter)level, pos)), 3);
            } else {
                level.setBlock(pos, PhlogisticFireBlock.withWaterlogged(Blocks.AIR.defaultBlockState(), PhlogisticFireBlock.shouldWaterlog((BlockGetter)level, pos)), 3);
            }
            if (blockState.getBlock() instanceof TntBlock) {
                TntBlock.explode((Level)level, (BlockPos)pos);
            }
            if (blockState.is(OperationStarcleaveBlocks.NUCLEOSYNTHESEED)) {
                NucleosyntheseedBlock.detonate(level, pos, currentAge);
            }
        }
    }

    protected static BlockState withWaterlogged(BlockState state, boolean waterlogged) {
        if (state.hasProperty((Property)WATERLOGGED)) {
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        }
        if (state.isAir() && waterlogged) {
            return Blocks.WATER.defaultBlockState();
        }
        return state;
    }

    protected static boolean shouldWaterlog(BlockGetter level, BlockPos pos) {
        int adjWater = 0;
        for (Direction direction : UPDATE_SHAPE_ORDER) {
            if (direction.getAxis() == Direction.Axis.Y) continue;
            boolean water = level.getFluidState(pos.relative(direction)).is((Fluid)Fluids.WATER);
            if (water) {
                ++adjWater;
            }
            if (adjWater < 2) continue;
            return true;
        }
        return false;
    }

    protected BlockState getStateForPosition(BlockGetter level, BlockPos pos) {
        boolean isWet = level.getFluidState(pos).is(FluidTags.WATER);
        BlockState newState = this.defaultBlockState();
        if (!this.isValidSupport(level, pos, Direction.DOWN)) {
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanProperty = DIRECTION_PROPERTIES.get(direction);
                if (booleanProperty == null) continue;
                newState = (BlockState)newState.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(this.isValidSupport(level, pos, direction)));
            }
        }
        if (isWet) {
            newState = (BlockState)newState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return newState;
    }

    public static BlockState getStateWithAge(LevelAccessor level, BlockPos pos, int age) {
        BlockState blockState = PhlogisticFireBlock.getState((BlockGetter)level, pos);
        return blockState.is(OperationStarcleaveBlocks.PHLOGISTIC_FIRE) ? (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(age)) : blockState;
    }

    public static BlockState getState(BlockGetter level, BlockPos pos) {
        return ((PhlogisticFireBlock)OperationStarcleaveBlocks.PHLOGISTIC_FIRE).getStateForPosition(level, pos);
    }

    public static boolean canPlaceAt(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        if (!blockState.isAir() && !level.isWaterAt(pos)) {
            return false;
        }
        return PhlogisticFireBlock.getState((BlockGetter)level, pos).canSurvive((LevelReader)level, pos);
    }

    private static int getFireTickDelay(RandomSource random, int age, boolean waterlogged) {
        if (waterlogged) {
            return 2 + age * 2 + random.nextInt(2 + age * 2) + (age == 7 ? 140 : 0);
        }
        return 5 + age * age / 3 + random.nextInt(4 + age * age / 3) + (age == 7 ? 100 : 0);
    }
}

