/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.entity.projectile.StarbleachedPearlEntity;

public class StarbleachedPearlBlock
extends Block {
    public static final MapCodec<StarbleachedPearlBlock> CODEC = StarbleachedPearlBlock.simpleCodec(StarbleachedPearlBlock::new);
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;

    public MapCodec<? extends StarbleachedPearlBlock> codec() {
        return CODEC;
    }

    public StarbleachedPearlBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean redstone = world.hasNeighborSignal(pos);
        boolean triggered = (Boolean)state.getValue((Property)TRIGGERED);
        if (redstone && !triggered) {
            int neighboringPearlBlocks = 0;
            int neighboringDampners = 0;
            for (Direction direction : UPDATE_SHAPE_ORDER) {
                BlockState state1 = world.getBlockState(pos.offset(direction.getNormal()));
                if (state1.is(OperationStarcleaveBlocks.STARBLEACHED_PEARL_BLOCK)) {
                    ++neighboringPearlBlocks;
                }
                if (!state1.is(BlockTags.DAMPENS_VIBRATIONS)) continue;
                ++neighboringDampners;
            }
            float pearlMultiplier = 1.0f / (float)(neighboringPearlBlocks + 1);
            float dampenMultiplier = 1.0f - (float)neighboringDampners / 7.0f;
            float audioMultiplier = 0.7f * pearlMultiplier * dampenMultiplier;
            int rstone = world.getBestNeighborSignal(pos);
            StarbleachedPearlEntity.repel(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), 0.5f * (float)(rstone + 4) * 15.0f / 19.0f, 0.125f * (float)(rstone + 8) * 15.0f / 23.0f, world, null, audioMultiplier);
            world.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
        } else if (!redstone && triggered) {
            world.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TRIGGERED});
    }
}

