/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.block.BisreedBlock;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.world.firmament.Firmament;

public class StellarFarmlandBlock
extends FarmBlock {
    public static final MapCodec<FarmBlock> CODEC = StellarFarmlandBlock.simpleCodec(StellarFarmlandBlock::new);

    public MapCodec<FarmBlock> codec() {
        return CODEC;
    }

    public StellarFarmlandBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return !this.defaultBlockState().canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos()) ? OperationStarcleaveBlocks.STELLAR_SEDIMENT.defaultBlockState() : this.defaultBlockState();
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            StellarFarmlandBlock.setToSediment(null, state, (Level)level, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Firmament firmament = Firmament.fromLevel((Level)level);
        if (firmament == null) {
            return;
        }
        int i = (Integer)state.getValue((Property)MOISTURE);
        if (!StellarFarmlandBlock.isStarlit((LevelReader)level, pos, firmament)) {
            if (i > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            }
        } else {
            BlockPos upPos;
            BlockState upState;
            Block block;
            if (i < 7) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
                StellarFarmlandBlock.hydrationParticles(level, pos);
            }
            if ((block = (upState = level.getBlockState(upPos = pos.above())).getBlock()) instanceof CropBlock) {
                int maxAge;
                CropBlock cropBlock = (CropBlock)block;
                int age = cropBlock.getAge(upState);
                if (age < (maxAge = cropBlock.getMaxAge())) {
                    for (int j = 0; j < 2; ++j) {
                        if (random.nextInt(77) != 0) continue;
                        cropBlock.growCrops((Level)level, upPos, upState);
                        age = cropBlock.getAge(upState);
                        StellarFarmlandBlock.hydrationParticles(level, pos);
                    }
                }
                if (!upState.is(OperationStarcleaveBlocks.BISREEDS)) {
                    boolean setBisreeds = false;
                    if (age == maxAge && random.nextInt(7) == 0) {
                        setBisreeds = true;
                    } else {
                        for (Direction direction : Direction.Plane.HORIZONTAL) {
                            Block block2;
                            BlockPos adjUpPos = upPos.offset(direction.getNormal());
                            BlockState adjUpState = level.getBlockState(adjUpPos);
                            if (!adjUpState.is(OperationStarcleaveBlocks.BISREEDS) || !((block2 = adjUpState.getBlock()) instanceof BisreedBlock)) continue;
                            BisreedBlock bisreedBlock = (BisreedBlock)block2;
                            int bisreedAge = bisreedBlock.getAge(adjUpState);
                            int bisreedMaxAge = bisreedBlock.getMaxAge();
                            if (random.nextInt(1 + 4 * (bisreedMaxAge - bisreedAge) + (maxAge - age)) > 3) continue;
                            setBisreeds = true;
                        }
                    }
                    if (setBisreeds) {
                        level.setBlock(upPos, OperationStarcleaveBlocks.BISREEDS.defaultBlockState(), 3);
                        level.playSeededSound(null, (double)upPos.getX(), (double)upPos.getY(), (double)upPos.getZ(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 0.1f, 1.6f + 0.4f * level.random.nextFloat(), level.random.nextLong());
                        StellarFarmlandBlock.hydrationParticles(level, pos);
                    }
                }
            }
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.causeFallDamage(fallDistance, 1.0f, entity.damageSources().fall());
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)MOISTURE) < 7) {
            return;
        }
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5 + 0.5;
        double z = (double)pos.getZ() + 0.5;
        for (int k = 0; k < 3; ++k) {
            level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER, x + (double)random.nextFloat() - 0.5, y, z + (double)random.nextFloat() - 0.5, (double)random.nextFloat() * 0.006 - 0.003, 0.002 + (double)random.nextFloat() * 0.005, (double)random.nextFloat() * 0.006 - 0.003);
        }
        for (Direction d : Direction.values()) {
            Vec3i v;
            BlockPos adjPos;
            BlockState adjState;
            if (d.getNormal().getY() != 0 || (adjState = level.getBlockState(adjPos = pos.offset(v = d.getNormal()))).is(this.asBlock()) && adjState.getProperties().contains(MOISTURE) && (Integer)adjState.getValue((Property)MOISTURE) == 7) continue;
            for (int k = 0; k < 12; ++k) {
                level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER, x + (v.getX() == 0 ? (double)random.nextFloat() - 0.5 : (double)v.getX() * 0.5), y, z + (v.getZ() == 0 ? (double)random.nextFloat() - 0.5 : (double)v.getZ() * 0.5), (double)random.nextFloat() * 0.006 - 0.003, 0.005 + (double)random.nextFloat() * 0.01, (double)random.nextFloat() * 0.006 - 0.003);
            }
        }
    }

    public static void hydrationParticles(ServerLevel level, BlockPos pos) {
        level.sendParticles((ParticleOptions)OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER, (double)pos.getX() + 0.5, (double)pos.getY() + 1.125, (double)pos.getZ() + 0.5, 120, 0.2, 0.0, 0.2, 0.01);
    }

    public static void setToSediment(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        BlockState blockState = StellarFarmlandBlock.pushEntitiesUp((BlockState)state, (BlockState)OperationStarcleaveBlocks.STELLAR_SEDIMENT.defaultBlockState(), (LevelAccessor)level, (BlockPos)pos);
        level.setBlockAndUpdate(pos, blockState);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockState));
    }

    public static boolean isStarlit(LevelReader worldView, BlockPos pos, Firmament firmament) {
        int skyLight = worldView.getBrightness(LightLayer.SKY, pos.above());
        if (skyLight <= 7) {
            return false;
        }
        int x = pos.getX();
        int z = pos.getZ();
        for (int i = -4; i <= 4; ++i) {
            for (int j = -4; j <= 4; ++j) {
                int damage = firmament.getDamage(x + i, z + j);
                if (damage < 6) continue;
                return true;
            }
        }
        return false;
    }
}

