/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.block.StellarSedimentBlock;
import phanastrae.operation_starcleave.world.starbleach.Starbleach;

public class StellarMulchBlock
extends StellarSedimentBlock {
    public static final MapCodec<StellarSedimentBlock> CODEC = StellarMulchBlock.simpleCodec(StellarMulchBlock::new);

    @Override
    public MapCodec<StellarSedimentBlock> codec() {
        return CODEC;
    }

    public StellarMulchBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    private static boolean stayAlive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.above();
        BlockState blockState = world.getBlockState(blockPos);
        int i = LightEngine.getLightBlockInto((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.getLightBlock((BlockGetter)world, blockPos));
        return i < world.getMaxLightLevel();
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!StellarMulchBlock.stayAlive(state, (LevelReader)world, pos)) {
            world.setBlockAndUpdate(pos, OperationStarcleaveBlocks.STELLAR_SEDIMENT.defaultBlockState());
        }
    }

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos posMutable = pos.mutable();
        for (int i = 0; i < 30; ++i) {
            posMutable.setWithOffset((Vec3i)pos, random.nextInt(5) - 2, random.nextInt(3) - 1, random.nextInt(5) - 2);
            BlockState targetState = world.getBlockState((BlockPos)posMutable);
            if (targetState.is(OperationStarcleaveBlocks.STELLAR_SEDIMENT)) {
                if (!world.getBlockState(posMutable.above()).isAir()) continue;
                world.setBlockAndUpdate((BlockPos)posMutable, OperationStarcleaveBlocks.STELLAR_MULCH.defaultBlockState());
                continue;
            }
            if (!targetState.canBeReplaced()) continue;
            Starbleach.decorate(world, (BlockPos)posMutable, 18, OperationStarcleaveBlocks.STELLAR_MULCH, OperationStarcleaveBlocks.MULCHBORNE_TUFT);
        }
    }
}

