/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityAttachment;

public class StellarRepulsorBlock
extends Block {
    public static final MapCodec<StellarRepulsorBlock> CODEC = StellarRepulsorBlock.simpleCodec(StellarRepulsorBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<StellarRepulsorBlock> codec() {
        return CODEC;
    }

    public StellarRepulsorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(ctx.getLevel().hasNeighborSignal(ctx.getClickedPos())));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean bl;
        if (!world.isClientSide && (bl = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != world.hasNeighborSignal(pos)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.causeFallDamage(fallDistance, 0.0f, world.damageSources().fall());
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            StellarRepulsorBlock.launch(entity);
        }
    }

    public static void tryLaunch(Entity entity) {
        BlockState blockState = entity.level().getBlockState(entity.blockPosition().below());
        if (blockState.is(OperationStarcleaveBlocks.STELLAR_REPULSOR)) {
            StellarRepulsorBlock.launch(entity);
        }
    }

    public static void launch(Entity entity) {
        long lastUseTime;
        OperationStarcleaveEntityAttachment osea = OperationStarcleaveEntityAttachment.fromEntity(entity);
        long worldTime = entity.level().getGameTime();
        long dt = worldTime - (lastUseTime = osea.getLastStellarRepulsorUse());
        if (0L <= dt && dt < 2L) {
            return;
        }
        osea.setLastStellarRepulsorUse(worldTime);
        if (entity.isControlledByLocalInstance()) {
            double horizontalSpeed;
            Vec3 vel = entity.getDeltaMovement();
            float yaw = entity.getYRot() * (float)java.lang.Math.PI / 180.0f;
            float cosYaw = Mth.cos((float)(-yaw));
            float sinYaw = Mth.sin((float)(-yaw));
            if (entity instanceof Minecart) {
                double vx = vel.x;
                double vz = vel.z;
                double v = Math.sqrt((double)(vx * vx + vz * vz));
                if (v > 0.001) {
                    vx /= v;
                    vz /= v;
                } else {
                    vx = 0.0;
                    vz = 0.0;
                }
                sinYaw = (float)vx;
                cosYaw = (float)vz;
            }
            if ((horizontalSpeed = Math.sqrt((double)(vel.x * vel.x + vel.z * vel.z)) * 3.0) < 4.0) {
                horizontalSpeed = 4.0;
            }
            double verticalSpeed = Math.max((double)vel.y, (double)(Math.sqrt((double)horizontalSpeed) * 0.4));
            entity.setDeltaMovement(horizontalSpeed * (double)sinYaw, verticalSpeed, horizontalSpeed * (double)cosYaw);
        }
        entity.level().playSeededSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, 0.6f + 0.4f * entity.level().random.nextFloat(), entity.level().random.nextLong());
    }
}

