/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;

public class StellarSedimentBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<StellarSedimentBlock> CODEC = StellarSedimentBlock.simpleCodec(StellarSedimentBlock::new);

    public MapCodec<StellarSedimentBlock> codec() {
        return CODEC;
    }

    public StellarSedimentBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return world.getBlockState(pos.above()).canBeReplaced();
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos posMutable = pos.mutable();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockState targetState;
                posMutable.setWithOffset((Vec3i)pos, x, 0, z);
                int x2 = x * x;
                int z2 = z * z;
                if (random.nextInt(1 + x2 + z2 + 2 * x2 * z2) != 0 || !(targetState = world.getBlockState((BlockPos)posMutable)).is(OperationStarcleaveBlocks.STELLAR_SEDIMENT) || !world.getBlockState(posMutable.above()).canBeReplaced()) continue;
                world.setBlockAndUpdate((BlockPos)posMutable, OperationStarcleaveBlocks.STELLAR_MULCH.defaultBlockState());
            }
        }
    }
}

