/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.LargeSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class LargeNuclearSmokeParticle
extends LargeSmokeParticle {
    protected LargeNuclearSmokeParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprites);
        this.hasPhysics = false;
    }

    public static class LargeNuclearSmokeFactory
    extends LargeSmokeParticle.Provider {
        private SpriteSet sprites;

        public LargeNuclearSmokeFactory(SpriteSet spriteProvider) {
            super(spriteProvider);
            this.sprites = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LargeNuclearSmokeParticle particle = new LargeNuclearSmokeParticle(clientLevel, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
            float l = clientLevel.random.nextFloat();
            float red = Mth.lerp((float)(l * l), (float)14.0f, (float)127.0f) / 255.0f;
            float green = Mth.lerp((float)(l * l), (float)56.0f, (float)212.0f) / 255.0f;
            float blue = Mth.lerp((float)(l * l), (float)25.0f, (float)36.0f) / 255.0f;
            particle.setColor(red, green, blue);
            particle.setParticleSpeed(xSpeed, ySpeed + 0.28, zSpeed);
            particle.scale(5.2f);
            particle.setLifetime(Mth.ceil((float)((float)particle.getLifetime() * (3.0f + 3.0f * clientLevel.getRandom().nextFloat()))));
            return particle;
        }
    }
}

