/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;

public class ScreenShakeManager {
    private static final ScreenShakeManager instance = new ScreenShakeManager();
    public float targetShakeAmount = 0.0f;
    public float shakeAmount = 0.0f;
    public float prevShakeAmount = 0.0f;

    public static ScreenShakeManager getInstance() {
        return instance;
    }

    public void update() {
        this.targetShakeAmount = (float)((double)this.targetShakeAmount - ((double)(this.targetShakeAmount * this.targetShakeAmount * this.targetShakeAmount) * 0.01 + 0.01));
        if (this.targetShakeAmount <= 0.0f) {
            this.targetShakeAmount = 0.0f;
        }
        this.prevShakeAmount = this.shakeAmount;
        this.shakeAmount = (float)((double)this.shakeAmount + (double)(this.targetShakeAmount - this.shakeAmount) * 0.2);
        if ((double)this.shakeAmount < 0.01) {
            this.shakeAmount = 0.0f;
        }
    }

    public void setShakeAmount(int shakeAmount) {
        this.targetShakeAmount = shakeAmount;
    }

    public float getCurrentShakeAmount(float tickDelta) {
        return this.prevShakeAmount + (this.shakeAmount - this.prevShakeAmount) * tickDelta;
    }

    public void updateScreenMatrices(PoseStack matrixStack, float tickDelta) {
        Minecraft minecraft = Minecraft.getInstance();
        Options options = minecraft.options;
        double damageTiltStrength = (Double)options.damageTiltStrength().get();
        double distortionEffectStrength = (Double)options.screenEffectScale().get();
        float shake = (float)((double)this.getCurrentShakeAmount(tickDelta) * damageTiltStrength * distortionEffectStrength * distortionEffectStrength);
        if (shake > 0.0f) {
            float t2 = (float)this.getTime() / 20.0f + tickDelta;
            double tpi = Math.PI * 2;
            matrixStack.mulPose(Axis.ZP.rotationDegrees((float)Math.sin((double)(3.0f * t2) * tpi) * shake));
            matrixStack.mulPose(Axis.XP.rotationDegrees((float)Math.sin((double)(2.0f * t2) * tpi + 0.5) * shake));
        }
    }

    public long getTime() {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return 0L;
        }
        return world.getGameTime();
    }
}

