/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;
import phanastrae.operation_starcleave.OperationStarcleave;
import phanastrae.operation_starcleave.client.render.OperationStarcleaveRenderLayers;
import phanastrae.operation_starcleave.client.render.entity.layers.SubcaelicTorpedoOverlayLayer;
import phanastrae.operation_starcleave.client.render.entity.model.OperationStarcleaveEntityModelLayers;
import phanastrae.operation_starcleave.client.render.entity.model.SubcaelicTorpedoEntityModel;
import phanastrae.operation_starcleave.entity.mob.SubcaelicTorpedoEntity;

public class SubcaelicTorpedoEntityRenderer
extends MobRenderer<SubcaelicTorpedoEntity, SubcaelicTorpedoEntityModel<SubcaelicTorpedoEntity>> {
    private static final ResourceLocation TEXTURE = OperationStarcleave.id("textures/entity/subcaelic_torpedo/subcaelic_torpedo.png");
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public SubcaelicTorpedoEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new SubcaelicTorpedoEntityModel(context.bakeLayer(OperationStarcleaveEntityModelLayers.SUBCAELIC_TORPEDO)), 0.7f);
        this.addLayer(new SubcaelicTorpedoOverlayLayer(this, context.getModelSet()));
    }

    public void render(SubcaelicTorpedoEntity entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        super.render((LivingEntity)entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
        if (entity.isPrimed()) {
            matrixStack.pushPose();
            matrixStack.translate(0.0, 0.5, 0.0);
            float l = entity.getClientFuseTime(tickDelta);
            float l2 = l * l * l * l;
            RandomSource random = RandomSource.create((long)432L);
            VertexConsumer vertexConsumer4 = vertexConsumerProvider.getBuffer(OperationStarcleaveRenderLayers.getSkyRay());
            float rayCount = (l + l2) / 2.0f * 25.0f;
            int n = 0;
            while ((float)n < rayCount) {
                matrixStack.pushPose();
                matrixStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f + l * 90.0f));
                float radius = 0.5f + 0.2f * random.nextFloat() + 6.0f * l2;
                float width = 0.4f + 0.2f * random.nextFloat() + 1.2f * l2;
                Matrix4f matrix4f = matrixStack.last().pose();
                int alpha = (int)(255.0f * (1.0f - l2));
                float twopi = (float)Math.PI * 2;
                float red = Mth.sin((float)n) * 0.2f + 0.8f;
                float green = Mth.sin((float)((float)n + 0.33333334f * twopi)) * 0.2f + 0.8f;
                float blue = Mth.sin((float)((float)n + 0.6666667f * twopi)) * 0.2f + 0.8f;
                int r = (int)(red * (float)alpha) & 0xFF;
                int g = (int)(green * (float)alpha) & 0xFF;
                int b = (int)(blue * (float)alpha) & 0xFF;
                SubcaelicTorpedoEntityRenderer.putDeathLightSourceVertex(vertexConsumer4, matrix4f, r, g, b);
                SubcaelicTorpedoEntityRenderer.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicTorpedoEntityRenderer.putDeathLightPositiveXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicTorpedoEntityRenderer.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicTorpedoEntityRenderer.putDeathLightSourceVertex(vertexConsumer4, matrix4f, r, g, b);
                SubcaelicTorpedoEntityRenderer.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicTorpedoEntityRenderer.putDeathLightPositiveZTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicTorpedoEntityRenderer.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicTorpedoEntityRenderer.putDeathLightSourceVertex(vertexConsumer4, matrix4f, r, g, b);
                SubcaelicTorpedoEntityRenderer.putDeathLightPositiveXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicTorpedoEntityRenderer.putDeathLightPositiveZTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicTorpedoEntityRenderer.putDeathLightPositiveXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                matrixStack.popPose();
                ++n;
            }
            matrixStack.popPose();
        }
    }

    private static void putDeathLightSourceVertex(VertexConsumer buffer, Matrix4f matrix, int r, int g, int b) {
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(r, g, b, 255);
    }

    private static void putDeathLightNegativeXTerminalVertex(VertexConsumer buffer, Matrix4f matrix, float radius, float width) {
        buffer.addVertex(matrix, -HALF_SQRT_3 * width, radius, -0.5f * width).setColor(0, 0, 0, 0);
    }

    private static void putDeathLightPositiveXTerminalVertex(VertexConsumer buffer, Matrix4f matrix, float radius, float width) {
        buffer.addVertex(matrix, HALF_SQRT_3 * width, radius, -0.5f * width).setColor(0, 0, 0, 0);
    }

    private static void putDeathLightPositiveZTerminalVertex(VertexConsumer buffer, Matrix4f matrix, float radius, float width) {
        buffer.addVertex(matrix, 0.0f, radius, 1.0f * width).setColor(0, 0, 0, 0);
    }

    protected void setupRotations(SubcaelicTorpedoEntity entity, PoseStack matrixStack, float animationProgress, float bodyYaw, float tickDelta, float scale) {
        float i = Mth.rotLerp((float)tickDelta, (float)entity.prevTiltAngle, (float)entity.tiltAngle);
        float j = Mth.rotLerp((float)tickDelta, (float)entity.prevRollAngle, (float)entity.rollAngle);
        matrixStack.translate(0.0f, 0.5f, 0.0f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - bodyYaw));
        matrixStack.mulPose(Axis.XP.rotationDegrees(i));
        matrixStack.mulPose(Axis.YP.rotationDegrees(j));
        matrixStack.translate(0.0f, -1.0f, 0.0f);
    }

    protected void scale(SubcaelicTorpedoEntity entity, PoseStack matrixStack, float f) {
        float g = entity.getClientFuseTime(f);
        float h = 1.0f + Mth.sin((float)(g * 100.0f)) * g * 0.01f;
        g = Mth.clamp((float)g, (float)0.0f, (float)1.0f);
        g *= g;
        g *= g;
        float i = (1.0f + g * 0.4f) * h;
        float j = (1.0f + g * 0.1f) / h;
        matrixStack.scale(i, j, i);
    }

    protected float getAttackAnim(SubcaelicTorpedoEntity entity, float f) {
        float g = entity.getClientFuseTime(f);
        return (int)(g * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)g, (float)0.5f, (float)1.0f);
    }

    protected float getBob(SubcaelicTorpedoEntity entity, float tickDelta) {
        float a = Mth.rotLerp((float)tickDelta, (float)entity.prevTentacleRollAngle, (float)entity.tentacleRollAngle);
        return 0.5f + 0.5f * (float)Math.sin(0.1f * a);
    }

    public ResourceLocation getTextureLocation(SubcaelicTorpedoEntity entity) {
        return TEXTURE;
    }
}

