/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import phanastrae.operation_starcleave.OperationStarcleave;
import phanastrae.operation_starcleave.client.render.entity.model.OperationStarcleaveEntityModelLayers;
import phanastrae.operation_starcleave.client.render.entity.model.SubcaelicTorpedoEntityModel;
import phanastrae.operation_starcleave.entity.mob.SubcaelicTorpedoEntity;

public class SubcaelicTorpedoOverlayLayer<T extends SubcaelicTorpedoEntity, M extends SubcaelicTorpedoEntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = OperationStarcleave.id("textures/entity/subcaelic_torpedo/subcaelic_torpedo_overlay.png");
    private final EntityModel<T> model;

    public SubcaelicTorpedoOverlayLayer(RenderLayerParent<T, M> context, EntityModelSet loader) {
        super(context);
        this.model = new SubcaelicTorpedoEntityModel(loader.bakeLayer(OperationStarcleaveEntityModelLayers.SUBCAELIC_TORPEDO_OVERLAY));
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, T torpedo, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        boolean bl;
        if (!((SubcaelicTorpedoEntity)((Object)torpedo)).isPrimed()) {
            return;
        }
        Minecraft minecraftClient = Minecraft.getInstance();
        boolean bl2 = bl = minecraftClient.shouldEntityAppearGlowing(torpedo) && torpedo.isInvisible();
        if (!torpedo.isInvisible() || bl) {
            VertexConsumer vertexConsumer = bl ? vertexConsumerProvider.getBuffer(RenderType.outline((ResourceLocation)this.getTextureLocation((SubcaelicTorpedoEntity)((Object)torpedo)))) : vertexConsumerProvider.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((SubcaelicTorpedoEntity)((Object)torpedo))));
            ((SubcaelicTorpedoEntityModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel(torpedo, limbAngle, limbDistance, tickDelta);
            this.model.setupAnim(torpedo, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            matrixStack.pushPose();
            float f = 0.02f;
            float fl = ((SubcaelicTorpedoEntity)((Object)torpedo)).getClientFuseTime(tickDelta) * 2.0f;
            float twopi = (float)Math.PI * 2;
            float red = Mth.sin((float)(fl * twopi)) * 0.4f + 0.6f;
            float green = Mth.sin((float)((fl + 0.33333334f) * twopi)) * 0.4f + 0.6f;
            float blue = Mth.sin((float)((fl + 0.6666667f) * twopi)) * 0.4f + 0.6f;
            torpedo.getRandom().setSeed((long)(fl * 65536.0f));
            matrixStack.translate((double)f * (torpedo.getRandom().nextDouble() * 2.0 - 1.0), (double)f * (torpedo.getRandom().nextDouble() * 2.0 - 1.0), (double)f * (torpedo.getRandom().nextDouble() * 2.0 - 1.0));
            int color = FastColor.ARGB32.colorFromFloat((float)red, (float)green, (float)blue, (float)1.0f);
            this.model.renderToBuffer(matrixStack, vertexConsumer, 0xF000F0, LivingEntityRenderer.getOverlayCoords(torpedo, (float)0.0f), color);
            matrixStack.popPose();
        }
    }

    protected ResourceLocation getTextureLocation(SubcaelicTorpedoEntity entity) {
        return TEXTURE;
    }
}

