/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.entity.model;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import phanastrae.operation_starcleave.entity.mob.SubcaelicDuxEntity;

public class SubcaelicDuxEntityModel<T extends SubcaelicDuxEntity>
extends HierarchicalModel<T> {
    public static final String BASE_TENTACLES = "base_tentacles";
    public static final String OUTER_TENTACLES = "outer_tentacles";
    public static final String HALO = "halo";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart baseTentacleRoot;
    private final ModelPart[] baseTentacles = new ModelPart[7];
    private final ModelPart outerTentacleRoot;
    private final ModelPart[] outerTentacles = new ModelPart[7];
    private final ModelPart halo;
    private final ModelPart[] leftWing = new ModelPart[3];
    private final ModelPart[] rightWing = new ModelPart[3];
    private final List<ModelPart> glowingParts;

    public SubcaelicDuxEntityModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.baseTentacleRoot = this.body.getChild(BASE_TENTACLES);
        Arrays.setAll(this.baseTentacles, index -> this.baseTentacleRoot.getChild(SubcaelicDuxEntityModel.getBaseTentacleName(index)));
        this.outerTentacleRoot = this.body.getChild(OUTER_TENTACLES);
        Arrays.setAll(this.outerTentacles, index -> this.outerTentacleRoot.getChild(SubcaelicDuxEntityModel.getOuterTentacleName(index)));
        this.halo = this.body.getChild(HALO);
        this.leftWing[0] = this.body.getChild(SubcaelicDuxEntityModel.getLeftWingName(0));
        this.leftWing[1] = this.leftWing[0].getChild(SubcaelicDuxEntityModel.getLeftWingName(1));
        this.leftWing[2] = this.leftWing[1].getChild(SubcaelicDuxEntityModel.getLeftWingName(2));
        this.rightWing[0] = this.body.getChild(SubcaelicDuxEntityModel.getRightWingName(0));
        this.rightWing[1] = this.rightWing[0].getChild(SubcaelicDuxEntityModel.getRightWingName(1));
        this.rightWing[2] = this.rightWing[1].getChild(SubcaelicDuxEntityModel.getRightWingName(2));
        this.glowingParts = ImmutableList.of((Object)this.leftWing[0], (Object)this.leftWing[1], (Object)this.leftWing[2], (Object)this.rightWing[0], (Object)this.rightWing[1], (Object)this.rightWing[2], (Object)this.halo);
    }

    private static String getBaseTentacleName(int index) {
        return "baseTentacle" + index;
    }

    private static String getOuterTentacleName(int index) {
        return "outerTentacle" + index;
    }

    private static String getLeftWingName(int index) {
        return "leftWing" + index;
    }

    private static String getRightWingName(int index) {
        return "rightWing" + index;
    }

    public static LayerDefinition getTexturedModelData() {
        double angle2;
        float z;
        float x;
        double angle;
        int k;
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -12.0f, -7.0f, 14.0f, 25.0f, 14.0f).texOffs(56, 0).addBox(-8.0f, -16.0f, 2.0f, 16.0f, 20.0f, 6.0f).texOffs(100, 0).addBox(-4.0f, -13.5f, -4.0f, 8.0f, 3.0f, 6.0f).texOffs(100, 9).addBox(5.5f, -14.0f, -6.0f, 2.0f, 14.0f, 8.0f).texOffs(100, 9).mirror().addBox(-7.5f, -14.0f, -6.0f, 2.0f, 14.0f, 8.0f).mirror(false), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition halo = body.addOrReplaceChild(HALO, CubeListBuilder.create().texOffs(0, 39).addBox(-10.0f, -10.0f, -0.5f, 20.0f, 20.0f, 1.0f), PartPose.offset((float)0.0f, (float)-11.0f, (float)13.5f));
        PartDefinition leftDoor = body.addOrReplaceChild("leftDoor", CubeListBuilder.create().texOffs(42, 39).addBox(-5.5f, -10.5f, -0.75f, 6.0f, 21.0f, 1.0f), PartPose.offset((float)5.5f, (float)0.5f, (float)-7.0f));
        PartDefinition rightDoor = body.addOrReplaceChild("rightDoor", CubeListBuilder.create().texOffs(42, 39).mirror().addBox(-0.5f, -10.5f, -0.75f, 6.0f, 21.0f, 1.0f).mirror(false), PartPose.offset((float)-5.5f, (float)0.5f, (float)-7.0f));
        PartDefinition leftWing0 = body.addOrReplaceChild(SubcaelicDuxEntityModel.getLeftWingName(0), CubeListBuilder.create().texOffs(72, 34).addBox(-1.5f, -11.5f, -0.5f, 9.0f, 23.0f, 1.0f), PartPose.offset((float)7.5f, (float)2.5f, (float)2.0f));
        PartDefinition leftWing1 = leftWing0.addOrReplaceChild(SubcaelicDuxEntityModel.getLeftWingName(1), CubeListBuilder.create().texOffs(92, 33).addBox(0.0f, -13.75f, -0.5f, 8.0f, 24.0f, 1.0f), PartPose.offset((float)7.5f, (float)5.25f, (float)0.0f));
        PartDefinition leftWing2 = leftWing1.addOrReplaceChild(SubcaelicDuxEntityModel.getLeftWingName(2), CubeListBuilder.create().texOffs(110, 32).addBox(0.0f, -12.5f, -0.5f, 8.0f, 25.0f, 1.0f), PartPose.offset((float)8.0f, (float)1.75f, (float)0.0f));
        PartDefinition rightWing0 = body.addOrReplaceChild(SubcaelicDuxEntityModel.getRightWingName(0), CubeListBuilder.create().texOffs(72, 34).mirror().addBox(-7.5f, -11.5f, -0.5f, 9.0f, 23.0f, 1.0f).mirror(false), PartPose.offset((float)-7.5f, (float)2.5f, (float)2.0f));
        PartDefinition rightWing1 = rightWing0.addOrReplaceChild(SubcaelicDuxEntityModel.getRightWingName(1), CubeListBuilder.create().texOffs(92, 33).mirror().addBox(-8.0f, -13.75f, -0.5f, 8.0f, 24.0f, 1.0f).mirror(false), PartPose.offset((float)-7.5f, (float)5.25f, (float)0.0f));
        PartDefinition rightWing2 = rightWing1.addOrReplaceChild(SubcaelicDuxEntityModel.getRightWingName(2), CubeListBuilder.create().texOffs(110, 32).mirror().addBox(-8.0f, -12.5f, -0.5f, 8.0f, 25.0f, 1.0f).mirror(false), PartPose.offset((float)-8.0f, (float)1.75f, (float)0.0f));
        PartDefinition baseTentacles = body.addOrReplaceChild(BASE_TENTACLES, CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition outerTentacles = body.addOrReplaceChild(OUTER_TENTACLES, CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        CubeListBuilder modelPartBuilder = CubeListBuilder.create().texOffs(56, 26).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 26.0f, 3.0f);
        for (k = 0; k < 7; ++k) {
            angle = Math.PI * 2 * (double)k / 7.0;
            x = (float)Math.sin(angle) * -6.0f;
            z = (float)Math.cos(angle) * -6.0f;
            angle2 = Math.PI * 2 * (double)k / 7.0;
            baseTentacles.addOrReplaceChild(SubcaelicDuxEntityModel.getBaseTentacleName(k), modelPartBuilder, PartPose.offsetAndRotation((float)x, (float)0.0f, (float)z, (float)0.0f, (float)((float)angle2), (float)0.0f));
        }
        modelPartBuilder = CubeListBuilder.create().texOffs(120, 9).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 21.0f, 2.0f);
        for (k = 0; k < 7; ++k) {
            angle = Math.PI * 2 * (double)k / 7.0;
            x = (float)Math.sin(angle) * 9.5f;
            z = (float)Math.cos(angle) * 9.5f;
            angle2 = Math.PI * 2 * (double)k / 7.0;
            outerTentacles.addOrReplaceChild(SubcaelicDuxEntityModel.getOuterTentacleName(k), modelPartBuilder, PartPose.offsetAndRotation((float)x, (float)0.0f, (float)z, (float)0.0f, (float)((float)angle2), (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)64);
    }

    public void setupAnim(SubcaelicDuxEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        for (ModelPart tentacle : this.baseTentacles) {
            tentacle.xRot = -0.15f * animationProgress;
        }
        for (ModelPart tentacle : this.outerTentacles) {
            tentacle.xRot = 0.3f * animationProgress;
        }
    }

    public void prepareMobModel(SubcaelicDuxEntity entity, float limbAngle, float limbDistance, float tickDelta) {
        float f = (float)Math.toRadians(Mth.rotLerp((float)tickDelta, (float)entity.prevTentacleRollAngle, (float)entity.tentacleRollAngle));
        this.baseTentacleRoot.yRot = -f;
        this.outerTentacleRoot.yRot = 2.0f * f;
        float g = 0.4f * (float)Math.sin(f);
        for (int i = 0; i < 3; ++i) {
            this.leftWing[i].yRot = g;
            this.rightWing[i].yRot = -g;
        }
        this.halo.zRot = (float)Math.toRadians(Mth.rotLerp((float)tickDelta, (float)entity.prevHaloAngle, (float)entity.haloAngle));
    }

    public ModelPart root() {
        return this.root;
    }

    public List<ModelPart> getGlowingParts() {
        return this.glowingParts;
    }
}

