/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import phanastrae.operation_starcleave.entity.mob.SubcaelicTorpedoEntity;

public class SubcaelicTorpedoEntityModel<T extends SubcaelicTorpedoEntity>
extends EntityModel<T> {
    public static final String TENTACLE_ROOT = "tentacle_root";
    private final ModelPart root;
    private final ModelPart tentacleRoot;
    private final ModelPart[] tentacles = new ModelPart[7];

    public SubcaelicTorpedoEntityModel(ModelPart root) {
        this.root = root;
        this.tentacleRoot = root.getChild(TENTACLE_ROOT);
        Arrays.setAll(this.tentacles, index -> this.tentacleRoot.getChild(SubcaelicTorpedoEntityModel.getTentacleName(index)));
    }

    private static String getTentacleName(int index) {
        return "tentacle" + index;
    }

    public static LayerDefinition getOverlayTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -8.0f, -6.0f, 12.0f, 16.0f, 12.0f, new CubeDeformation(0.52f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition tentacleRoot = root.addOrReplaceChild(TENTACLE_ROOT, CubeListBuilder.create(), PartPose.ZERO);
        CubeListBuilder modelPartBuilder = CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f, new CubeDeformation(0.5f));
        for (int k = 0; k < 7; ++k) {
            double d1 = (double)k * Math.PI * 2.0 / 7.0;
            float f = (float)Math.cos(d1) * 5.0f;
            float h = (float)Math.sin(d1) * 5.0f;
            double d2 = (double)k * Math.PI * -2.0 / 7.0 + 1.5707963267948966;
            float l = (float)d2;
            tentacleRoot.addOrReplaceChild(SubcaelicTorpedoEntityModel.getTentacleName(k), modelPartBuilder, PartPose.offsetAndRotation((float)f, (float)15.0f, (float)h, (float)0.0f, (float)l, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)32);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -8.0f, -6.0f, 12.0f, 16.0f, 12.0f, new CubeDeformation(0.02f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition tentacleRoot = root.addOrReplaceChild(TENTACLE_ROOT, CubeListBuilder.create(), PartPose.ZERO);
        CubeListBuilder modelPartBuilder = CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f);
        for (int k = 0; k < 7; ++k) {
            double d1 = (double)k * Math.PI * 2.0 / 7.0;
            float f = (float)Math.cos(d1) * 5.0f;
            float h = (float)Math.sin(d1) * 5.0f;
            double d2 = (double)k * Math.PI * -2.0 / 7.0 + 1.5707963267948966;
            float l = (float)d2;
            tentacleRoot.addOrReplaceChild(SubcaelicTorpedoEntityModel.getTentacleName(k), modelPartBuilder, PartPose.offsetAndRotation((float)f, (float)15.0f, (float)h, (float)0.0f, (float)l, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)32);
    }

    public void setupAnim(SubcaelicTorpedoEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        for (ModelPart tentacle : this.tentacles) {
            tentacle.xRot = 0.1f * animationProgress;
        }
    }

    public void prepareMobModel(SubcaelicTorpedoEntity entity, float limbAngle, float limbDistance, float tickDelta) {
        this.tentacleRoot.yRot = -((float)Math.toRadians(Mth.rotLerp((float)tickDelta, (float)entity.prevTentacleRollAngle, (float)entity.tentacleRollAngle)));
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.root.render(matrices, vertices, light, overlay, color);
    }
}

