/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.firmament;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import phanastrae.operation_starcleave.OperationStarcleave;
import phanastrae.operation_starcleave.client.duck.LevelRendererDuck;
import phanastrae.operation_starcleave.client.render.OperationStarcleaveRenderLayers;
import phanastrae.operation_starcleave.client.render.firmament.FirmamentTextureStorage;
import phanastrae.operation_starcleave.world.firmament.Firmament;
import phanastrae.operation_starcleave.world.firmament.RegionPos;

public class FirmamentRenderer {
    public static Matrix4f LAST_POSITION_MATRIX = new Matrix4f();
    @Nullable
    private static VertexBuffer STARS_BUFFER;
    @Nullable
    private static VertexBuffer LIGHT_SKY_BUFFER;

    public static void close() {
        FirmamentRenderer.closeIfNotNull(STARS_BUFFER);
        FirmamentRenderer.closeIfNotNull(LIGHT_SKY_BUFFER);
    }

    private static void closeIfNotNull(VertexBuffer vertexBuffer) {
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
    }

    private static void createStars() {
        FirmamentRenderer.closeIfNotNull(STARS_BUFFER);
        STARS_BUFFER = new VertexBuffer(VertexBuffer.Usage.STATIC);
        STARS_BUFFER.bind();
        STARS_BUFFER.upload(FirmamentRenderer.createStars(Tesselator.getInstance()));
        VertexBuffer.unbind();
    }

    private static void createLightSky() {
        FirmamentRenderer.closeIfNotNull(LIGHT_SKY_BUFFER);
        LIGHT_SKY_BUFFER = new VertexBuffer(VertexBuffer.Usage.STATIC);
        LIGHT_SKY_BUFFER.bind();
        LIGHT_SKY_BUFFER.upload(FirmamentRenderer.createLightSky(Tesselator.getInstance(), 16.0f));
        VertexBuffer.unbind();
    }

    private static MeshData createStars(Tesselator tessellator) {
        RandomSource random = RandomSource.create((long)1025L);
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        int STAR_COUNT = 6120;
        for (int j = 0; j < STAR_COUNT; ++j) {
            float z;
            float y;
            float x = random.nextFloat() * 2.0f - 1.0f;
            float m = Mth.lengthSquared((float)x, (float)(y = random.nextFloat() * 2.0f - 1.0f), (float)(z = random.nextFloat() * 2.0f - 1.0f));
            if (m <= 0.010000001f || m >= 1.0f) continue;
            Vector3f vector3f = new Vector3f(x, y, z).normalize(100.0f);
            float zAngle = (float)(random.nextDouble() * 3.1415927410125732 * 2.0);
            Quaternionf quaternionf = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)vector3f).rotateZ(zAngle);
            float phase = random.nextFloat();
            float red = 0.5f + 0.3f * (float)Math.sin((float)Math.PI * 2 * phase);
            float green = 0.5f + 0.3f * (float)Math.sin((float)Math.PI * 2 * (phase + 0.33333334f));
            float blue = 0.5f + 0.3f * (float)Math.sin((float)Math.PI * 2 * (phase - 0.33333334f));
            float l = 0.15f + random.nextFloat() * 0.1f;
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(l, -l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(red, green, blue, 1.0f);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(l, l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(red, green, blue, 1.0f);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-l, l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(red, green, blue, 1.0f);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-l, -l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(red, green, blue, 1.0f);
        }
        return bufferBuilder.buildOrThrow();
    }

    private static MeshData createLightSky(Tesselator tessellator, float f) {
        float g = Math.signum(f) * 512.0f;
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        bufferBuilder.addVertex(0.0f, f, 0.0f);
        for (int i = -180; i <= 180; i += 45) {
            bufferBuilder.addVertex(g * Mth.cos((float)((float)i * ((float)Math.PI / 180))), f, 512.0f * Mth.sin((float)((float)i * ((float)Math.PI / 180))));
        }
        return bufferBuilder.buildOrThrow();
    }

    public static void render(Level level, Camera camera, Frustum frustum, LevelRenderer levelRenderer, Matrix4f projectionMatrix, Matrix4f positionMatrix) {
        boolean renderSkybox;
        Minecraft client = Minecraft.getInstance();
        if (client.gameRenderer.getMainCamera().equals(camera)) {
            LAST_POSITION_MATRIX.set((Matrix4fc)positionMatrix);
        }
        if (frustum == null || camera == null) {
            return;
        }
        Firmament firmament = Firmament.fromLevel(level);
        if (firmament == null) {
            return;
        }
        ProfilerFiller profiler = client.getProfiler();
        profiler.push("starcleave_firmament");
        profiler.push("check");
        double camx = camera.getPosition().x;
        double camz = camera.getPosition().z;
        double firmHeight = firmament.getY();
        AABB box = new AABB(camx - 512.0, firmHeight - 1.0, camz - 512.0, camx + 512.0, firmHeight + 1.0, camz + 512.0);
        if (frustum.isVisible(box) && (renderSkybox = FirmamentTextureStorage.getInstance().isAnyFilledAndActive())) {
            profiler.popPush("sky");
            RenderTarget firmamentFrameBuffer = ((LevelRendererDuck)levelRenderer).operation_starcleave$getFirmamentFramebuffer();
            firmamentFrameBuffer.setClearColor(0.0f, 0.08f, 0.08f, 1.0f);
            firmamentFrameBuffer.clear(Minecraft.ON_OSX);
            Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
            OperationStarcleaveRenderLayers.FIRMAMENT_SKY_TARGET.setupRenderState();
            PoseStack matrixStack = new PoseStack();
            matrixStack.mulPose(positionMatrix);
            FirmamentRenderer.renderFirmamentSky(matrixStack, projectionMatrix);
            OperationStarcleaveRenderLayers.FIRMAMENT_SKY_TARGET.clearRenderState();
            profiler.popPush("fracture");
            FirmamentRenderer.renderBakedSubRegions(levelRenderer, firmament, camera, projectionMatrix, positionMatrix);
        }
        profiler.pop();
        profiler.pop();
    }

    public static void renderFirmamentSky(PoseStack matrices, Matrix4f projectionMatrix) {
        Matrix4f matrix4f2;
        int col;
        float blue;
        float green;
        float red;
        float fl;
        float angle;
        int n;
        int i;
        VertexBuffer vb1;
        if (STARS_BUFFER == null) {
            FirmamentRenderer.createStars();
        }
        if (LIGHT_SKY_BUFFER == null) {
            FirmamentRenderer.createLightSky();
        }
        if ((vb1 = LIGHT_SKY_BUFFER) != null && !vb1.isInvalid()) {
            float[] fogColor = RenderSystem.getShaderFogColor();
            float fog0 = fogColor[0];
            float fog1 = fogColor[1];
            float fog2 = fogColor[2];
            float fog3 = fogColor[3];
            RenderSystem.setShaderFogColor((float)0.0f, (float)0.08f, (float)0.08f, (float)1.0f);
            matrices.pushPose();
            matrices.translate(0.0f, 20.0f, 0.0f);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)0.15f, (float)0.12f, (float)0.08f, (float)1.0f);
            vb1.bind();
            vb1.drawWithShader(matrices.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
            matrices.translate(0.0f, -30.0f, 0.0f);
            RenderSystem.setShaderColor((float)0.0f, (float)0.08f, (float)0.08f, (float)1.0f);
            vb1.drawWithShader(matrices.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
            VertexBuffer.unbind();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            matrices.popPose();
            RenderSystem.setShaderFogColor((float)fog0, (float)fog1, (float)fog2, (float)fog3);
        }
        float fogStart = RenderSystem.getShaderFogStart();
        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
        float[] rs = new float[]{0.8f, 1.0f, 1.0f};
        float[] gs = new float[]{1.0f, 0.8f, 1.0f};
        float[] bs = new float[]{1.0f, 1.0f, 0.8f};
        VertexBuffer vb = STARS_BUFFER;
        if (vb != null && !vb.isInvalid()) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            for (int i2 = 0; i2 < 12; ++i2) {
                int j = i2 % 3;
                int k = i2 / 3;
                int n2 = 20000 * (k + 1);
                matrices.pushPose();
                float angle2 = ((float)(System.currentTimeMillis() % (long)n2) / (float)n2 + (float)i2 / 12.0f) * 2.0f * (float)Math.PI;
                matrices.translate(0.0f, Mth.sin((float)angle2) * 20.0f * (float)k, 0.0f);
                matrices.mulPose(new Quaternionf().rotateY(angle2).rotateZ(Mth.sin((float)angle2) * 0.2f * (float)k));
                RenderSystem.setShaderColor((float)rs[j], (float)gs[j], (float)bs[j], (float)0.75f);
                vb.bind();
                vb.drawWithShader(matrices.last().pose(), projectionMatrix, GameRenderer.getPositionColorShader());
                matrices.popPose();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VertexBuffer.unbind();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
        RenderSystem.depthMask((boolean)false);
        Tesselator tessellator = Tesselator.getInstance();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float k2 = 50.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        long time = System.currentTimeMillis();
        RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)OperationStarcleave.id("textures/environment/starry_eye_light.png"));
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (i = 0; i < 7; ++i) {
            matrices.pushPose();
            n = 300000;
            angle = ((float)(time * 2L % (long)n) / (float)n + (float)i / 7.0f) * (float)Math.PI * 2.0f;
            matrices.translate(0.0f, -50.0f, 0.0f);
            matrices.mulPose(new Quaternionf().rotateY(-angle));
            matrices.translate(-17.0f, 0.0f, -17.0f);
            matrices.mulPose(new Quaternionf().rotateX(0.35f));
            fl = (float)(time % 4000L) / 4000.0f + (float)i / 7.0f;
            red = Mth.sin((float)(fl * ((float)Math.PI * 2))) * 0.2f + 0.8f;
            green = Mth.sin((float)((fl + 0.33333334f) * ((float)Math.PI * 2))) * 0.2f + 0.8f;
            blue = Mth.sin((float)((fl + 0.6666667f) * ((float)Math.PI * 2))) * 0.2f + 0.8f;
            col = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)red, (float)green, (float)blue);
            matrix4f2 = matrices.last().pose();
            bufferBuilder.addVertex(matrix4f2, -k2, 100.0f, -k2).setUv(0.0f, 0.0f).setColor(col);
            bufferBuilder.addVertex(matrix4f2, k2, 100.0f, -k2).setUv(1.0f, 0.0f).setColor(col);
            bufferBuilder.addVertex(matrix4f2, k2, 100.0f, k2).setUv(1.0f, 1.0f).setColor(col);
            bufferBuilder.addVertex(matrix4f2, -k2, 100.0f, k2).setUv(0.0f, 1.0f).setColor(col);
            matrices.popPose();
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)OperationStarcleave.id("textures/environment/starry_eye.png"));
        bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (i = 0; i < 7; ++i) {
            matrices.pushPose();
            n = 300000;
            angle = ((float)(time % (long)n) / (float)n + (float)i / 7.0f) * (float)Math.PI * 2.0f;
            matrices.mulPose(new Quaternionf().rotateY(-angle));
            matrices.translate(13.0f, 0.0f, 0.0f);
            fl = (float)(time % 4000L) / 4000.0f + (float)i / 7.0f;
            red = Mth.sin((float)(fl * ((float)Math.PI * 2))) * 0.2f + 0.8f;
            green = Mth.sin((float)((fl + 0.33333334f) * ((float)Math.PI * 2))) * 0.2f + 0.8f;
            blue = Mth.sin((float)((fl + 0.6666667f) * ((float)Math.PI * 2))) * 0.2f + 0.8f;
            col = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)red, (float)green, (float)blue);
            matrix4f2 = matrices.last().pose();
            bufferBuilder.addVertex(matrix4f2, -k2, 100.0f, -k2).setUv(0.0f, 0.0f).setColor(col);
            bufferBuilder.addVertex(matrix4f2, k2, 100.0f, -k2).setUv(1.0f, 0.0f).setColor(col);
            bufferBuilder.addVertex(matrix4f2, k2, 100.0f, k2).setUv(1.0f, 1.0f).setColor(col);
            bufferBuilder.addVertex(matrix4f2, -k2, 100.0f, k2).setUv(0.0f, 1.0f).setColor(col);
            matrices.popPose();
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderFogStart((float)fogStart);
    }

    public static void renderBakedSubRegions(LevelRenderer levelRenderer, Firmament firmament, Camera camera, Matrix4f projectionMatrix, Matrix4f positionMatrix) {
        RenderType renderLayer = OperationStarcleaveRenderLayers.getFracture();
        renderLayer.setupRenderState();
        ShaderInstance shaderProgram = RenderSystem.getShader();
        if (shaderProgram != null) {
            int currentTexID0 = RenderSystem.getShaderTexture((int)0);
            DynamicTexture firmamentTex = FirmamentTextureStorage.getInstance().getTexture();
            RenderSystem.setShaderTexture((int)0, (int)firmamentTex.getId());
            firmamentTex.bind();
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
            int currentTexID1 = RenderSystem.getShaderTexture((int)1);
            RenderTarget firmamentFrameBuffer = ((LevelRendererDuck)levelRenderer).operation_starcleave$getFirmamentFramebuffer();
            int firmamentSkyTexID = firmamentFrameBuffer.getColorTextureId();
            RenderSystem.setShaderTexture((int)1, (int)firmamentSkyTexID);
            shaderProgram.setDefaultUniforms(VertexFormat.Mode.QUADS, positionMatrix, projectionMatrix, Minecraft.getInstance().getWindow());
            shaderProgram.apply();
            MeshData meshData = FirmamentRenderer.createMeshData(camera, firmament);
            BufferUploader.draw((MeshData)meshData);
            VertexBuffer.unbind();
            shaderProgram.clear();
            RenderSystem.setShaderTexture((int)0, (int)currentTexID0);
            RenderSystem.setShaderTexture((int)1, (int)currentTexID1);
        }
        renderLayer.clearRenderState();
    }

    private static MeshData createMeshData(Camera camera, Firmament firmament) {
        Vec3 camPos = camera.getPosition();
        RegionPos regionPos = RegionPos.fromWorldCoords(Mth.floor((double)camPos.x), Mth.floor((double)camPos.z));
        int height = firmament.getY();
        double relX = (double)regionPos.worldX - camPos.x;
        double relY = (double)height + 0.0625 - camPos.y;
        double relZ = (double)regionPos.worldZ - camPos.z;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float ox = (float)((double)(512 * i) + relX);
                float oy = (float)relY;
                float oz = (float)((double)(512 * j) + relZ);
                float u1 = (float)((regionPos.rx + i) % 4) / 4.0f;
                float v1 = (float)((regionPos.rz + j) % 4) / 4.0f;
                float u2 = u1 + 0.25f;
                float v2 = v1 + 0.25f;
                bufferBuilder.addVertex(ox, oy, oz).setColor(255, 255, 255, 255).setUv(u1, v1).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
                bufferBuilder.addVertex(ox + 512.0f, oy, oz).setColor(255, 255, 255, 255).setUv(u2, v1).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
                bufferBuilder.addVertex(ox + 512.0f, oy, oz + 512.0f).setColor(255, 255, 255, 255).setUv(u2, v2).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
                bufferBuilder.addVertex(ox, oy, oz + 512.0f).setColor(255, 255, 255, 255).setUv(u1, v2).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
                bufferBuilder.addVertex(ox, oy, oz + 512.0f).setColor(255, 255, 255, 255).setUv(u1, v2).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
                bufferBuilder.addVertex(ox + 512.0f, oy, oz + 512.0f).setColor(255, 255, 255, 255).setUv(u2, v2).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
                bufferBuilder.addVertex(ox + 512.0f, oy, oz).setColor(255, 255, 255, 255).setUv(u2, v1).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
                bufferBuilder.addVertex(ox, oy, oz).setColor(255, 255, 255, 255).setUv(u1, v1).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
            }
        }
        return bufferBuilder.buildOrThrow();
    }
}

