/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.shader;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import phanastrae.operation_starcleave.client.duck.LevelRendererDuck;
import phanastrae.operation_starcleave.client.render.firmament.FirmamentRenderer;
import phanastrae.operation_starcleave.client.render.firmament.FirmamentTextureStorage;
import phanastrae.operation_starcleave.client.render.shader.OperationStarcleaveShaders;
import phanastrae.operation_starcleave.world.firmament.Firmament;

public class FirmamentPostShader {
    public static void draw() {
        Minecraft client = Minecraft.getInstance();
        ProfilerFiller profiler = client.getProfiler();
        profiler.push("starcleave_post_effect");
        LevelRenderer levelRenderer = client.levelRenderer;
        if (levelRenderer instanceof LevelRendererDuck) {
            LevelRendererDuck operationStarcleaveWorldRenderer = (LevelRendererDuck)levelRenderer;
            RenderTarget mainBuffer = client.getMainRenderTarget();
            RenderTarget dummyBuffer = operationStarcleaveWorldRenderer.operation_starcleave$getDummyFramebuffer();
            if (dummyBuffer != null && FirmamentPostShader.canDraw()) {
                RenderSystem.enableBlend();
                RenderSystem.disableBlend();
                dummyBuffer.bindWrite(true);
                RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
                dummyBuffer.unbindWrite();
                dummyBuffer.bindWrite(true);
                RenderSystem.backupProjectionMatrix();
                mainBuffer.blitToScreen(client.getWindow().getWidth(), client.getWindow().getHeight(), false);
                RenderSystem.restoreProjectionMatrix();
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                dummyBuffer.copyDepthFrom(mainBuffer);
                mainBuffer.bindWrite(true);
                FirmamentPostShader.draw2(client.getWindow().getWidth(), client.getWindow().getHeight(), false);
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
            }
        }
        profiler.pop();
    }

    public static boolean canDraw() {
        if (!FirmamentTextureStorage.getInstance().shouldRenderPostOnGraphicsMode()) {
            return false;
        }
        return FirmamentTextureStorage.getInstance().isAnyFilledAndActive();
    }

    public static void draw2(int width, int height, boolean disableBlend) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> FirmamentPostShader.drawInternal(width, height, disableBlend));
        } else {
            FirmamentPostShader.drawInternal(width, height, disableBlend);
        }
    }

    private static void drawInternal(int width, int height, boolean disableBlend) {
        Minecraft client = Minecraft.getInstance();
        LevelRenderer levelRenderer = client.levelRenderer;
        if (!(levelRenderer instanceof LevelRendererDuck)) {
            return;
        }
        LevelRendererDuck operationStarcleaveWorldRenderer = (LevelRendererDuck)levelRenderer;
        RenderTarget dummyBuffer = operationStarcleaveWorldRenderer.operation_starcleave$getDummyFramebuffer();
        if (dummyBuffer == null) {
            return;
        }
        ClientLevel world = client.level;
        if (world == null) {
            return;
        }
        Firmament firmament = Firmament.fromLevel((Level)world);
        if (firmament == null) {
            return;
        }
        ShaderInstance shaderProgram = OperationStarcleaveShaders.getFracturePostShader();
        if (shaderProgram == null) {
            return;
        }
        GameRenderer gameRenderer = client.gameRenderer;
        RenderSystem.assertOnRenderThread();
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._viewport((int)0, (int)0, (int)width, (int)height);
        if (disableBlend) {
            GlStateManager._disableBlend();
        }
        shaderProgram.setSampler("DiffuseSampler0", (Object)dummyBuffer.getColorTextureId());
        shaderProgram.setSampler("DiffuseSampler1", (Object)dummyBuffer.getDepthTextureId());
        DynamicTexture firmamentTex = FirmamentTextureStorage.getInstance().getTexture();
        RenderSystem.setShaderTexture((int)0, (int)firmamentTex.getId());
        firmamentTex.bind();
        RenderSystem.texParameter((int)3553, (int)10241, (int)9987);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        for (int m = 0; m < 1; ++m) {
            int n = RenderSystem.getShaderTexture((int)m);
            shaderProgram.setSampler("Sampler" + m, (Object)n);
        }
        Uniform glUniform = shaderProgram.getUniform("IMat");
        if (glUniform != null) {
            PoseStack matrices = new PoseStack();
            matrices.mulPose(FirmamentRenderer.LAST_POSITION_MATRIX);
            Matrix4f mat = new Matrix4f();
            mat.mul((Matrix4fc)RenderSystem.getProjectionMatrix());
            mat.mul((Matrix4fc)matrices.last().pose());
            mat.invert();
            glUniform.set(mat);
        }
        if ((glUniform = shaderProgram.getUniform("FirmamentPos")) != null) {
            Vec3 camPos = client.gameRenderer.getMainCamera().getPosition();
            Vector3f firmamentPos = new Vector3f((float)(-Mth.positiveModulo((double)camPos.x, (double)2048.0)), (float)((double)firmament.getY() - camPos.y), (float)(-Mth.positiveModulo((double)camPos.z, (double)2048.0)));
            glUniform.set(firmamentPos);
        }
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        if (shaderProgram.MODEL_VIEW_MATRIX != null) {
            shaderProgram.MODEL_VIEW_MATRIX.set(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        }
        if (shaderProgram.PROJECTION_MATRIX != null) {
            shaderProgram.PROJECTION_MATRIX.set(matrix4f);
        }
        if (shaderProgram.GAME_TIME != null) {
            shaderProgram.GAME_TIME.set(RenderSystem.getShaderGameTime());
        }
        shaderProgram.apply();
        float f = width;
        float g = height;
        float h = (float)dummyBuffer.viewWidth / (float)dummyBuffer.width;
        float i = (float)dummyBuffer.viewHeight / (float)dummyBuffer.height;
        Tesselator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.addVertex(0.0f, g, 0.0f).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255);
        bufferBuilder.addVertex(f, g, 0.0f).setUv(h, 0.0f).setColor(255, 255, 255, 255);
        bufferBuilder.addVertex(f, 0.0f, 0.0f).setUv(h, i).setColor(255, 255, 255, 255);
        bufferBuilder.addVertex(0.0f, 0.0f, 0.0f).setUv(0.0f, i).setColor(255, 255, 255, 255);
        BufferUploader.draw((MeshData)bufferBuilder.buildOrThrow());
        shaderProgram.clear();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }
}

