/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import phanastrae.operation_starcleave.block.StellarFarmlandBlock;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityTypes;
import phanastrae.operation_starcleave.entity.projectile.NuclearStardropEntity;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.world.firmament.Firmament;

public class NuclearStormcloudEntity
extends Entity {
    public static String KEY_AGE = "age";
    private int age;

    public NuclearStormcloudEntity(EntityType<? extends NuclearStormcloudEntity> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public NuclearStormcloudEntity(Level level, double x, double y, double z) {
        this(OperationStarcleaveEntityTypes.NUCLEAR_STORMCLOUD, level);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt(KEY_AGE, this.age);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains(KEY_AGE, 3)) {
            this.age = tag.getInt(KEY_AGE);
        }
    }

    public void tick() {
        boolean starlit;
        super.tick();
        Level level = this.level();
        RandomSource random = this.getRandom();
        if (level.isClientSide()) {
            this.spawnParticles();
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!level.isClientSide()) {
            this.adjustVelocity();
            if (this.age > 60 && (random.nextInt(49) == 0 || this.age % 49 == 0)) {
                this.launchSeed();
            }
        }
        ++this.age;
        Firmament firmament = Firmament.fromLevel(level);
        boolean bl = starlit = firmament != null && StellarFarmlandBlock.isStarlit((LevelReader)level, this.blockPosition(), firmament);
        if (!starlit) {
            this.age += 8;
        }
        if (!level.isClientSide() && this.age >= 1000) {
            this.discard();
        }
    }

    public void spawnParticles() {
        int i;
        Level level = this.level();
        RandomSource random = this.getRandom();
        for (i = 0; i < 30; ++i) {
            level.addParticle((ParticleOptions)(random.nextInt(20) == 0 ? OperationStarcleaveParticleTypes.LARGE_GLIMMER_SMOKE : OperationStarcleaveParticleTypes.NUCLEAR_SMOKE), this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() / 2.0f), this.getY() + (double)(random.nextFloat() * 2.0f * this.getBbHeight()), this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() / 2.0f), random.nextGaussian() * 0.15, random.nextGaussian() * 0.15, random.nextGaussian() * 0.15);
        }
        if (random.nextInt(3) == 0) {
            level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.LARGE_NUCLEAR_SMOKE, true, this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() / 2.0f), this.getY() + (double)(random.nextFloat() * 2.0f * this.getBbHeight()), this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() / 2.0f), random.nextGaussian() * 0.15, random.nextGaussian() * 0.15, random.nextGaussian() * 0.15);
        }
        for (i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.PLASMA_DUST, this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() / 2.0f), this.getY() + 0.25 * (double)(random.nextFloat() * 2.0f) * (double)this.getBbHeight(), this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() / 2.0f), random.nextGaussian() * 0.15, random.nextGaussian() * 0.05, random.nextGaussian() * 0.15);
        }
    }

    public void adjustVelocity() {
        Level level = this.level();
        RandomSource random = this.getRandom();
        int height = level.getHeight(Heightmap.Types.MOTION_BLOCKING, this.getBlockX(), this.getBlockZ());
        int targetHeight = height + 9;
        double yDif = (double)targetHeight - this.getY();
        double targetYaw = (double)random.nextFloat() * (Math.PI * 2);
        double cosYaw = Math.cos(targetYaw);
        double sinYaw = Math.sin(targetYaw);
        double vy = yDif * 0.07;
        float maxVY = 1.5f;
        if (Math.abs(vy) > (double)maxVY) {
            vy = (double)maxVY * vy / Math.abs(vy);
        }
        Vec3 targetVelocity = new Vec3(cosYaw, vy, sinYaw);
        Vec3 currentVelocity = this.getDeltaMovement();
        Vec3 newVelocity = currentVelocity.lerp(targetVelocity, 0.05);
        float targetSpeed = 0.4f;
        Vec3 newHorizontalVelocity = newVelocity.multiply(1.0, 0.0, 1.0).normalize().scale((double)targetSpeed);
        this.setDeltaMovement(newHorizontalVelocity.x, newVelocity.y * 0.97, newHorizontalVelocity.z);
    }

    public void launchSeed() {
        Level level = this.level();
        RandomSource random = this.getRandom();
        Vec3 startPos = new Vec3(this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() / 2.0f), this.getY() + (double)(0.25f * random.nextFloat() * this.getBbHeight()), this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() / 2.0f));
        NuclearStardropEntity stardrop = new NuclearStardropEntity(startPos.x, startPos.y, startPos.z, Vec3.ZERO, level);
        stardrop.shoot(0.0, -1.0, 0.0, 0.5f, 10.0f);
        level.addFreshEntity((Entity)stardrop);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }
}

