/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.entity.mob;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.world.firmament.Firmament;

public abstract class AbstractSubcaelicEntity
extends Mob
implements Enemy {
    public float tiltAngle;
    public float prevTiltAngle;
    public float rollAngle;
    public float prevRollAngle;
    public float tentacleRollAngle;
    public float prevTentacleRollAngle;

    protected AbstractSubcaelicEntity(EntityType<? extends AbstractSubcaelicEntity> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new SubcaelicMoveControl(this);
    }

    public void travel(Vec3 movementInput) {
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void aiStep() {
        super.aiStep();
        this.prevTiltAngle = this.tiltAngle;
        this.prevRollAngle = this.rollAngle;
        this.prevTentacleRollAngle = this.tentacleRollAngle;
        if (this.shouldTickAngles()) {
            Vec3 velocity = this.getDeltaMovement();
            double horizontalSpeed = velocity.horizontalDistance();
            if (horizontalSpeed > 0.01) {
                double targetYaw = Math.toDegrees(-Mth.atan2((double)velocity.x, (double)velocity.z));
                this.yBodyRot = (float)Mth.rotLerp((double)0.2, (double)this.yBodyRot, (double)targetYaw);
                this.setYRot(this.yBodyRot);
            }
            this.rollAngle += 4.712389f;
            this.tentacleRollAngle += 5.4977875f;
            this.tiltAngle = (float)((double)this.tiltAngle + (Math.toDegrees(-Mth.atan2((double)horizontalSpeed, (double)velocity.y)) - (double)this.tiltAngle) * (double)0.1f);
            this.setXRot(-this.tiltAngle - 90.0f);
            if (this.level().isClientSide) {
                this.spawnTrailParticles();
            }
        }
    }

    protected boolean shouldTickAngles() {
        return this.isAlive();
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    public boolean onClimbable() {
        return false;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.GLOW_SQUID_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.GLOW_SQUID_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GLOW_SQUID_DEATH;
    }

    protected float getSoundVolume() {
        return 2.0f;
    }

    public void spawnTrailParticles() {
        Vec3 spawnCenter = this.position().add(0.0, (double)this.getBbHeight() * 0.5, 0.0).subtract(this.getLookAngle().scale((double)this.getBbWidth() * 0.5));
        double f = (double)this.getBbWidth() * 0.2;
        int count = (int)((double)(this.getBbWidth() * 10.0f) * Math.min(1.0, 2.0 * this.getDeltaMovement().length()));
        for (int i = 0; i < count; ++i) {
            double x = spawnCenter.x + (this.random.nextDouble() - 0.5) * f;
            double y = spawnCenter.y + (this.random.nextDouble() - 0.5) * f;
            double z = spawnCenter.z + (this.random.nextDouble() - 0.5) * f;
            this.level().addParticle((ParticleOptions)OperationStarcleaveParticleTypes.GLIMMER_SMOKE, x, y, z, this.getDeltaMovement().x * -1.5, this.getDeltaMovement().y * -1.5, this.getDeltaMovement().z * -1.5);
        }
    }

    public abstract double getTurnFactor();

    static class SubcaelicMoveControl
    extends MoveControl {
        private final AbstractSubcaelicEntity entity;
        public double aimX;
        public double aimY;
        public double aimZ;

        public SubcaelicMoveControl(AbstractSubcaelicEntity entity) {
            super((Mob)entity);
            this.entity = entity;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                double movementSpeed = this.entity.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.getSpeedModifier();
                this.tickAim(this.entity.getTurnFactor(), movementSpeed);
                double lerpFactor = this.getLerpFactor(movementSpeed);
                double dragFactor = 0.98;
                Firmament firmament = Firmament.fromLevel(this.entity.level());
                if (this.entity.isAlive() && firmament != null) {
                    int damage = firmament.getDamage(this.entity.getBlockX(), this.entity.getBlockZ());
                    dragFactor *= 0.7 + 0.3 * (double)damage / 7.0;
                }
                Vec3 velocity = this.entity.getDeltaMovement();
                double vX = Mth.lerp((double)lerpFactor, (double)velocity.x, (double)(this.aimX * movementSpeed));
                double vY = Mth.lerp((double)lerpFactor, (double)velocity.y, (double)(this.aimY * movementSpeed));
                double vZ = Mth.lerp((double)lerpFactor, (double)velocity.z, (double)(this.aimZ * movementSpeed));
                this.entity.setDeltaMovement(vX * dragFactor, vY * dragFactor, vZ * dragFactor);
            }
        }

        private void tickAim(double turnFactor, double movementSpeed) {
            double targetAimZ;
            double targetAimY;
            double targetAimX = this.wantedX - this.entity.getX();
            double targetAimSqr = targetAimX * targetAimX + (targetAimY = this.wantedY - this.entity.getY()) * targetAimY + (targetAimZ = this.wantedZ - this.entity.getZ()) * targetAimZ;
            if (targetAimSqr > movementSpeed * movementSpeed) {
                double targetAimLength = Math.sqrt(targetAimSqr);
                targetAimX /= targetAimLength;
                targetAimY /= targetAimLength;
                targetAimZ /= targetAimLength;
            } else {
                targetAimX /= movementSpeed;
                targetAimY /= movementSpeed;
                targetAimZ /= movementSpeed;
            }
            double aX = Mth.lerp((double)turnFactor, (double)this.aimX, (double)targetAimX);
            double aY = Mth.lerp((double)turnFactor, (double)this.aimY, (double)targetAimY);
            double aZ = Mth.lerp((double)turnFactor, (double)this.aimZ, (double)targetAimZ);
            double aSqr = aX * aX + aY * aY + aZ * aZ;
            if (aSqr > 1.0) {
                double aLength = Math.sqrt(aSqr);
                aX /= aLength;
                aY /= aLength;
                aZ /= aLength;
            }
            this.aimX = aX;
            this.aimY = aY;
            this.aimZ = aZ;
        }

        private double getLerpFactor(double movementSpeed) {
            Vec3 velocity = this.entity.getDeltaMovement();
            double vSqr = velocity.lengthSqr();
            double dot = this.aimX * velocity.x + this.aimY * velocity.y + this.aimZ * velocity.z;
            dot = vSqr > movementSpeed * movementSpeed ? (dot /= Math.sqrt(vSqr)) : (dot /= movementSpeed);
            dot = dot * 0.5 + 0.5;
            return dot * dot * dot * 0.98 + 0.02;
        }
    }

    static class SwimNearTargetGoal
    extends SwimWanderGoal {
        private static final double MAX_DISTANCE_FROM_TARGET = 32.0;
        private static final double SEARCH_RADIUS_MIN = 2.0;
        private static final double SEARCH_RADIUS_MAX = 48.0;
        @Nullable
        LivingEntity targetEntity = null;

        public SwimNearTargetGoal(AbstractSubcaelicEntity entity) {
            super(entity);
        }

        @Override
        public boolean canUse() {
            LivingEntity target = this.entity.getTarget();
            if (this.isEntityValid(target)) {
                this.targetEntity = target;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.isEntityValid(this.targetEntity);
        }

        public void stop() {
            this.targetEntity = null;
        }

        protected boolean isEntityValid(LivingEntity target) {
            if (target == null) {
                return false;
            }
            if (!target.isAlive()) {
                return false;
            }
            return !(target instanceof Player) || !target.isSpectator() && !((Player)target).isCreative();
        }

        @Override
        protected Vec3 getCandidatePosition() {
            if (this.targetEntity == null) {
                return this.entity.position();
            }
            RandomSource random = this.entity.getRandom();
            double radius = 2.0 + 46.0 * (double)random.nextFloat();
            double angle = Math.PI * 2 * (double)random.nextFloat();
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            float l = random.nextFloat();
            double targetX = Mth.lerp((double)l, (double)this.entity.getX(), (double)this.targetEntity.getX()) + radius * cos;
            double targetZ = Mth.lerp((double)l, (double)this.entity.getZ(), (double)this.targetEntity.getZ()) + radius * sin;
            double targetY = this.getTargetY(targetX, targetZ, this.targetEntity.getY() + 12.0, this.entity.level().getMaxBuildHeight());
            return new Vec3(targetX, targetY, targetZ);
        }

        @Override
        protected double getTargetBadness(Vec3 target) {
            Vec3 offset3;
            if (this.targetEntity == null) {
                return 0.0;
            }
            Vec3 offset = target.subtract(this.targetEntity.position());
            double offsetFactor = 1.0 - Math.exp(-offset.lengthSqr() * 0.01);
            Vec3 offset2 = target.subtract(this.entity.position());
            if (offset2.lengthSqr() > 1.0) {
                offset2 = offset2.normalize();
            }
            if ((offset3 = this.targetEntity.position().subtract(this.entity.position())).lengthSqr() > 1.0) {
                offset3 = offset3.normalize();
            }
            double dot = offset2.dot(offset3);
            double dotFactor = 0.5 - 0.5 * dot;
            return super.getTargetBadness(target) + offsetFactor + dotFactor * 0.7;
        }
    }

    static class SwimWanderGoal
    extends Goal {
        protected static final double TARGET_ACHIEVED_DISTANCE = 8.0;
        private static final double SEARCH_RADIUS_MIN = 8.0;
        private static final double SEARCH_RADIUS_MAX = 20.0;
        protected final AbstractSubcaelicEntity entity;

        public SwimWanderGoal(AbstractSubcaelicEntity entity) {
            this.entity = entity;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            Vec3 target;
            if ((this.needsNewTarget() || this.entity.getRandom().nextInt(SwimWanderGoal.reducedTickDelay((int)40)) == 0) && (target = this.pickTargetPosition()) != null) {
                this.entity.moveControl.setWantedPosition(target.x, target.y, target.z, 1.0);
            }
        }

        protected boolean needsNewTarget() {
            MoveControl moveControl = this.entity.moveControl;
            if (!moveControl.hasWanted()) {
                return true;
            }
            return !this.isTargetValid(moveControl.getWantedX(), moveControl.getWantedY(), moveControl.getWantedZ());
        }

        protected boolean isTargetValid(double x, double y, double z) {
            return this.entity.position().subtract(x, y, z).horizontalDistanceSqr() > 64.0;
        }

        @Nullable
        protected Vec3 pickTargetPosition() {
            MoveControl moveControl = this.entity.moveControl;
            double leastBadness = !moveControl.hasWanted() ? Double.POSITIVE_INFINITY : this.getTargetBadness(new Vec3(moveControl.getWantedX(), moveControl.getWantedY(), moveControl.getWantedZ()));
            Vec3 bestTarget = null;
            int ATTEMPTS = 7;
            for (int i = 0; i < ATTEMPTS; ++i) {
                Vec3 candidatePosition = this.getCandidatePosition();
                double badness = this.getTargetBadness(candidatePosition);
                if (!(badness < leastBadness)) continue;
                leastBadness = badness;
                bestTarget = candidatePosition;
            }
            return bestTarget;
        }

        protected Vec3 getCandidatePosition() {
            RandomSource random = this.entity.getRandom();
            double radius = 8.0 + 12.0 * (double)random.nextFloat();
            double angle = Math.PI * 2 * (double)random.nextFloat();
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double targetX = this.entity.getX() + radius * cos;
            double targetZ = this.entity.getZ() + radius * sin;
            double targetY = this.getTargetY(targetX, targetZ, this.entity.level().getMinBuildHeight(), this.entity.level().getMaxBuildHeight());
            return new Vec3(targetX, targetY, targetZ);
        }

        protected double getTargetY(double x, double z, double bottomY, double topY) {
            int heightEnd;
            Level world = this.entity.level();
            int heightStart = world.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)this.entity.getX(), (int)this.entity.getZ());
            int height = Math.min(Math.max(heightStart, heightEnd = world.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z)), (int)this.entity.getY() + 12);
            double h = height == world.getMinBuildHeight() ? this.entity.getY() : (double)(height + 16);
            return Mth.clamp((double)h, (double)bottomY, (double)topY);
        }

        protected double getTargetBadness(Vec3 target) {
            Vec3 offset = target.subtract(this.entity.position()).multiply(1.0, 0.25, 1.0);
            if (offset.lengthSqr() > 1.0) {
                offset = offset.normalize();
            }
            double dot = offset.dot(this.entity.getViewVector(1.0f));
            Firmament firmament = Firmament.fromLevel(this.entity.level());
            int damage = firmament == null ? 0 : firmament.getDamage((int)target.x(), (int)target.z());
            double dotFactor = 0.5 - 0.5 * dot;
            double damageFactor = 1.0 - (double)damage / 7.0 * ((double)damage / 7.0);
            return dotFactor * 0.5 + damageFactor * 4.0;
        }
    }
}

