/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import phanastrae.operation_starcleave.network.packet.FirmamentCleavedPayload;
import phanastrae.operation_starcleave.services.XPlatInterface;
import phanastrae.operation_starcleave.world.firmament.Firmament;
import phanastrae.operation_starcleave.world.firmament.FirmamentShatterActor;
import phanastrae.operation_starcleave.world.firmament.FirmamentSubRegion;
import phanastrae.operation_starcleave.world.firmament.SubRegionPos;

public class FirmamentManipulatorItem
extends Item {
    public FirmamentManipulatorItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (!user.getAbilities().mayBuild) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        if (!world.isClientSide) {
            Firmament firmament = Firmament.fromLevel(world);
            if (firmament == null) {
                return super.use(world, user, hand);
            }
            float pitch = Math.toRadians((float)user.getXRot());
            if (pitch > 0.0f) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            Vec3 pos = user.getEyePosition(1.0f);
            Vec3 lookVec = user.getViewVector(1.0f);
            float skyHeight = firmament.getY();
            double t = ((double)skyHeight - pos.y) / lookVec.y;
            if (t > 0.0) {
                Vec3 target = pos.add(lookVec.scale(t));
                if (user.isShiftKeyDown()) {
                    SubRegionPos subRegionPos = SubRegionPos.fromWorldCoords((int)target.x, (int)target.z);
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            SubRegionPos subRegionPos2 = new SubRegionPos(subRegionPos.srx + i, subRegionPos.srz + j);
                            FirmamentSubRegion firmamentSubRegion = firmament.getSubRegionFromId(subRegionPos2.id);
                            if (firmamentSubRegion == null) continue;
                            firmamentSubRegion.clear();
                        }
                    }
                } else {
                    RandomSource random = user.getRandom();
                    for (int i = 0; i < 10; ++i) {
                        world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, target.x + (double)(random.nextFloat() * 4.0f) - 2.0, target.y + (double)(random.nextFloat() * 1.0f) - 0.5, target.z + (double)(random.nextFloat() * 4.0f) - 2.0, 0.0, 0.0, 0.0);
                    }
                    int x = (int)target.x;
                    int z = (int)target.z;
                    FirmamentManipulatorItem.fractureFirmament(firmament, x, z, random);
                }
            }
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    public static void fractureFirmament(Firmament firmament, int x, int z, RandomSource random) {
        Level level = firmament.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            for (ServerPlayer player : world.players()) {
                XPlatInterface.INSTANCE.sendPayload(player, new FirmamentCleavedPayload(x, z));
            }
        }
        firmament.setDamage(x, z, Math.clamp((int)6, (int)7, (int)(firmament.getDamage(x, z) + 6)));
        firmament.setDamage(x + 4, z + 4, Math.clamp((int)2, (int)7, (int)(firmament.getDamage(x + 4, z + 4) + 2)));
        firmament.setDamage(x - 4, z + 4, Math.clamp((int)2, (int)7, (int)(firmament.getDamage(x - 4, z + 4) + 2)));
        firmament.setDamage(x + 4, z - 4, Math.clamp((int)2, (int)7, (int)(firmament.getDamage(x + 4, z - 4) + 2)));
        firmament.setDamage(x - 4, z - 4, Math.clamp((int)2, (int)7, (int)(firmament.getDamage(x - 4, z - 4) + 2)));
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                firmament.markActive(x + i * 4, z + j * 4);
            }
        }
        int rad = 15;
        for (int i = -rad; i <= rad; ++i) {
            for (int j = -rad; j <= rad; ++j) {
                float distSqr = i * i + j * j;
                if (distSqr > (float)(rad * rad)) continue;
                float fallOff = 1.0f - distSqr / (float)(rad * rad);
                firmament.setDrip(x + i * 4, z + j * 4, firmament.getDrip(x + i * 4, z + j * 4) + (int)(0.07f * fallOff * fallOff * fallOff));
            }
        }
        float phase = random.nextFloat();
        int count = 10;
        for (int i = 0; i < count; ++i) {
            float theta = (phase + (float)i / (float)count) * 2.0f * (float)java.lang.Math.PI;
            FirmamentShatterActor actor = new FirmamentShatterActor(firmament, x, z, Math.cos((float)theta) * 4.0f, Math.sin((float)theta) * 4.0f, 1000.0f);
            actor.initialDelay = 32;
            firmament.addActor(actor);
        }
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"operation_starcleave.tooltip.firmament_manipulator.1").withStyle(ChatFormatting.GOLD));
        tooltip.add((Component)Component.translatable((String)"operation_starcleave.tooltip.firmament_manipulator.2").withStyle(ChatFormatting.GOLD));
        tooltip.add((Component)Component.translatable((String)"operation_starcleave.tooltip.firmament_manipulator.3").withStyle(ChatFormatting.DARK_RED));
    }
}

