/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.item.OperationStarcleaveItems;

public class HollowedSacItem
extends Item {
    public HollowedSacItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockPos;
        Player user = context.getPlayer();
        if (user == null) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        if (world.getBlockState(blockPos = context.getClickedPos()).is(OperationStarcleaveBlocks.PHLOGISTIC_FIRE)) {
            this.playUseSound(world, blockPos);
            world.setBlockAndUpdate(blockPos, this.getNewBlockState(world, blockPos));
            world.gameEvent((Entity)user, (Holder)GameEvent.FLUID_PICKUP, blockPos);
            this.fill(context.getItemInHand(), user);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    protected void fill(ItemStack stack, Player player) {
        ItemStack newStack = new ItemStack((ItemLike)OperationStarcleaveItems.PHLOGISTON_SAC);
        ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)newStack);
    }

    protected BlockState getNewBlockState(Level world, BlockPos blockPos) {
        return (world.isWaterAt(blockPos) ? Blocks.WATER : Blocks.AIR).defaultBlockState();
    }

    protected void playUseSound(Level world, BlockPos pos) {
        world.playSound(null, pos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

