/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import phanastrae.operation_starcleave.block.PhlogisticFireBlock;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityAttachment;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityTypeTags;

public class PhlogistonSacItem
extends Item {
    public PhlogistonSacItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockPos;
        Level world = context.getLevel();
        if (PhlogisticFireBlock.canPlaceAt(world, blockPos = context.getClickedPos().relative(context.getClickedFace()))) {
            this.playUseSound(world, blockPos);
            world.setBlockAndUpdate(blockPos, PhlogisticFireBlock.getState((BlockGetter)world, blockPos));
            world.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_PLACE, blockPos);
            this.empty(context.getItemInHand());
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        if (!entity.isAlive() || entity.getType().is(OperationStarcleaveEntityTypeTags.PHLOGISTIC_FIRE_IMMUNE)) {
            return InteractionResult.FAIL;
        }
        Level world = entity.level();
        this.playUseSound(world, entity.position());
        if (!user.level().isClientSide) {
            OperationStarcleaveEntityAttachment.fromEntity((Entity)entity).setOnPhlogisticFireFor(5.0f);
            world.gameEvent((Entity)user, (Holder)GameEvent.ENTITY_ACTION, entity.position());
            this.empty(stack);
        }
        return InteractionResult.sidedSuccess((boolean)user.level().isClientSide);
    }

    protected void empty(ItemStack stack) {
        stack.shrink(1);
    }

    protected void playUseSound(Level world, BlockPos blockPos) {
        this.playUseSound(world, Vec3.atCenterOf((Vec3i)blockPos));
    }

    protected void playUseSound(Level world, Vec3 pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, pos.x, pos.y, pos.z, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.15f + 0.75f);
    }
}

