/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityTypes;
import phanastrae.operation_starcleave.sound.OperationStarcleaveSoundEvents;

public class StarcleaverGolemBucketItem
extends MobBucketItem {
    public StarcleaverGolemBucketItem(Item.Properties settings) {
        super(OperationStarcleaveEntityTypes.STARCLEAVER_GOLEM, Fluids.EMPTY, OperationStarcleaveSoundEvents.ENTITY_STARCLEAVER_GOLEM_AMBIENT, settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        BlockHitResult blockHitResult = StarcleaverGolemBucketItem.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos blockPos2 = blockPos.relative(direction);
        if (!world.mayInteract(user, blockPos) || !user.mayUseItemAt(blockPos2, direction, itemStack)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        BlockState blockState = world.getBlockState(blockPos);
        BlockPos blockPos3 = blockState.canBeReplaced() ? blockPos : blockPos2;
        this.checkExtraContent(user, world, itemStack, blockPos3);
        if (user instanceof ServerPlayer) {
            CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)user, blockPos3, itemStack);
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)StarcleaverGolemBucketItem.getEmptySuccessItem((ItemStack)itemStack, (Player)user), (boolean)world.isClientSide());
    }
}

