/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import phanastrae.operation_starcleave.block.BlessedBedBlock;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.block.StellarRepulsorBlock;
import phanastrae.operation_starcleave.entity.OperationStarcleaveDamageTypeTags;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityAttachment;
import phanastrae.operation_starcleave.item.StarbleachCoating;
import phanastrae.operation_starcleave.world.firmament.Firmament;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    protected boolean jumping;
    @Shadow
    private int noJumpDelay;

    @Shadow
    public abstract boolean hurt(DamageSource var1, float var2);

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")})
    private void operation_starcleave$eatStarbleachedFood(Level world, ItemStack stack, FoodProperties foodComponent, CallbackInfoReturnable<ItemStack> cir) {
        StarbleachCoating.onEat((LivingEntity)this, world, stack);
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void operation_starcleave$repulsorVehicleJump(CallbackInfo ci) {
        LivingEntity livingEntity;
        Entity controllingVehicle;
        if (this.jumping && this.noJumpDelay == 0 && (controllingVehicle = (livingEntity = (LivingEntity)this).getControlledVehicle()) != null && controllingVehicle.getDeltaMovement().y < 0.01 && controllingVehicle.onGround()) {
            StellarRepulsorBlock.tryLaunch(controllingVehicle);
            this.noJumpDelay = 10;
        }
    }

    @Inject(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;handleRelativeFrictionAndCalculateMovement(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;")})
    private void operation_starcleave$reduceGlidingFriction(Vec3 travelVector, CallbackInfo ci, @Local(ordinal=1) LocalFloatRef frictionMultiplierRef) {
        if (OperationStarcleaveEntityAttachment.fromEntity(this).isPegasusGliding() && !this.onGround()) {
            Firmament firmament = Firmament.fromLevel(this.level());
            int damage = firmament == null ? 0 : firmament.getDamage(this.getBlockX(), this.getBlockZ());
            int skyLight = this.level().getBrightness(LightLayer.SKY, this.blockPosition());
            float starlight = (float)damage / 7.0f * ((float)skyLight / 15.0f);
            frictionMultiplierRef.set(Mth.lerp((float)starlight, (float)0.965f, (float)0.995f));
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="RETURN")})
    private void operation_starcleave$repulsorJump(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        StellarRepulsorBlock.tryLaunch((Entity)livingEntity);
    }

    @Inject(method={"startSleeping"}, at={@At(value="HEAD")})
    private void operation_starcleave$blessedBed(BlockPos pos, CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        Level level = livingEntity.level();
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is(OperationStarcleaveBlocks.BLESSED_BED)) {
            BlessedBedBlock.blessedSleep(livingEntity);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/WalkAnimationState;setSpeed(F)V", ordinal=0, shift=At.Shift.BEFORE)})
    private void operation_starcleave$handlePhlogisticFireDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir, @Local(ordinal=0) LocalFloatRef localRef) {
        if (source.is(OperationStarcleaveDamageTypeTags.IS_PHLOGISTIC_FIRE)) {
            float damage = localRef.get();
            if (this.fireImmune() || this.hasEffect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE)) {
                damage *= 0.5f;
            }
            localRef.set(damage);
        }
    }
}

