/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.neoforge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.UncheckedIOException;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.GameShuttingDownEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.joml.Matrix4f;
import phanastrae.operation_starcleave.client.OperationStarcleaveClient;
import phanastrae.operation_starcleave.client.particle.OperationStarcleaveParticles;
import phanastrae.operation_starcleave.client.render.entity.OperationStarcleaveEntityRenderers;
import phanastrae.operation_starcleave.client.render.entity.model.OperationStarcleaveEntityModelLayers;
import phanastrae.operation_starcleave.client.render.shader.OperationStarcleaveShaders;
import phanastrae.operation_starcleave.mixin.client.LevelRendererAccessor;

@Mod(value="operation_starcleave", dist={Dist.CLIENT})
public class OperationStarcleaveClientNeoForge {
    public OperationStarcleaveClientNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        this.setupModBusEvents(modEventBus);
        this.setupGameBusEvents(NeoForge.EVENT_BUS);
    }

    public void setupModBusEvents(IEventBus modEventBus) {
        modEventBus.addListener(this::onClientInit);
        modEventBus.addListener(this::registerEntityRenderers);
        modEventBus.addListener(this::registerEntityLayers);
        modEventBus.addListener(this::registerParticleProviders);
        modEventBus.addListener(this::registerShaders);
    }

    public void setupGameBusEvents(IEventBus gameEventBus) {
        NeoForge.EVENT_BUS.addListener(this::onGameShutdown);
        NeoForge.EVENT_BUS.addListener(this::startClientTick);
        NeoForge.EVENT_BUS.addListener(this::renderLevel);
        NeoForge.EVENT_BUS.addListener(this::renderBlockHighlight);
    }

    public void onClientInit(FMLClientSetupEvent event) {
        event.enqueueWork(OperationStarcleaveClient::init);
    }

    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        OperationStarcleaveEntityRenderers.init((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
    }

    public void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        OperationStarcleaveEntityModelLayers.init((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
    }

    public void registerParticleProviders(final RegisterParticleProvidersEvent event) {
        OperationStarcleaveParticles.init(new OperationStarcleaveParticles.ClientParticleRegistrar(){

            @Override
            public <T extends ParticleOptions> void register(ParticleType<T> type, OperationStarcleaveParticles.ParticleRegistration<T> registration) {
                event.registerSpriteSet(type, registration::create);
            }
        });
    }

    public void registerShaders(RegisterShadersEvent event) {
        try {
            OperationStarcleaveShaders.registerShaders((id, vertexFormat, callback) -> event.registerShader(new ShaderInstance(event.getResourceProvider(), id, vertexFormat), callback));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void onGameShutdown(GameShuttingDownEvent event) {
        OperationStarcleaveClient.onClientShutdown(Minecraft.getInstance());
    }

    public void startClientTick(LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide) {
            OperationStarcleaveClient.startLevelTick(event.getLevel());
        }
    }

    public void renderLevel(RenderLevelStageEvent event) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        PoseStack matrixStack = event.getPoseStack();
        LevelRenderer levelRenderer = event.getLevelRenderer();
        MultiBufferSource.BufferSource vertexConsumers = ((LevelRendererAccessor)levelRenderer).getRenderBuffers().bufferSource();
        DeltaTracker deltaTracker = event.getPartialTick();
        Camera camera = event.getCamera();
        Matrix4f projectionMatrix = event.getProjectionMatrix();
        Matrix4f positionMatrix = event.getModelViewMatrix();
        Frustum frustum = event.getFrustum();
        RenderLevelStageEvent.Stage stage = event.getStage();
        if (stage.equals(RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS)) {
            OperationStarcleaveClient.renderBeforeEntities((Level)level, camera, frustum, levelRenderer, projectionMatrix, positionMatrix);
        } else if (stage.equals(RenderLevelStageEvent.Stage.AFTER_ENTITIES)) {
            OperationStarcleaveClient.renderAfterEntities((Level)level, matrixStack, (MultiBufferSource)vertexConsumers, deltaTracker, camera);
        }
    }

    public void renderBlockHighlight(RenderHighlightEvent.Block event) {
        OperationStarcleaveClient.renderBeforeBlockOutline(true, event.getMultiBufferSource(), event.getCamera(), event.getPoseStack());
    }
}

