/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.neoforge.client.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import java.util.function.BiConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import phanastrae.operation_starcleave.client.fluid.OperationStarcleaveClientFluids;

public class OperationStarcleaveFluidTypeExtensions {
    public static void init(BiConsumer<IClientFluidTypeExtensions, FluidType[]> biConsumer) {
        OperationStarcleaveClientFluids.init();
        OperationStarcleaveClientFluids.forEachXPGCF(xpgcf -> biConsumer.accept(OperationStarcleaveFluidTypeExtensions.getICFTE(xpgcf), new FluidType[]{xpgcf.getStill().getFluidType()}));
    }

    public static IClientFluidTypeExtensions getICFTE(final OperationStarcleaveClientFluids.XPlatGenericClientFluid xpgcf) {
        final ResourceLocation stillTexture = xpgcf.getStillTexture();
        final ResourceLocation flowingTexture = xpgcf.getFlowTexture();
        final ResourceLocation overlayTexture = xpgcf.getOverlayTexture();
        final ResourceLocation screenEffectTexture = xpgcf.getScreenEffectTexture();
        final int tint = xpgcf.getTint();
        return new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return flowingTexture;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return overlayTexture;
            }

            @Nullable
            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return screenEffectTexture;
            }

            public int getTintColor() {
                return tint;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                xpgcf.setupFog(farDistance);
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return xpgcf.getFogColor();
            }
        };
    }
}

