/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import phanastrae.operation_starcleave.item.OperationStarcleaveItems;
import phanastrae.operation_starcleave.recipe.OperationStarcleaveRecipeSerializers;
import phanastrae.operation_starcleave.recipe.OperationStarcleaveRecipeTypes;
import phanastrae.operation_starcleave.recipe.input.ItemStarbleachingRecipeInput;

public class ItemStarbleachingRecipe
implements Recipe<ItemStarbleachingRecipeInput> {
    protected final Ingredient ingredient;
    protected final float starbleachCost;
    protected final ItemStack result;
    protected final boolean isFillingRecipe;

    public ItemStarbleachingRecipe(Ingredient ingredient, float starbleachCost, ItemStack result, boolean isFillingRecipe) {
        this.ingredient = ingredient;
        this.starbleachCost = starbleachCost;
        this.result = result;
        this.isFillingRecipe = isFillingRecipe;
    }

    public RecipeType<?> getType() {
        return OperationStarcleaveRecipeTypes.ITEM_STARBLEACHING;
    }

    public RecipeSerializer<?> getSerializer() {
        return OperationStarcleaveRecipeSerializers.ITEM_STARBLEACHING;
    }

    public ItemStack getToastSymbol() {
        return OperationStarcleaveItems.STARBLEACH_BOTTLE.getDefaultInstance();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public boolean matches(ItemStarbleachingRecipeInput input, Level world) {
        ItemStack stack = input.getItem(0);
        return this.ingredient.test(stack);
    }

    public ItemStack getResultItem(HolderLookup.Provider registriesLookup) {
        return this.result;
    }

    public ItemStack assemble(ItemStarbleachingRecipeInput input, HolderLookup.Provider lookup) {
        return ItemStack.EMPTY;
    }

    public ItemStack getOutputStack() {
        return this.result.copy();
    }

    public boolean getIsFillingRecipe() {
        return this.isFillingRecipe;
    }

    public int getRequiredStarbleachToAttemptCraft() {
        if (this.starbleachCost <= 0.0f) {
            return 0;
        }
        return (int)Math.ceil(this.starbleachCost);
    }

    public float getStarbleachCost() {
        return this.starbleachCost;
    }

    public static int getConsumedStarbleach(RandomSource random, float cost) {
        boolean consumeAdditionalUnit;
        if (cost <= 0.0f) {
            return 0;
        }
        int minConsumed = (int)Math.floor(cost);
        float probabilityForBonusUnit = cost - (float)minConsumed;
        if (probabilityForBonusUnit == 0.0f) {
            return minConsumed;
        }
        boolean bl = consumeAdditionalUnit = random.nextFloat() < probabilityForBonusUnit;
        if (consumeAdditionalUnit) {
            return minConsumed + 1;
        }
        return minConsumed;
    }

    public static class Serializer<T extends ItemStarbleachingRecipe>
    implements RecipeSerializer<T> {
        final RecipeFactory<T> recipeFactory;
        private final MapCodec<T> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, T> packetCodec;

        protected Serializer(RecipeFactory<T> recipeFactory) {
            this.recipeFactory = recipeFactory;
            this.codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)Codec.FLOAT.optionalFieldOf("starbleach_cost", (Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.starbleachCost)), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("is_filling_recipe", (Object)false).forGetter(recipe -> recipe.isFillingRecipe)).apply((Applicative)instance, recipeFactory::create));
            this.packetCodec = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.ingredient, (StreamCodec)ByteBufCodecs.FLOAT, recipe -> Float.valueOf(recipe.starbleachCost), (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, (StreamCodec)ByteBufCodecs.BOOL, recipe -> recipe.isFillingRecipe, recipeFactory::create);
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.packetCodec;
        }
    }

    public static interface RecipeFactory<T extends ItemStarbleachingRecipe> {
        public T create(Ingredient var1, float var2, ItemStack var3, boolean var4);
    }
}

