/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.server.network;

import com.google.common.collect.Comparators;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import phanastrae.operation_starcleave.duck.ServerGamePacketListenerImplDuckInterface;
import phanastrae.operation_starcleave.network.packet.FirmamentRegionDataPayload;
import phanastrae.operation_starcleave.network.packet.FirmamentRegionSentPayload;
import phanastrae.operation_starcleave.network.packet.StartFirmamentRegionSendPayload;
import phanastrae.operation_starcleave.network.packet.UnloadFirmamentRegionPayload;
import phanastrae.operation_starcleave.services.XPlatInterface;
import phanastrae.operation_starcleave.world.firmament.Firmament;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegion;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegionData;
import phanastrae.operation_starcleave.world.firmament.RegionPos;

public class FirmamentRegionDataSender {
    private final LongSet regions = new LongOpenHashSet();
    private final boolean local;
    private float desiredBatchSize = 9.0f;
    private float pending;
    private int unacknowledgedBatches;
    private int maxUnacknowledgedBatches = 1;

    public FirmamentRegionDataSender(boolean local) {
        this.local = local;
    }

    public void add(RegionPos regionPos) {
        this.regions.add(regionPos.id);
    }

    public void unload(ServerPlayer player, RegionPos regionPos) {
        this.regions.remove(regionPos.id);
        if (player.isAlive()) {
            XPlatInterface.INSTANCE.sendPayload(player, new UnloadFirmamentRegionPayload(regionPos.id));
        }
    }

    public void sendChunkBatches(ServerPlayer player) {
        if (this.unacknowledgedBatches < this.maxUnacknowledgedBatches) {
            ServerLevel serverWorld;
            Firmament firmament;
            List<FirmamentRegion> list;
            float f = Math.max(1.0f, this.desiredBatchSize);
            this.pending = Math.min(this.pending + this.desiredBatchSize, f);
            if (!(this.pending < 1.0f || this.regions.isEmpty() || (list = this.makeBatch(firmament = Firmament.fromLevel((Level)(serverWorld = player.serverLevel())), player.chunkPosition())).isEmpty())) {
                ServerGamePacketListenerImpl serverPlayNetworkHandler = player.connection;
                ++this.unacknowledgedBatches;
                XPlatInterface.INSTANCE.sendPayload(player, new StartFirmamentRegionSendPayload());
                for (FirmamentRegion region : list) {
                    FirmamentRegionDataSender.sendChunkData(serverPlayNetworkHandler, serverWorld, region);
                }
                XPlatInterface.INSTANCE.sendPayload(player, new FirmamentRegionSentPayload(list.size()));
                this.pending -= (float)list.size();
            }
        }
    }

    private static void sendChunkData(ServerGamePacketListenerImpl handler, ServerLevel world, FirmamentRegion region) {
        XPlatInterface.INSTANCE.sendPayload(handler.player, new FirmamentRegionDataPayload(region.regionPos.id, new FirmamentRegionData(region)));
    }

    private List<FirmamentRegion> makeBatch(Firmament firmament, ChunkPos playerPos) {
        int i = Mth.floor((float)this.pending);
        List<FirmamentRegion> list = !this.local && this.regions.size() > i ? ((List)this.regions.stream().collect(Comparators.least((int)i, Comparator.comparingInt(id -> FirmamentRegionDataSender.getSquaredDistance(id, playerPos))))).stream().mapToLong(Long::longValue).mapToObj(l -> FirmamentRegionDataSender.getSubRegion(l, firmament)).filter(Objects::nonNull).toList() : this.regions.longStream().mapToObj(l -> FirmamentRegionDataSender.getSubRegion(l, firmament)).filter(Objects::nonNull).sorted(Comparator.comparingInt(region -> FirmamentRegionDataSender.getSquaredDistance(Firmament.getRegionId(region.x, region.z), playerPos))).toList();
        for (FirmamentRegion region2 : list) {
            this.regions.remove(Firmament.getRegionId(region2.x, region2.z));
        }
        return list;
    }

    public static FirmamentRegion getSubRegion(long id, Firmament firmament) {
        return firmament.getFirmamentRegion(id);
    }

    public static int getSquaredDistance(long id, ChunkPos playerPos) {
        RegionPos r1 = new RegionPos(id);
        RegionPos r2 = RegionPos.fromWorldCoords(playerPos.getMinBlockX(), playerPos.getMinBlockZ());
        int dx = r1.rx - r2.rx;
        int dz = r1.rz - r2.rz;
        return dx * dx + dz * dz;
    }

    public void onAcknowledgeRegions(float desiredBatchSize) {
        --this.unacknowledgedBatches;
        float f = this.desiredBatchSize = Double.isNaN(desiredBatchSize) ? 0.01f : Mth.clamp((float)desiredBatchSize, (float)0.01f, (float)64.0f);
        if (this.unacknowledgedBatches == 0) {
            this.pending = 1.0f;
        }
        this.maxUnacknowledgedBatches = 10;
    }

    public static FirmamentRegionDataSender getFirmamentRegionDataSender(ServerGamePacketListenerImpl serverPlayNetworkHandler) {
        return ((ServerGamePacketListenerImplDuckInterface)serverPlayNetworkHandler).operation_starcleave$getFirmamentRegionDataSender();
    }
}

