/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.world.firmament;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.OperationStarcleave;
import phanastrae.operation_starcleave.world.firmament.FirmamentAccess;
import phanastrae.operation_starcleave.world.firmament.FirmamentActor;
import phanastrae.operation_starcleave.world.firmament.FirmamentHolder;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegion;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegionManager;
import phanastrae.operation_starcleave.world.firmament.FirmamentSubRegion;
import phanastrae.operation_starcleave.world.firmament.FirmamentUpdater;
import phanastrae.operation_starcleave.world.firmament.RegionPos;

public class Firmament
implements FirmamentAccess {
    private final Level level;
    private final FirmamentRegionManager firmamentRegionManager;

    public Firmament(Level level, FirmamentRegionManager firmamentRegionManager) {
        this.level = level;
        this.firmamentRegionManager = firmamentRegionManager;
    }

    public int getY() {
        return this.level.getMaxBuildHeight();
    }

    public void tick() {
        long t = this.level.getGameTime();
        if (t % 2L == 0L) {
            this.manageActors();
            this.tickActors();
            if (t % 20L == 0L) {
                this.clearShouldUpdate();
            }
            this.markUpdatesFromActivity();
            if (t % 20L == 0L) {
                this.clearActive();
            }
            this.firmamentRegionManager.tick();
            FirmamentUpdater.update(this);
        }
    }

    public void forEachRegion(Consumer<FirmamentRegion> method) {
        this.firmamentRegionManager.forEachRegion(method);
    }

    public static long getRegionId(int x, int z) {
        int rx = x >> 9;
        int rz = z >> 9;
        return ChunkPos.asLong((int)rx, (int)rz);
    }

    @Nullable
    public FirmamentRegion getFirmamentRegion(int x, int z) {
        return this.getFirmamentRegion(Firmament.getRegionId(x, z));
    }

    @Nullable
    public FirmamentRegion getFirmamentRegion(long id) {
        return this.firmamentRegionManager.getFirmamentRegion(id);
    }

    @Nullable
    public FirmamentRegion getFirmamentRegion(RegionPos regionPos) {
        return this.getFirmamentRegion(regionPos.id);
    }

    @Override
    public void clearActors() {
        this.forEachRegion(FirmamentRegion::clearActors);
    }

    @Override
    public void addActor(FirmamentActor actor) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(actor.originX, actor.originZ);
        if (firmamentRegion != null) {
            firmamentRegion.addActor(actor);
        }
    }

    @Override
    public void manageActors() {
        this.forEachRegion(FirmamentRegion::manageActors);
    }

    @Override
    public void tickActors() {
        this.forEachRegion(FirmamentRegion::tickActors);
    }

    @Override
    public void forEachActor(Consumer<FirmamentActor> consumer) {
        this.forEachRegion(firmamentRegion -> firmamentRegion.forEachActor(consumer));
    }

    @Override
    public void forEachPosition(BiConsumer<Integer, Integer> method) {
        this.forEachRegion(firmamentRegion -> firmamentRegion.forEachPosition(method));
    }

    @Override
    public void forEachActivePosition(BiConsumer<Integer, Integer> method) {
        this.forEachRegion(firmamentRegion -> {
            if (firmamentRegion.active) {
                firmamentRegion.forEachActivePosition((x, z) -> method.accept(x + firmamentRegion.x, z + firmamentRegion.z));
            }
        });
    }

    @Override
    public int getDrip(int x, int z) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            return firmamentRegion.getDrip(x, z);
        }
        return 0;
    }

    @Override
    public int getDamage(int x, int z) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            return firmamentRegion.getDamage(x, z);
        }
        return 0;
    }

    @Override
    public int getDisplacement(int x, int z) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            return firmamentRegion.getDisplacement(x, z);
        }
        return 0;
    }

    @Override
    public int getVelocity(int x, int z) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            return firmamentRegion.getVelocity(x, z);
        }
        return 0;
    }

    @Override
    public float getDDrip(int x, int z) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            return firmamentRegion.getDDrip(x, z);
        }
        return 0.0f;
    }

    @Override
    public void setDrip(int x, int z, int value) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            firmamentRegion.setDrip(x & 0x1FF, z & 0x1FF, value);
        }
    }

    @Override
    public void setDamage(int x, int z, int value) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            firmamentRegion.setDamage(x & 0x1FF, z & 0x1FF, value);
        }
    }

    @Override
    public void setDisplacement(int x, int z, int value) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            firmamentRegion.setDisplacement(x & 0x1FF, z & 0x1FF, value);
        }
    }

    @Override
    public void setVelocity(int x, int z, int value) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            firmamentRegion.setVelocity(x & 0x1FF, z & 0x1FF, value);
        }
    }

    @Override
    public void setDDrip(int x, int z, float value) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            firmamentRegion.setDDrip(x & 0x1FF, z & 0x1FF, value);
        }
    }

    @Override
    public void markActive(int x, int z) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            firmamentRegion.markActive(x & 0x1FF, z & 0x1FF);
        }
    }

    @Override
    public void clearActive() {
        this.forEachRegion(FirmamentRegion::clearActive);
    }

    @Override
    public void markShouldUpdate(int x, int z) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion != null) {
            firmamentRegion.markShouldUpdate(x & 0x1FF, z & 0x1FF);
        }
    }

    @Override
    public boolean shouldUpdate() {
        return true;
    }

    @Override
    public void clearShouldUpdate() {
        this.forEachRegion(FirmamentRegion::clearShouldUpdate);
    }

    @Override
    public void markUpdatesFromActivity() {
        this.forEachRegion(FirmamentRegion::markUpdatesFromActivity);
    }

    public Level getLevel() {
        return this.level;
    }

    public FirmamentRegionManager getFirmamentRegionManager() {
        return this.firmamentRegionManager;
    }

    public static Firmament fromLevel(Level level) {
        if (level instanceof FirmamentHolder) {
            FirmamentHolder firmamentHolder = (FirmamentHolder)level;
            return firmamentHolder.operation_starcleave$getFirmament();
        }
        OperationStarcleave.LOGGER.info("World " + level.gatherChunkSourceStats() + " has no Firmament!?");
        return null;
    }

    @Nullable
    public FirmamentSubRegion getSubRegionFromId(long id) {
        int srx = (int)(id & 0xFFFFFFFFL);
        int srz = (int)(id >>> 32 & 0xFFFFFFFFL);
        int x = srx << 5;
        int z = srz << 5;
        return this.getSubRegion(x, z);
    }

    @Nullable
    public FirmamentSubRegion getSubRegion(int x, int z) {
        FirmamentRegion firmamentRegion = this.getFirmamentRegion(x, z);
        if (firmamentRegion == null) {
            return null;
        }
        int lx = x & 0x1FF;
        int lz = z & 0x1FF;
        int lsrx = lx >> 5;
        int lsrz = lz >> 5;
        return firmamentRegion.subRegions[lsrx][lsrz];
    }
}

