/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.world.firmament;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import phanastrae.operation_starcleave.world.firmament.Firmament;
import phanastrae.operation_starcleave.world.firmament.FirmamentAccess;
import phanastrae.operation_starcleave.world.firmament.FirmamentActor;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegionData;
import phanastrae.operation_starcleave.world.firmament.FirmamentSubRegion;
import phanastrae.operation_starcleave.world.firmament.FirmamentSubRegionData;
import phanastrae.operation_starcleave.world.firmament.RegionPos;

public class FirmamentRegion
implements FirmamentAccess {
    public static final int REGION_SIZE = 512;
    public static final int REGION_MASK = 511;
    public static final int REGION_SIZE_BITS = 9;
    public static final int SUBREGIONS = 16;
    public static final int SUBREGION_MASK = 31;
    public static final int SUBREGION_SIZE_BITS = 5;
    public FirmamentSubRegion[][] subRegions;
    boolean shouldUpdate = false;
    boolean active = false;
    boolean pendingClientUpdate = false;
    public final int x;
    public final int z;
    public final RegionPos regionPos;
    public final Firmament firmament;

    public FirmamentRegion(Firmament firmament, RegionPos regionPos) {
        this(firmament, regionPos.worldX, regionPos.worldZ);
    }

    public FirmamentRegion(Firmament firmament, int x, int z) {
        this.firmament = firmament;
        this.x = x;
        this.z = z;
        this.regionPos = RegionPos.fromWorldCoords(x, z);
        this.subRegions = new FirmamentSubRegion[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.subRegions[i][j] = new FirmamentSubRegion(this, x + i * 32, z + j * 32);
            }
        }
    }

    public boolean getActive(int x, int z) {
        return this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].active[4];
    }

    public void forEachSubRegion(Consumer<FirmamentSubRegion> method) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                method.accept(this.subRegions[i][j]);
            }
        }
    }

    @Override
    public void clearActors() {
        this.forEachSubRegion(FirmamentSubRegion::clearActors);
    }

    @Override
    public void addActor(FirmamentActor actor) {
        int x = actor.originX;
        int z = actor.originZ;
        this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].addActor(actor);
    }

    @Override
    public void manageActors() {
        this.forEachSubRegion(FirmamentSubRegion::manageActors);
    }

    @Override
    public void tickActors() {
        this.forEachSubRegion(FirmamentSubRegion::tickActors);
    }

    @Override
    public void forEachActor(Consumer<FirmamentActor> consumer) {
        this.forEachSubRegion(firmamentSubRegion -> firmamentSubRegion.forEachActor(consumer));
    }

    @Override
    public void forEachPosition(BiConsumer<Integer, Integer> method) {
        this.forEachSubRegion(firmamentSubRegion -> firmamentSubRegion.forEachActivePosition((x, z) -> method.accept(x + firmamentSubRegion.x - this.x, z + firmamentSubRegion.z - this.z)));
    }

    @Override
    public void forEachActivePosition(BiConsumer<Integer, Integer> method) {
        this.forEachSubRegion(firmamentSubRegion -> {
            if (firmamentSubRegion.shouldUpdate) {
                firmamentSubRegion.forEachActivePosition((x, z) -> method.accept(x + firmamentSubRegion.x - this.x, z + firmamentSubRegion.z - this.z));
            }
        });
    }

    @Override
    public int getDrip(int x, int z) {
        return this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].getDrip(x & 0x1F, z & 0x1F);
    }

    @Override
    public int getDamage(int x, int z) {
        return this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].getDamage(x & 0x1F, z & 0x1F);
    }

    @Override
    public int getDisplacement(int x, int z) {
        return this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].getDisplacement(x & 0x1F, z & 0x1F);
    }

    @Override
    public int getVelocity(int x, int z) {
        return this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].getVelocity(x & 0x1F, z & 0x1F);
    }

    @Override
    public float getDDrip(int x, int z) {
        return this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].getDDrip(x & 0x1F, z & 0x1F);
    }

    @Override
    public void setDrip(int x, int z, int value) {
        this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].setDrip(x & 0x1F, z & 0x1F, value);
    }

    @Override
    public void setDDrip(int x, int z, float value) {
        this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].setDDrip(x & 0x1F, z & 0x1F, value);
    }

    @Override
    public void setDamage(int x, int z, int value) {
        this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].setDamage(x & 0x1F, z & 0x1F, value);
        this.pendingClientUpdate = true;
    }

    @Override
    public void setDisplacement(int x, int z, int value) {
        this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].setDisplacement(x & 0x1F, z & 0x1F, value);
    }

    @Override
    public void setVelocity(int x, int z, int value) {
        this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].setVelocity(x & 0x1F, z & 0x1F, value);
    }

    @Override
    public void markActive(int x, int z) {
        this.active = true;
        this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].markActive(x & 0x1F, z & 0x1F);
    }

    @Override
    public void clearActive() {
        if (this.active) {
            this.active = false;
            this.forEachSubRegion(FirmamentSubRegion::clearActive);
        }
    }

    @Override
    public void markShouldUpdate(int x, int z) {
        this.shouldUpdate = true;
        this.subRegions[(x &= 0x1FF) >> 5][(z &= 0x1FF) >> 5].markShouldUpdate();
    }

    @Override
    public void clearShouldUpdate() {
        if (this.shouldUpdate) {
            this.shouldUpdate = false;
            this.forEachSubRegion(FirmamentSubRegion::clearShouldUpdate);
        }
    }

    @Override
    public void markUpdatesFromActivity() {
        if (this.active) {
            this.forEachSubRegion(FirmamentSubRegion::markUpdatesFromActivity);
        }
    }

    @Override
    public boolean shouldUpdate() {
        return this.shouldUpdate;
    }

    public void flushUpdates() {
        if (this.pendingClientUpdate) {
            this.pendingClientUpdate = false;
            this.forEachSubRegion(FirmamentSubRegion::flushUpdates);
        }
    }

    public void read(CompoundTag nbt) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                CompoundTag subregionNbt = nbt.getCompound("subregion_" + i + "_" + j);
                FirmamentSubRegion subRegion = this.subRegions[i][j];
                subRegion.readFromByteArray(subregionNbt.getByteArray("displacement"), subRegion.displacement, 15);
                subRegion.readFromByteArray(subregionNbt.getByteArray("velocity"), subRegion.velocity, 15);
                subRegion.readFromByteArray(subregionNbt.getByteArray("damage"), subRegion.damage, 7);
                subRegion.readFromByteArray(subregionNbt.getByteArray("drip"), subRegion.drip, 7);
            }
        }
    }

    public void write(CompoundTag nbt) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                CompoundTag subregionNbt = new CompoundTag();
                FirmamentSubRegion subRegion = this.subRegions[i][j];
                subregionNbt.putByteArray("displacement", subRegion.getAsByteArray(subRegion.displacement));
                subregionNbt.putByteArray("velocity", subRegion.getAsByteArray(subRegion.velocity));
                subregionNbt.putByteArray("damage", subRegion.getAsByteArray(subRegion.damage));
                subregionNbt.putByteArray("drip", subRegion.getAsByteArray(subRegion.drip));
                nbt.put("subregion_" + i + "_" + j, (Tag)subregionNbt);
            }
        }
    }

    public void readFromData(FirmamentRegionData firmamentRegionData) {
        int i;
        FirmamentSubRegionData[][] data = firmamentRegionData.subRegionData;
        if (data.length != 16) {
            return;
        }
        for (i = 0; i < 16; ++i) {
            if (data[i] != null && data[i].length == 16) continue;
            return;
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.subRegions[i][j].readFromData(data[i][j]);
            }
        }
    }
}

