/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.world.firmament;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.server.level.ServerPlayer;
import phanastrae.operation_starcleave.server.network.FirmamentRegionDataSender;
import phanastrae.operation_starcleave.world.firmament.RegionPos;

public class FirmamentRegionsWatched {
    Collection<Long> watchedRegions;
    private final ServerPlayer player;

    public FirmamentRegionsWatched(ServerPlayer player) {
        this.player = player;
        this.watchedRegions = new LongOpenHashSet();
    }

    public void onPositionChanged(RegionPos regionPosOld, RegionPos regionPosNew) {
        ArrayList<Long> regionsToAdd = new ArrayList<Long>(9);
        ArrayList<Long> regionsToKeep = new ArrayList<Long>(25);
        ArrayList<Long> regionsToRemove = new ArrayList<Long>(9);
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                RegionPos nearbyRegion = new RegionPos(regionPosNew.rx + i, regionPosNew.rz + j);
                if (!this.watchedRegions.contains(nearbyRegion.id) && i * i <= 1 && j * j <= 1) {
                    regionsToAdd.add(nearbyRegion.id);
                }
                regionsToKeep.add(nearbyRegion.id);
            }
        }
        for (Long id2 : this.watchedRegions) {
            if (regionsToKeep.contains(id2)) continue;
            regionsToRemove.add(id2);
        }
        regionsToAdd.forEach(id -> {
            if (this.watch((long)id)) {
                RegionPos regionPos = new RegionPos((long)id);
                FirmamentRegionDataSender.getFirmamentRegionDataSender(this.player.connection).add(regionPos);
            }
        });
        regionsToRemove.forEach(id -> {
            if (this.unWatch((long)id)) {
                RegionPos regionPos = new RegionPos((long)id);
                FirmamentRegionDataSender.getFirmamentRegionDataSender(this.player.connection).unload(this.player, regionPos);
            }
        });
    }

    public boolean watch(long id) {
        if (this.watchedRegions.contains(id)) {
            return false;
        }
        this.watchedRegions.add(id);
        return true;
    }

    public boolean unWatch(long id) {
        if (!this.watchedRegions.contains(id)) {
            return false;
        }
        this.watchedRegions.remove(id);
        return true;
    }

    public void unWatchAll() {
        this.watchedRegions.forEach(id -> {
            if (this.unWatch((long)id)) {
                RegionPos regionPos = new RegionPos((long)id);
                FirmamentRegionDataSender.getFirmamentRegionDataSender(this.player.connection).unload(this.player, regionPos);
            }
        });
    }
}

