/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.world.firmament;

import net.minecraft.world.entity.Entity;
import phanastrae.operation_starcleave.world.firmament.SubRegionPos;

public class RegionPos {
    public final long id;
    public final int rx;
    public final int rz;
    public final int worldX;
    public final int worldZ;

    public RegionPos(int rx, int rz) {
        this.rx = rx;
        this.rz = rz;
        this.id = (long)rx & 0xFFFFFFFFL | ((long)rz & 0xFFFFFFFFL) << 32;
        this.worldX = rx << 9;
        this.worldZ = rz << 9;
    }

    public RegionPos(long id) {
        this.id = id;
        this.rx = (int)(id & 0xFFFFFFFFL);
        this.rz = (int)(id >>> 32 & 0xFFFFFFFFL);
        this.worldX = this.rx << 9;
        this.worldZ = this.rz << 9;
    }

    public static RegionPos fromWorldCoords(int x, int z) {
        return new RegionPos(x >> 9, z >> 9);
    }

    public static RegionPos fromSubRegion(SubRegionPos subRegionPos) {
        return RegionPos.fromWorldCoords(subRegionPos.worldX, subRegionPos.worldZ);
    }

    public static RegionPos fromEntity(Entity entity) {
        return RegionPos.fromWorldCoords(entity.getBlockX(), entity.getBlockZ());
    }
}

