/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.world.firmament;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.world.firmament.Firmament;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegion;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegionHolder;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegionManager;
import phanastrae.operation_starcleave.world.firmament.FirmamentStorage;
import phanastrae.operation_starcleave.world.firmament.FirmamentWatcher;
import phanastrae.operation_starcleave.world.firmament.RegionPos;

public class ServerFirmamentRegionManager
extends FirmamentRegionManager {
    private long MAX_TIME_SINCE_LAST_ACCESS_BEFORE_UNLOAD = 100L;
    private Long2ObjectLinkedOpenHashMap<FirmamentRegionHolder> firmamentRegionHolders = new Long2ObjectLinkedOpenHashMap();
    private final ServerLevel serverWorld;
    private final BlockableEventLoop<Runnable> mainThreadExectutor;
    final Thread serverThread;

    public ServerFirmamentRegionManager(ServerLevel serverWorld) {
        this.serverWorld = serverWorld;
        this.serverThread = Thread.currentThread();
        this.mainThreadExectutor = new MainThreadExecutor((Level)serverWorld);
    }

    @Override
    public void forEachRegion(Consumer<FirmamentRegion> method) {
        this.firmamentRegionHolders.forEach((id, firmamentRegionHolder) -> {
            FirmamentRegion firmamentRegion = firmamentRegionHolder.getFirmamentRegion();
            if (firmamentRegion != null) {
                method.accept(firmamentRegion);
            }
        });
    }

    @Override
    @Nullable
    public FirmamentRegion getFirmamentRegion(long id) {
        if (this.firmamentRegionHolders.containsKey(id)) {
            return ((FirmamentRegionHolder)this.firmamentRegionHolders.get(id)).getFirmamentRegion();
        }
        return null;
    }

    @Override
    public void tick() {
        for (ServerPlayer serverPlayerEntity : this.serverWorld.players()) {
            ((FirmamentWatcher)serverPlayerEntity).operation_starcleave$getWatchedRegions().watchedRegions.forEach(id -> {
                if (this.firmamentRegionHolders.containsKey(id)) {
                    ((FirmamentRegionHolder)this.firmamentRegionHolders.get(id)).recordAccess();
                } else {
                    this.loadRegion((long)id);
                }
            });
        }
        this.firmamentRegionHolders.forEach((id, firmamentRegionHolder) -> {
            FirmamentRegion firmamentRegion = firmamentRegionHolder.getFirmamentRegion();
            if (firmamentRegion != null && firmamentRegion.shouldUpdate) {
                firmamentRegionHolder.recordAccess();
            }
        });
        ArrayList idsToUnload = new ArrayList();
        long currentTime = this.serverWorld.getGameTime();
        this.firmamentRegionHolders.forEach((id, firmamentRegionHolder) -> {
            if (firmamentRegionHolder.getTimeSinceLastAccess(currentTime) > this.MAX_TIME_SINCE_LAST_ACCESS_BEFORE_UNLOAD) {
                idsToUnload.add(id);
            }
        });
        Iterator iterator = idsToUnload.iterator();
        while (iterator.hasNext()) {
            long id2 = (Long)iterator.next();
            this.unloadRegion(id2);
        }
        this.firmamentRegionHolders.forEach((id, firmamentRegionHolders) -> {
            if (firmamentRegionHolders.getState() == FirmamentRegionHolder.FirmamentRegionState.READY_TO_START) {
                firmamentRegionHolders.setState(FirmamentRegionHolder.FirmamentRegionState.STARTED);
            }
        });
    }

    public void loadRegion(long id) {
        if (this.firmamentRegionHolders.containsKey(id)) {
            return;
        }
        RegionPos regionPos = new RegionPos(id);
        FirmamentRegion firmamentRegion = new FirmamentRegion(Firmament.fromLevel((Level)this.serverWorld), regionPos);
        FirmamentRegionHolder firmamentRegionHolder = new FirmamentRegionHolder(firmamentRegion);
        firmamentRegionHolder.recordAccess();
        firmamentRegionHolder.setState(FirmamentRegionHolder.FirmamentRegionState.LOADING);
        CompletionStage completableFuture = this.load(id).thenApply(onbt -> {
            if (onbt.isPresent()) {
                CompoundTag nbt = (CompoundTag)onbt.get();
                firmamentRegion.read(nbt);
                firmamentRegionHolder.setState(FirmamentRegionHolder.FirmamentRegionState.READY_TO_START);
            } else {
                firmamentRegionHolder.setState(FirmamentRegionHolder.FirmamentRegionState.READY_TO_START);
            }
            return true;
        });
        this.mainThreadExectutor.managedBlock(((CompletableFuture)completableFuture)::isDone);
        this.firmamentRegionHolders.put(id, (Object)firmamentRegionHolder);
    }

    public void unloadRegion(long id) {
        if (!this.firmamentRegionHolders.containsKey(id)) {
            return;
        }
        this.save(id);
        this.firmamentRegionHolders.remove(id);
    }

    public void saveAll() {
        this.firmamentRegionHolders.forEach((id, firmamentRegionHolder) -> this.save((long)id));
    }

    private void save(long id) {
        RegionPos regionPos = new RegionPos(id);
        ChunkPos chunkPos = ChunkPos.minFromRegion((int)regionPos.rx, (int)regionPos.rz);
        FirmamentStorage firmamentStorage = FirmamentStorage.getFrom(this.serverWorld);
        CompoundTag nbt = new CompoundTag();
        FirmamentRegion firmamentRegion = ((FirmamentRegionHolder)this.firmamentRegionHolders.get(id)).getFirmamentRegion();
        if (firmamentRegion != null) {
            firmamentRegion.write(nbt);
        }
        firmamentStorage.setNbt(chunkPos, nbt);
    }

    private CompletableFuture<Optional<CompoundTag>> load(long id) {
        RegionPos regionPos = new RegionPos(id);
        ChunkPos chunkPos = ChunkPos.minFromRegion((int)regionPos.rx, (int)regionPos.rz);
        FirmamentStorage firmamentStorage = FirmamentStorage.getFrom(this.serverWorld);
        return firmamentStorage.getNbt(chunkPos);
    }

    final class MainThreadExecutor
    extends BlockableEventLoop<Runnable> {
        MainThreadExecutor(Level world) {
            super("Firmament Region main thread executor for " + String.valueOf(world.dimension().location()));
        }

        protected Runnable wrapRunnable(Runnable runnable) {
            return runnable;
        }

        protected boolean shouldRun(Runnable task) {
            return true;
        }

        protected boolean scheduleExecutables() {
            return true;
        }

        protected Thread getRunningThread() {
            return ServerFirmamentRegionManager.this.serverThread;
        }

        protected void doRunTask(Runnable task) {
            ServerFirmamentRegionManager.this.serverWorld.getProfiler().incrementCounter("runTask");
            super.doRunTask(task);
        }

        public boolean pollTask() {
            return true;
        }
    }
}

