/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.block.PhlogisticFireBlock;
import phanastrae.operation_starcleave.block.tag.OperationStarcleaveBlockTags;
import phanastrae.operation_starcleave.entity.OperationStarcleaveDamageTypes;
import phanastrae.operation_starcleave.item.OperationStarcleaveItems;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.world.OperationStarcleaveGameRules;

public class NucleosyntheseedBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<NucleosyntheseedBlock> CODEC = NucleosyntheseedBlock.simpleCodec(NucleosyntheseedBlock::new);
    public static final int MAX_AGE = 15;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    public static final BooleanProperty GROWS_DOWN = BooleanProperty.create((String)"grows_down");

    protected MapCodec<? extends NucleosyntheseedBlock> codec() {
        return CODEC;
    }

    public NucleosyntheseedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)GROWS_DOWN, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, GROWS_DOWN});
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        level.scheduleTick(pos, (Block)this, 30 + level.getRandom().nextInt(120));
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        NucleosyntheseedBlock.trySpread(state, level, pos, random, false);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        NucleosyntheseedBlock.trySpread(state, level, pos, random, false);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getAbilities().mayBuild && stack.is(OperationStarcleaveItems.PHLOGISTON_SAC)) {
            NucleosyntheseedBlock.detonate(level, pos, 0);
            Item item = stack.getItem();
            stack.consume(1, (LivingEntity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 15;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        NucleosyntheseedBlock.trySpread(state, level, pos, random, true);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        for (Direction direction : Direction.values()) {
            BlockPos adjPos = pos.relative(direction);
            BlockState adjState = level.getBlockState(adjPos);
            if (adjState.isFaceSturdy((BlockGetter)level, pos, direction.getOpposite())) continue;
            for (int i = 0; i < 3 + random.nextInt(6); ++i) {
                level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.PLASMA_DUST, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1);
            }
        }
    }

    public static void trySpread(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, boolean forceGrowth) {
        if (!level.getGameRules().getBoolean(OperationStarcleaveGameRules.DO_NUCLEOSYNTHESEED_GROWTH) && !forceGrowth) {
            return;
        }
        if ((Integer)state.getValue((Property)AGE) == 15) {
            return;
        }
        boolean growsDown = (Boolean)state.getValue((Property)GROWS_DOWN);
        if (random.nextInt(8) <= (growsDown ? 1 : 2) && NucleosyntheseedBlock.trySpread(state, level, pos, random, growsDown ? Direction.DOWN : Direction.UP)) {
            return;
        }
        List directions = Direction.Plane.HORIZONTAL.shuffledCopy(random);
        for (Direction direction : directions) {
            if (!NucleosyntheseedBlock.trySpread(state, level, pos, random, direction)) continue;
            return;
        }
        level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)AGE));
    }

    public static boolean trySpread(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, Direction direction) {
        boolean growsDown = (Boolean)state.getValue((Property)GROWS_DOWN);
        int age = (Integer)state.getValue((Property)AGE);
        BlockState newState = random.nextInt(growsDown ? 6 : 3) == 0 ? (BlockState)state.cycle((Property)AGE) : state;
        BlockPos adjPos = pos.relative(direction);
        BlockState adjState = level.getBlockState(adjPos);
        if (NucleosyntheseedBlock.canBurrowThrough(adjState)) {
            BlockPos oppPos;
            BlockState oppState;
            boolean vertical;
            level.setBlockAndUpdate(adjPos, newState);
            level.scheduleTick(adjPos, newState.getBlock(), 30 + random.nextInt(120));
            level.setBlockAndUpdate(pos, (BlockState)OperationStarcleaveBlocks.NUCLEIC_FISSUREROOT.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
            if (!growsDown) {
                NucleosyntheseedBlock.spawnLeaves((Level)level, adjPos, random);
            }
            boolean bl = vertical = direction.getAxis() != Direction.Axis.Y;
            if ((vertical || growsDown) && NucleosyntheseedBlock.canBurrowThrough(oppState = level.getBlockState(oppPos = pos.relative(direction.getOpposite()))) && (random.nextInt(3) == 0 || vertical && growsDown && age <= 2)) {
                boolean makeGrowUp;
                int newAge = random.nextInt(3) == 0 ? 15 : Math.min(age + 5 + random.nextInt(5), 15);
                BlockState nState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge));
                boolean bl2 = makeGrowUp = vertical && growsDown;
                if (makeGrowUp) {
                    nState = (BlockState)nState.setValue((Property)GROWS_DOWN, (Comparable)Boolean.valueOf(false));
                }
                level.setBlockAndUpdate(oppPos, nState);
                level.scheduleTick(oppPos, newState.getBlock(), 30 + random.nextInt(120));
                if ((makeGrowUp || !growsDown) && random.nextInt(5) <= 1) {
                    NucleosyntheseedBlock.spawnLeaves((Level)level, oppPos, random);
                }
            }
            return true;
        }
        return false;
    }

    public static void spawnLeaves(Level level, BlockPos pos, RandomSource random) {
        int k;
        int j;
        int i;
        BlockPos adjPos;
        for (Direction direction : Direction.values()) {
            adjPos = pos.relative(direction);
            if (random.nextInt(5) == 0) continue;
            NucleosyntheseedBlock.trySpawnLeavesAtPos(level, adjPos);
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                for (k = -1; k <= 1; ++k) {
                    int distSqr = i * i + j * j + k * k;
                    if (distSqr != 2) continue;
                    adjPos = pos.offset(i, j, k);
                    if (random.nextInt(3) == 0 || NucleosyntheseedBlock.countAdjacentLeaves(level, adjPos) < 1) continue;
                    NucleosyntheseedBlock.trySpawnLeavesAtPos(level, adjPos);
                }
            }
        }
        for (i = -1; i <= 1; ++i) {
            if (i == 0) continue;
            for (j = -1; j <= 1; ++j) {
                if (j == 0) continue;
                for (k = -1; k <= 1; ++k) {
                    if (k == 0) continue;
                    BlockPos adjPos2 = pos.offset(i, j, k);
                    if (random.nextInt(2) == 0 || NucleosyntheseedBlock.countAdjacentLeaves(level, adjPos2) < 2) continue;
                    NucleosyntheseedBlock.trySpawnLeavesAtPos(level, adjPos2);
                }
            }
        }
    }

    public static int countAdjacentLeaves(Level level, BlockPos pos) {
        int count = 0;
        for (Direction direction : Direction.values()) {
            BlockPos adjPos = pos.relative(direction);
            BlockState adjState = level.getBlockState(adjPos);
            if (!adjState.is(OperationStarcleaveBlocks.NUCLEIC_FISSURELEAVES)) continue;
            ++count;
        }
        return count;
    }

    public static void trySpawnLeavesAtPos(Level level, BlockPos pos) {
        BlockState adjState = level.getBlockState(pos);
        if (adjState.isAir() || adjState.is(BlockTags.REPLACEABLE_BY_TREES)) {
            BlockState leafState = OperationStarcleaveBlocks.NUCLEIC_FISSURELEAVES.defaultBlockState();
            if (adjState.getFluidState().is(FluidTags.WATER)) {
                leafState = (BlockState)leafState.setValue((Property)LeavesBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            level.setBlockAndUpdate(pos, leafState);
        }
    }

    public static void detonate(Level level, BlockPos pos, int ignitingFireAge) {
        BlockState downState;
        Object downPos;
        int i;
        int newFireAge = Math.min(ignitingFireAge + 3, 6);
        level.setBlockAndUpdate(pos, PhlogisticFireBlock.getStateWithAge((LevelAccessor)level, pos, newFireAge));
        NucleosyntheseedBlock.instantlyIgniteNearbyHyperflammables(level, pos, newFireAge);
        NucleosyntheseedBlock.explode(level, pos);
        RandomSource random = level.getRandom();
        HashSet<Object> positions = new HashSet<Object>();
        HashSet<Object> positionsLast = new HashSet<Object>();
        positionsLast.add(NucleosyntheseedBlock.locateStartPos(level, pos));
        for (i = 0; i < 19; ++i) {
            for (BlockPos blockPos : positionsLast) {
                downPos = blockPos.below();
                downState = level.getBlockState((BlockPos)downPos);
                if (!NucleosyntheseedBlock.canErode(downState)) continue;
                if (!downState.is(OperationStarcleaveBlocks.PHLOGISTIC_FIRE)) {
                    level.setBlockAndUpdate((BlockPos)downPos, Blocks.AIR.defaultBlockState());
                    NucleosyntheseedBlock.potentiallySpawnParticle(level, (BlockPos)downPos);
                    NucleosyntheseedBlock.coagulateHorizontallyAdjacentPlasma(level, (BlockPos)downPos);
                }
                positions.add(downPos);
            }
            positionsLast.clear();
            for (BlockPos blockPos : positions) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockState adjState;
                    BlockPos adjPos = blockPos.relative(direction);
                    if (positionsLast.contains(adjPos) || !NucleosyntheseedBlock.canErode(adjState = level.getBlockState(adjPos)) || random.nextInt(5) > 1) continue;
                    if (!adjState.is(OperationStarcleaveBlocks.PHLOGISTIC_FIRE)) {
                        level.setBlockAndUpdate(adjPos, Blocks.AIR.defaultBlockState());
                        NucleosyntheseedBlock.potentiallySpawnParticle(level, adjPos);
                        NucleosyntheseedBlock.coagulateHorizontallyAdjacentPlasma(level, adjPos);
                    }
                    positionsLast.add(adjPos);
                }
            }
            positionsLast.addAll(positions);
            positions.clear();
            if (positionsLast.isEmpty()) break;
        }
        positions.addAll(positionsLast);
        for (i = 0; i < 15; ++i) {
            for (BlockPos blockPos : positions) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos adjPos = blockPos.relative(direction);
                    if (positions.contains(adjPos) || random.nextInt(1) != 0) continue;
                    positionsLast.remove(blockPos);
                    BlockPos downPos2 = blockPos.below();
                    BlockState downState2 = level.getBlockState(downPos2);
                    if (!NucleosyntheseedBlock.canErode(downState2) || (downState2.canBeReplaced() || !downState2.canOcclude()) && i <= 1 || downState2.is(OperationStarcleaveBlocks.PHLOGISTIC_FIRE)) continue;
                    level.setBlockAndUpdate(downPos2, OperationStarcleaveBlocks.COAGULATED_PLASMA.defaultBlockState());
                    NucleosyntheseedBlock.potentiallySpawnParticle(level, downPos2);
                    NucleosyntheseedBlock.coagulateHorizontallyAdjacentPlasma(level, downPos2);
                }
            }
            positions.clear();
            for (BlockPos blockPos : positionsLast) {
                boolean spawnsPlasmaAtHeight;
                downPos = blockPos.below();
                downState = level.getBlockState((BlockPos)downPos);
                boolean bl = spawnsPlasmaAtHeight = i >= 2;
                if (!NucleosyntheseedBlock.canErode(downState) || (downState.canBeReplaced() || !downState.canOcclude()) && !spawnsPlasmaAtHeight) continue;
                BlockState state = (!spawnsPlasmaAtHeight ? Blocks.AIR : (i < 14 ? OperationStarcleaveBlocks.PETRICHORIC_PLASMA : OperationStarcleaveBlocks.COAGULATED_PLASMA)).defaultBlockState();
                if (!downState.is(OperationStarcleaveBlocks.PHLOGISTIC_FIRE) || spawnsPlasmaAtHeight) {
                    level.setBlockAndUpdate((BlockPos)downPos, state);
                    NucleosyntheseedBlock.potentiallySpawnParticle(level, (BlockPos)downPos);
                    if (!spawnsPlasmaAtHeight) {
                        NucleosyntheseedBlock.coagulateHorizontallyAdjacentPlasma(level, (BlockPos)downPos);
                    }
                }
                positions.add(downPos);
            }
            positionsLast.clear();
            positionsLast.addAll(positions);
            if (positionsLast.isEmpty()) break;
        }
    }

    public static void potentiallySpawnParticle(Level level, BlockPos pos) {
        RandomSource random = level.random;
        if (random.nextInt(32) == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)OperationStarcleaveParticleTypes.LARGE_NUCLEAR_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 2, 0.25, 0.25, 0.25, 0.2);
        }
    }

    public static void coagulateHorizontallyAdjacentPlasma(Level level, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjPos = pos.relative(direction);
            BlockState adjState = level.getBlockState(adjPos);
            FluidState adjFState = level.getFluidState(adjPos);
            if (!adjState.is(OperationStarcleaveBlocks.PETRICHORIC_PLASMA) || adjFState.isEmpty() || !adjFState.isSource()) continue;
            level.setBlockAndUpdate(adjPos, OperationStarcleaveBlocks.COAGULATED_PLASMA.defaultBlockState());
        }
    }

    public static BlockPos locateStartPos(Level level, BlockPos pos) {
        BlockPos startPos = pos;
        for (int i = 0; i < 7; ++i) {
            BlockPos upPos = startPos.above();
            BlockState upState = level.getBlockState(upPos);
            if (!NucleosyntheseedBlock.canErode(upState)) continue;
            startPos = upPos;
        }
        return startPos;
    }

    public static void instantlyIgniteNearbyHyperflammables(Level level, BlockPos pos, int fireAge) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        int searchRadius = 3;
        for (int i = -searchRadius; i <= searchRadius; ++i) {
            mutableBlockPos.setX(pos.getX() + i);
            for (int j = -searchRadius; j <= searchRadius; ++j) {
                mutableBlockPos.setY(pos.getY() + j);
                for (int k = -searchRadius; k < searchRadius; ++k) {
                    int distSqr = i * i + j * j + k * k;
                    if (distSqr > searchRadius * searchRadius) continue;
                    mutableBlockPos.setZ(pos.getZ() + k);
                    BlockState currentState = level.getBlockState((BlockPos)mutableBlockPos);
                    if (!currentState.is(OperationStarcleaveBlockTags.PHLOGISTIC_HYPERFLAMMABLES) || currentState.is(OperationStarcleaveBlocks.NUCLEOSYNTHESEED)) continue;
                    level.setBlockAndUpdate((BlockPos)mutableBlockPos, PhlogisticFireBlock.getStateWithAge((LevelAccessor)level, (BlockPos)mutableBlockPos, fireAge));
                }
            }
        }
    }

    public static void explode(Level level, BlockPos pos) {
        ExplosionDamageCalculator damageCalculator = new ExplosionDamageCalculator(){

            public boolean shouldBlockExplode(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
                return state.is(OperationStarcleaveBlockTags.NUCLEOSYNTHESEED_BLAST_IMMUNE) ? false : super.shouldBlockExplode(explosion, reader, pos, state, power);
            }
        };
        level.explode(null, OperationStarcleaveDamageTypes.source(level, OperationStarcleaveDamageTypes.IN_PHLOGISTIC_FIRE), damageCalculator, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 4.0f, false, Level.ExplosionInteraction.TNT, (ParticleOptions)OperationStarcleaveParticleTypes.NUCLEAR_SMOKE, (ParticleOptions)OperationStarcleaveParticleTypes.LARGE_NUCLEAR_SMOKE, (Holder)SoundEvents.GENERIC_EXPLODE);
    }

    public static boolean canBurrowThrough(BlockState state) {
        return NucleosyntheseedBlock.canDestroy(state);
    }

    public static boolean canErode(BlockState state) {
        if (state.is(OperationStarcleaveBlocks.COAGULATED_PLASMA)) {
            return true;
        }
        return NucleosyntheseedBlock.canDestroy(state);
    }

    public static boolean canDestroy(BlockState state) {
        if (state.is(OperationStarcleaveBlockTags.NUCLEOSYNTHESEED_BLAST_IMMUNE)) {
            return false;
        }
        if (state.is(OperationStarcleaveBlocks.PETRICHORIC_PLASMA) || state.is(OperationStarcleaveBlocks.PETRICHORIC_VAPOR)) {
            return true;
        }
        if (state.canBeReplaced()) {
            return true;
        }
        return NucleosyntheseedBlock.mayDestroy(state);
    }

    public static boolean mayDestroy(BlockState state) {
        if (state.is(BlockTags.WITHER_IMMUNE) || state.is(BlockTags.DRAGON_IMMUNE)) {
            return false;
        }
        return !(state.getBlock().getExplosionResistance() > 6.0f);
    }
}

