/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import phanastrae.operation_starcleave.block.AbstractPetrichoricBlock;
import phanastrae.operation_starcleave.block.CustomLiquidBlock;
import phanastrae.operation_starcleave.entity.OperationStarcleaveDamageTypes;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;

public class PetrichoricPlasmaLiquidBlock
extends CustomLiquidBlock {
    protected PetrichoricPlasmaLiquidBlock(FlowingFluid fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        level.scheduleTick(pos, (Block)this, PetrichoricPlasmaLiquidBlock.getDelay(level.getRandom(), (LevelAccessor)level, pos, oldState));
        super.onPlace(state, level, pos, oldState, notify);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        block2: {
            block3: {
                if (!entity.hurt(OperationStarcleaveDamageTypes.source(level, OperationStarcleaveDamageTypes.IN_PHLOGISTIC_FIRE), 12.0f)) break block2;
                if (!(entity instanceof Player)) break block3;
                Player player = (Player)entity;
                if (player.getAbilities().invulnerable && player.getAbilities().flying) break block2;
            }
            RandomSource random = level.getRandom();
            entity.push((double)random.nextFloat() * 0.8 - 0.4, (double)random.nextFloat() * 0.3 + 0.6, (double)random.nextFloat() * 0.8 - 0.4);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.getBlockState(pos.above()).isAir()) {
            if (random.nextInt(8) == 0) {
                x = (double)pos.getX() + random.nextDouble();
                y = (double)pos.getY() + random.nextDouble() * 0.2 + 0.8;
                z = (double)pos.getZ() + random.nextDouble();
                level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.LARGE_GLIMMER_SMOKE, x, y, z, 0.0, 0.0, 0.0);
            } else {
                x = (double)pos.getX() + random.nextDouble();
                y = (double)pos.getY() + random.nextDouble() * 0.2 + 0.8;
                z = (double)pos.getZ() + random.nextDouble();
                level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.NUCLEAR_SMOKE, x, y, z, 0.0, 0.0, 0.0);
            }
            for (int j = 0; j < 1 + random.nextInt(3); ++j) {
                double x = (double)pos.getX() + random.nextDouble();
                double y = (double)pos.getY() + random.nextDouble() * 0.2 + 0.8;
                double z = (double)pos.getZ() + random.nextDouble();
                level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.PLASMA_DUST, x, y, z, random.nextGaussian() * 0.25, random.nextGaussian() * 0.25, random.nextGaussian() * 0.25);
            }
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        level.scheduleTick(pos, (Block)this, PetrichoricPlasmaLiquidBlock.getDelay(level.getRandom(), level, pos, state));
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        AbstractPetrichoricBlock.absorbWater((Level)level, pos, random);
    }

    public static int getDelay(RandomSource random, LevelAccessor level, BlockPos pos, BlockState state) {
        return 2 + random.nextInt(3);
    }
}

