/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.mojang.serialization.MapCodec;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;

public class PlasmaIceBlock
extends Block {
    public static final MapCodec<PlasmaIceBlock> CODEC = PlasmaIceBlock.simpleCodec(PlasmaIceBlock::new);
    public static final int MAX_DISTANCE = 4;
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"distance", (int)1, (int)4);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;

    protected MapCodec<? extends PlasmaIceBlock> codec() {
        return CODEC;
    }

    public PlasmaIceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(4))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, PERSISTENT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = (BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true));
        return PlasmaIceBlock.updateDistance(blockstate, (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        int i = PlasmaIceBlock.getDistanceAt(facingState) + 1;
        if (i != 1 || (Integer)state.getValue((Property)DISTANCE) != i) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return state;
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)DISTANCE) == 4 && (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.tryDestroy(state, level, pos, random);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState newState = PlasmaIceBlock.updateDistance(state, (LevelAccessor)level, pos);
        level.setBlock(pos, newState, 3);
        this.tryDestroy(newState, level, pos, random);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(6) == 0) {
            for (Direction direction : Direction.values()) {
                BlockPos adjPos = pos.relative(direction);
                BlockState adjState = level.getBlockState(adjPos);
                if (adjState.isFaceSturdy((BlockGetter)level, pos, direction.getOpposite())) continue;
                for (int i = 0; i < 2 + random.nextInt(3); ++i) {
                    level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.PLASMA_DUST, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1);
                }
            }
        }
    }

    public void tryDestroy(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.decaying(state)) {
            level.destroyBlock(pos, false);
            for (Direction direction : Direction.values()) {
                BlockPos adjPos = pos.relative(direction);
                BlockState adjState = level.getBlockState(adjPos);
                if (!adjState.is(OperationStarcleaveBlocks.PLASMA_ICE)) continue;
                level.scheduleTick(adjPos, adjState.getBlock(), random.nextInt(2) + 1);
            }
        }
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int i = 4;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutableBlockPos.setWithOffset((Vec3i)pos, direction);
            i = Math.min(i, PlasmaIceBlock.getDistanceAt(level.getBlockState((BlockPos)mutableBlockPos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState neighbor) {
        return PlasmaIceBlock.getOptionalDistanceAt(neighbor).orElse(4);
    }

    public static OptionalInt getOptionalDistanceAt(BlockState state) {
        if (!state.getFluidState().isEmpty()) {
            return OptionalInt.of(0);
        }
        return state.hasProperty((Property)DISTANCE) ? OptionalInt.of((Integer)state.getValue((Property)DISTANCE)) : OptionalInt.empty();
    }

    protected boolean decaying(BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false && (Integer)state.getValue((Property)DISTANCE) == 4;
    }
}

