/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.entity.OperationStarcleaveDamageTypes;
import phanastrae.operation_starcleave.item.OperationStarcleaveItems;
import phanastrae.operation_starcleave.item.StarbleachCoating;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.recipe.ItemStarbleachingRecipe;
import phanastrae.operation_starcleave.recipe.OperationStarcleaveRecipeTypes;
import phanastrae.operation_starcleave.recipe.input.ItemStarbleachingRecipeInput;

public class StarbleachCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<StarbleachCauldronBlock> CODEC = StarbleachCauldronBlock.simpleCodec(StarbleachCauldronBlock::new);
    public static final int MAX_STARBLEACH_LEVEL = 7;
    public static final IntegerProperty LEVEL_7 = IntegerProperty.create((String)"level", (int)1, (int)7);
    public static CauldronInteraction.InteractionMap STARBLEACH_CAULDRON_BEHAVIOR = CauldronInteraction.newInteractionMap((String)"operation_starcleave:starbleach");
    public static final float STARBLEACHING_FOOD_COST = 0.25f;

    protected MapCodec<? extends AbstractCauldronBlock> codec() {
        return CODEC;
    }

    public StarbleachCauldronBlock(BlockBehaviour.Properties settings) {
        super(settings, STARBLEACH_CAULDRON_BEHAVIOR);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL_7, (Comparable)Integer.valueOf(1)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LEVEL_7});
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.getValue((Property)LEVEL_7);
    }

    public boolean isFull(BlockState state) {
        return (Integer)state.getValue((Property)LEVEL_7) == 7;
    }

    protected boolean canReceiveStalactiteDrip(Fluid fluid) {
        return false;
    }

    protected double getContentHeight(BlockState state) {
        return (8.0 + (double)((Integer)state.getValue((Property)LEVEL_7)).intValue()) / 16.0;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.isClientSide) {
            return;
        }
        if (this.isEntityInsideContent(state, pos, entity)) {
            Entity owner;
            Player playerOwner;
            ItemEntity itemEntity;
            ItemStack itemStack;
            Optional<ItemStack> optionalItemStack;
            if (entity instanceof ItemEntity && (optionalItemStack = this.attemptCraft(world, itemStack = (itemEntity = (ItemEntity)entity).getItem(), pos, playerOwner = (owner = itemEntity.getOwner()) instanceof Player ? (Player)owner : null, true)).isPresent()) {
                ItemStack outputStack = optionalItemStack.get();
                ItemEntity newEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, outputStack);
                world.addFreshEntity((Entity)newEntity);
                if (itemStack.isEmpty()) {
                    itemEntity.discard();
                }
                return;
            }
            entity.hurt(OperationStarcleaveDamageTypes.source(world, OperationStarcleaveDamageTypes.INTERNAL_STARBLEACHING), 0.25f * (float)((Integer)state.getValue((Property)LEVEL_7)).intValue());
            if (!entity.isAlive() && world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                StarbleachCauldronBlock.spawnParticles(serverWorld, pos);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean creativeMode;
        ItemStack itemStack = player.getItemInHand(hand);
        Optional<ItemStack> optionalItemStack = this.attemptCraft(world, itemStack, pos, player, !(creativeMode = player.getAbilities().instabuild));
        if (optionalItemStack.isPresent()) {
            if (!world.isClientSide) {
                ItemStack outputStack = optionalItemStack.get();
                if (creativeMode) {
                    if (!player.getInventory().contains(outputStack)) {
                        player.getInventory().add(outputStack);
                    }
                } else if (itemStack.isEmpty()) {
                    player.setItemInHand(hand, outputStack);
                } else if (!player.getInventory().add(outputStack)) {
                    player.drop(outputStack, false);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        CauldronInteraction cauldronBehavior = (CauldronInteraction)this.interactions.map().get(itemStack.getItem());
        return cauldronBehavior.interact(state, world, pos, player, hand, itemStack);
    }

    public Optional<ItemStack> attemptCraft(Level world, ItemStack input, BlockPos pos, @Nullable Player player, boolean decrement) {
        ItemStarbleachingRecipe recipe = StarbleachCauldronBlock.getRecipe(world, input);
        if (recipe != null && StarbleachCauldronBlock.canEmptyCauldron(world, pos, recipe.getRequiredStarbleachToAttemptCraft())) {
            if (!world.isClientSide) {
                this.craft(world, pos, recipe.getStarbleachCost(), !recipe.getIsFillingRecipe(), input, player, decrement);
                return Optional.of(recipe.getOutputStack());
            }
            return Optional.of(ItemStack.EMPTY);
        }
        if (StarbleachCoating.canAddStarbleach(input) && StarbleachCauldronBlock.canEmptyCauldron(world, pos, 1)) {
            if (!world.isClientSide) {
                ItemStack coatedStack = input.copy();
                coatedStack.setCount(1);
                StarbleachCoating.addStarbleach(coatedStack);
                this.craft(world, pos, 0.25f, true, input, player, decrement);
                return Optional.of(coatedStack);
            }
            return Optional.of(ItemStack.EMPTY);
        }
        return Optional.empty();
    }

    public void craft(Level world, BlockPos blockPos, float starbleachCost, boolean spawnParticles, ItemStack input, @Nullable Player player, boolean decrement) {
        if (player != null) {
            StarbleachCauldronBlock.incrementStats(player, input);
        }
        StarbleachCauldronBlock.emptyCauldron(world, blockPos, ItemStarbleachingRecipe.getConsumedStarbleach(world.getRandom(), starbleachCost), spawnParticles);
        if (decrement) {
            input.shrink(1);
        }
    }

    @Nullable
    public static ItemStarbleachingRecipe getRecipe(Level world, ItemStack stack) {
        ItemStarbleachingRecipeInput input = new ItemStarbleachingRecipeInput(stack);
        Optional recipeEntryOptional = world.getRecipeManager().getRecipeFor(OperationStarcleaveRecipeTypes.ITEM_STARBLEACHING, (RecipeInput)input, world);
        return recipeEntryOptional.map(RecipeHolder::value).orElse(null);
    }

    public static void spawnParticles(ServerLevel world, BlockPos blockPos) {
        Vec3 pos = Vec3.atCenterOf((Vec3i)blockPos);
        world.sendParticles((ParticleOptions)OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER, pos.x(), pos.y(), pos.z(), 400, 0.2, 0.4, 0.2, 0.005);
    }

    private static CauldronInteraction getFillingBehaviour() {
        return (state, world, pos, player, hand, stack) -> {
            if (StarbleachCauldronBlock.canFillCauldron(world, pos)) {
                if (!world.isClientSide) {
                    StarbleachCauldronBlock.incrementStats(player, stack);
                    player.awardStat(Stats.FILL_CAULDRON);
                    StarbleachCauldronBlock.fillCauldron(world, pos);
                    ItemStack outputStack = Items.GLASS_BOTTLE.getDefaultInstance();
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)outputStack));
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        };
    }

    public static void incrementStats(Player player, @Nullable ItemStack itemStack) {
        if (itemStack != null && !itemStack.isEmpty()) {
            player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
        }
    }

    public static void fillCauldron(Level world, BlockPos blockPos) {
        BlockState state = world.getBlockState(blockPos);
        int currentStarbleachLevel = StarbleachCauldronBlock.getStarbleachLevel(state);
        world.setBlockAndUpdate(blockPos, StarbleachCauldronBlock.getStateWithStarbleachLevel(currentStarbleachLevel + 1));
        world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)state));
        world.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, blockPos);
        world.playSound(null, blockPos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void emptyCauldron(Level world, BlockPos blockPos, int amount, boolean spawnParticles) {
        BlockState state = world.getBlockState(blockPos);
        int currentStarbleachLevel = StarbleachCauldronBlock.getStarbleachLevel(state);
        world.setBlockAndUpdate(blockPos, StarbleachCauldronBlock.getStateWithStarbleachLevel(currentStarbleachLevel - amount));
        world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)state));
        world.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, blockPos);
        if (spawnParticles) {
            world.playSound(null, blockPos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.5f);
        } else {
            world.playSound(null, blockPos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (spawnParticles && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            StarbleachCauldronBlock.spawnParticles(serverWorld, blockPos);
        }
    }

    public static boolean canFillCauldron(Level world, BlockPos blockPos) {
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(Blocks.CAULDRON) || blockState.is(OperationStarcleaveBlocks.STARBLEACH_CAULDRON)) {
            int currentStarbleachLevel = StarbleachCauldronBlock.getStarbleachLevel(blockState);
            return currentStarbleachLevel != 7;
        }
        return false;
    }

    public static boolean canEmptyCauldron(Level world, BlockPos blockPos, int amount) {
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(OperationStarcleaveBlocks.STARBLEACH_CAULDRON)) {
            int currentStarbleachLevel = StarbleachCauldronBlock.getStarbleachLevel(blockState);
            return currentStarbleachLevel >= amount;
        }
        return false;
    }

    public static int getStarbleachLevel(BlockState state) {
        if (state.is(OperationStarcleaveBlocks.STARBLEACH_CAULDRON)) {
            return (Integer)state.getValue((Property)LEVEL_7);
        }
        return 0;
    }

    public static BlockState getStateWithStarbleachLevel(int level) {
        if (level <= 0) {
            return Blocks.CAULDRON.defaultBlockState();
        }
        if (level > 7) {
            level = 7;
        }
        return (BlockState)OperationStarcleaveBlocks.STARBLEACH_CAULDRON.defaultBlockState().setValue((Property)LEVEL_7, (Comparable)Integer.valueOf(level));
    }

    public static void init() {
        CauldronInteraction.EMPTY.map().put(OperationStarcleaveItems.STARBLEACH_BOTTLE, StarbleachCauldronBlock.getFillingBehaviour());
        STARBLEACH_CAULDRON_BEHAVIOR.map().put(OperationStarcleaveItems.STARBLEACH_BOTTLE, StarbleachCauldronBlock.getFillingBehaviour());
    }
}

