/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.network;

import net.minecraft.client.multiplayer.ChunkBatchSizeCalculator;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import phanastrae.operation_starcleave.client.duck.ClientPacketListenerDuck;
import phanastrae.operation_starcleave.client.render.ScreenShakeManager;
import phanastrae.operation_starcleave.client.render.firmament.FirmamentTextureStorage;
import phanastrae.operation_starcleave.client.services.XPlatClientInterface;
import phanastrae.operation_starcleave.client.world.firmament.ClientFirmamentRegionManager;
import phanastrae.operation_starcleave.client.world.firmament.FirmamentDamageGlowActor;
import phanastrae.operation_starcleave.duck.LevelDuckInterface;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityAttachment;
import phanastrae.operation_starcleave.entity.projectile.StarbleachedPearlEntity;
import phanastrae.operation_starcleave.network.packet.AcknowledgeFirmamentRegionDataPayload;
import phanastrae.operation_starcleave.network.packet.EntityPegasusFlyingPayload;
import phanastrae.operation_starcleave.network.packet.EntityPegasusGlidingPayload;
import phanastrae.operation_starcleave.network.packet.EntityPhlogisticFirePayload;
import phanastrae.operation_starcleave.network.packet.FirmamentCleavedPayload;
import phanastrae.operation_starcleave.network.packet.FirmamentRegionDataPayload;
import phanastrae.operation_starcleave.network.packet.FirmamentRegionSentPayload;
import phanastrae.operation_starcleave.network.packet.StarbleachedPearlLaunchPayload;
import phanastrae.operation_starcleave.network.packet.StartFirmamentRegionSendPayload;
import phanastrae.operation_starcleave.network.packet.UnloadFirmamentRegionPayload;
import phanastrae.operation_starcleave.network.packet.UpdateFirmamentSubRegionPayload;
import phanastrae.operation_starcleave.world.firmament.Firmament;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegion;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegionHolder;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegionManager;
import phanastrae.operation_starcleave.world.firmament.FirmamentSubRegion;

public class OperationStarcleaveClientPacketHandler {
    public static void startFirmamentRegionSend(StartFirmamentRegionSendPayload payload, Player player) {
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            ((ClientPacketListenerDuck)localPlayer.connection).operation_starcleave$getFirmamentRegionBatchSizeCalculator().onBatchStart();
        }
    }

    public static void receiveFirmamentRegionData(FirmamentRegionDataPayload payload, Player player) {
        Level world = player.level();
        Firmament firmament = Firmament.fromLevel(world);
        if (firmament != null) {
            FirmamentRegionManager firmamentRegionManager;
            FirmamentRegion firmamentRegion = firmament.getFirmamentRegion(payload.regionId());
            if (firmamentRegion == null && (firmamentRegionManager = firmament.getFirmamentRegionManager()) instanceof ClientFirmamentRegionManager) {
                ClientFirmamentRegionManager clientFirmamentRegionManager = (ClientFirmamentRegionManager)firmamentRegionManager;
                FirmamentRegionHolder firmamentRegionHolder = clientFirmamentRegionManager.loadRegion(payload.regionId());
                firmamentRegion = firmamentRegionHolder.getFirmamentRegion();
            }
            if (firmamentRegion != null) {
                firmamentRegion.readFromData(payload.firmamentRegionData());
                FirmamentTextureStorage.getInstance().onRegionAdded(firmamentRegion, world);
            }
        }
    }

    public static void sentFirmamentRegion(FirmamentRegionSentPayload payload, Player player) {
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            ChunkBatchSizeCalculator firmamentRegionBatchSizeCalculator = ((ClientPacketListenerDuck)localPlayer.connection).operation_starcleave$getFirmamentRegionBatchSizeCalculator();
            firmamentRegionBatchSizeCalculator.onBatchFinished(payload.batchSize());
            XPlatClientInterface.INSTANCE.sendPayload(new AcknowledgeFirmamentRegionDataPayload(firmamentRegionBatchSizeCalculator.getDesiredChunksPerTick()));
        }
    }

    public static void updateFirmamentSubRegion(UpdateFirmamentSubRegionPayload payload, Player player) {
        FirmamentSubRegion firmamentSubRegion;
        Level world = player.level();
        Firmament firmament = Firmament.fromLevel(world);
        if (firmament != null && (firmamentSubRegion = firmament.getSubRegionFromId(payload.id())) != null) {
            firmamentSubRegion.readFromData(payload.subRegionData());
            FirmamentTextureStorage.getInstance().onSubRegionUpdated(firmamentSubRegion, world);
        }
    }

    public static void unloadFirmamentRegion(UnloadFirmamentRegionPayload payload, Player player) {
        FirmamentRegionManager firmamentRegionManager;
        Firmament firmament = Firmament.fromLevel(player.level());
        if (firmament != null && (firmamentRegionManager = firmament.getFirmamentRegionManager()) instanceof ClientFirmamentRegionManager) {
            ClientFirmamentRegionManager clientFirmamentRegionManager = (ClientFirmamentRegionManager)firmamentRegionManager;
            clientFirmamentRegionManager.unloadRegion(payload.regionId());
        }
    }

    public static void onFirmamentCleaved(FirmamentCleavedPayload payload, Player player) {
        Level world = player.level();
        ((LevelDuckInterface)world).operation_starcleave$setCleavingFlashTicksLeft(24);
        Vec3 pos = new Vec3((double)payload.x(), (double)(world.getMaxBuildHeight() + 16), (double)payload.z());
        world.playLocalSound(pos.x, pos.y, pos.z, (SoundEvent)SoundEvents.TRIDENT_THUNDER.value(), SoundSource.BLOCKS, 500.0f, 1.6f + world.random.nextFloat() * 0.2f, false);
        SimpleParticleType particleEffect = ParticleTypes.FLASH;
        world.addAlwaysVisibleParticle((ParticleOptions)particleEffect, pos.x, pos.y - 1.0, pos.z, 0.0, 0.0, 0.0);
        ScreenShakeManager.getInstance().setShakeAmount(3);
        Firmament firmament = Firmament.fromLevel(world);
        if (firmament != null) {
            firmament.addActor(new FirmamentDamageGlowActor(firmament, (int)pos.x, (int)pos.z));
        }
    }

    public static void onStarbleachedPearlLaunch(StarbleachedPearlLaunchPayload payload, Player player) {
        Entity e;
        Entity except = null;
        if (payload.exceptExists() && (e = player.level().getEntity(payload.exceptId())) != null) {
            except = e;
        }
        StarbleachedPearlEntity.doRepulsion(payload.pos(), payload.radius(), payload.maxAddedSpeed(), player.level(), except);
    }

    public static void handleEntityPhlogisticFire(EntityPhlogisticFirePayload payload, Player player) {
        Level world = player.level();
        Entity entity = world.getEntity(payload.id());
        if (entity != null) {
            OperationStarcleaveEntityAttachment.fromEntity(entity).setOnPhlogisticFire(payload.onPhlogisticFire());
        }
    }

    public static void handleEntityPegasusGliding(EntityPegasusGlidingPayload payload, Player player) {
        Level world = player.level();
        Entity entity = world.getEntity(payload.id());
        if (entity != null) {
            OperationStarcleaveEntityAttachment.fromEntity(entity).setPegasusGliding(payload.pegasusGliding());
        }
    }

    public static void handleEntityPegasusFlying(EntityPegasusFlyingPayload payload, Player player) {
        Level world = player.level();
        Entity entity = world.getEntity(payload.id());
        if (entity != null) {
            OperationStarcleaveEntityAttachment.fromEntity(entity).setPegasusFlying(payload.pegasusFlying());
        }
    }
}

