/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.LargeSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.SuspendedParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import phanastrae.operation_starcleave.client.particle.LargeNuclearSmokeParticle;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;

public class OperationStarcleaveParticles {
    public static void init(ClientParticleRegistrar r) {
        r.register(OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER, FirmamentGlimmerFactory::new);
        r.register(OperationStarcleaveParticleTypes.GLIMMER_SMOKE, GlimmerSmokeFactory::new);
        r.register(OperationStarcleaveParticleTypes.LARGE_GLIMMER_SMOKE, LargeGlimmerSmokeFactory::new);
        r.register(OperationStarcleaveParticleTypes.PLASMA_DUST, PlasmaDustFactory::new);
        r.register(OperationStarcleaveParticleTypes.NUCLEAR_SMOKE, NuclearSmokeFactory::new);
        r.register(OperationStarcleaveParticleTypes.LARGE_NUCLEAR_SMOKE, LargeNuclearSmokeParticle.LargeNuclearSmokeFactory::new);
    }

    @FunctionalInterface
    public static interface ParticleRegistration<T extends ParticleOptions> {
        public ParticleProvider<T> create(SpriteSet var1);
    }

    @FunctionalInterface
    public static interface ClientParticleRegistrar {
        public <T extends ParticleOptions> void register(ParticleType<T> var1, ParticleRegistration<T> var2);
    }

    public static class NuclearSmokeFactory
    extends LargeSmokeParticle.Provider {
        public NuclearSmokeFactory(SpriteSet spriteProvider) {
            super(spriteProvider);
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Particle particle = super.createParticle(simpleParticleType, clientLevel, x, y, z, xSpeed, ySpeed, zSpeed);
            if (particle != null) {
                float l = clientLevel.random.nextFloat();
                float red = Mth.lerp((float)(l * l), (float)14.0f, (float)127.0f) / 255.0f;
                float green = Mth.lerp((float)(l * l), (float)56.0f, (float)212.0f) / 255.0f;
                float blue = Mth.lerp((float)(l * l), (float)25.0f, (float)36.0f) / 255.0f;
                particle.setColor(red, green, blue);
                particle.setParticleSpeed(xSpeed, ySpeed, zSpeed);
            }
            return particle;
        }
    }

    public static class PlasmaDustFactory
    extends SuspendedParticle.UnderwaterProvider {
        public PlasmaDustFactory(SpriteSet spriteProvider) {
            super(spriteProvider);
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Particle particle = super.createParticle(simpleParticleType, clientLevel, x, y, z, xSpeed, ySpeed, zSpeed);
            if (particle != null) {
                float l = clientLevel.random.nextFloat();
                float red = Mth.lerp((float)l, (float)111.0f, (float)204.0f) / 255.0f;
                float green = Mth.lerp((float)l, (float)186.0f, (float)240.0f) / 255.0f;
                float blue = Mth.lerp((float)l, (float)26.0f, (float)60.0f) / 255.0f;
                particle.setColor(red, green, blue);
                particle.setParticleSpeed(xSpeed, ySpeed, zSpeed);
            }
            return particle;
        }
    }

    public static class LargeGlimmerSmokeFactory
    extends LargeSmokeParticle.Provider {
        public LargeGlimmerSmokeFactory(SpriteSet spriteProvider) {
            super(spriteProvider);
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Particle particle = super.createParticle(simpleParticleType, clientLevel, x, y, z, xSpeed, ySpeed, zSpeed);
            if (particle != null) {
                float ang = clientLevel.random.nextFloat();
                float baseBrightness = 0.6f + 0.2f * clientLevel.random.nextFloat();
                float rgbBrightness = 1.0f - baseBrightness;
                float red = Mth.sin((float)(ang * ((float)Math.PI * 2))) * rgbBrightness + baseBrightness;
                float green = Mth.sin((float)((ang + 0.33333334f) * ((float)Math.PI * 2))) * rgbBrightness + baseBrightness;
                float blue = Mth.sin((float)((ang + 0.6666667f) * ((float)Math.PI * 2))) * rgbBrightness + baseBrightness;
                particle.setColor(red, green, blue);
                particle.setParticleSpeed(xSpeed, ySpeed, zSpeed);
            }
            return particle;
        }
    }

    public static class GlimmerSmokeFactory
    extends SmokeParticle.Provider {
        public GlimmerSmokeFactory(SpriteSet spriteProvider) {
            super(spriteProvider);
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Particle particle = super.createParticle(simpleParticleType, clientLevel, x, y, z, xSpeed, ySpeed, zSpeed);
            if (particle != null) {
                float ang = clientLevel.random.nextFloat();
                float baseBrightness = 0.6f + 0.2f * clientLevel.random.nextFloat();
                float rgbBrightness = 1.0f - baseBrightness;
                float red = Mth.sin((float)(ang * ((float)Math.PI * 2))) * rgbBrightness + baseBrightness;
                float green = Mth.sin((float)((ang + 0.33333334f) * ((float)Math.PI * 2))) * rgbBrightness + baseBrightness;
                float blue = Mth.sin((float)((ang + 0.6666667f) * ((float)Math.PI * 2))) * rgbBrightness + baseBrightness;
                particle.setColor(red, green, blue);
                particle.setParticleSpeed(xSpeed, ySpeed, zSpeed);
            }
            return particle;
        }
    }

    public static class FirmamentGlimmerFactory
    extends SuspendedParticle.UnderwaterProvider {
        public FirmamentGlimmerFactory(SpriteSet spriteProvider) {
            super(spriteProvider);
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Particle particle = super.createParticle(simpleParticleType, clientLevel, x, y, z, xSpeed, ySpeed, zSpeed);
            if (particle != null) {
                float ang = clientLevel.random.nextFloat();
                float red = Mth.sin((float)(ang * ((float)Math.PI * 2))) * 0.2f + 0.8f;
                float green = Mth.sin((float)((ang + 0.33333334f) * ((float)Math.PI * 2))) * 0.2f + 0.8f;
                float blue = Mth.sin((float)((ang + 0.6666667f) * ((float)Math.PI * 2))) * 0.2f + 0.8f;
                particle.setColor(red, green, blue);
                particle.setParticleSpeed(xSpeed, ySpeed, zSpeed);
            }
            return particle;
        }
    }
}

