/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import phanastrae.operation_starcleave.OperationStarcleave;
import phanastrae.operation_starcleave.client.render.OperationStarcleaveRenderLayers;
import phanastrae.operation_starcleave.client.render.entity.layers.SubcaelicDuxLayer;
import phanastrae.operation_starcleave.client.render.entity.model.OperationStarcleaveEntityModelLayers;
import phanastrae.operation_starcleave.client.render.entity.model.SubcaelicDuxEntityModel;
import phanastrae.operation_starcleave.entity.mob.SubcaelicDuxEntity;

public class SubcaelicDuxEntityRenderer
extends MobRenderer<SubcaelicDuxEntity, SubcaelicDuxEntityModel<SubcaelicDuxEntity>> {
    private static final ResourceLocation TEXTURE = OperationStarcleave.id("textures/entity/subcaelic_dux/subcaelic_dux.png");
    private static final ResourceLocation GLOW_1_TEXTURE = OperationStarcleave.id("textures/entity/subcaelic_dux/subcaelic_dux_glow_1.png");
    private static final ResourceLocation GLOW_2_TEXTURE = OperationStarcleave.id("textures/entity/subcaelic_dux/subcaelic_dux_glow_2.png");
    private static final ResourceLocation GLOW_3_TEXTURE = OperationStarcleave.id("textures/entity/subcaelic_dux/subcaelic_dux_glow_3.png");
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private final RandomSource random = RandomSource.create();

    public SubcaelicDuxEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new SubcaelicDuxEntityModel(context.bakeLayer(OperationStarcleaveEntityModelLayers.SUBCAELIC_DUX)), 3.0f);
        this.addLayer(new SubcaelicDuxLayer<SubcaelicDuxEntity, SubcaelicDuxEntityModel>((RenderLayerParent<SubcaelicDuxEntity, SubcaelicDuxEntityModel>)this, GLOW_1_TEXTURE, (dux, tickDelta, animationProgress) -> Mth.sin((float)(0.1f * (float)Math.toRadians(Mth.rotLerp((float)tickDelta, (float)dux.prevTentacleRollAngle, (float)dux.tentacleRollAngle)) * 2.0f * (float)Math.PI)) * 0.5f + 0.5f, SubcaelicDuxEntityModel::getGlowingParts));
        this.addLayer(new SubcaelicDuxLayer<SubcaelicDuxEntity, SubcaelicDuxEntityModel>((RenderLayerParent<SubcaelicDuxEntity, SubcaelicDuxEntityModel>)this, GLOW_2_TEXTURE, (dux, tickDelta, animationProgress) -> Mth.sin((float)((0.1f * (float)Math.toRadians(Mth.rotLerp((float)tickDelta, (float)dux.prevTentacleRollAngle, (float)dux.tentacleRollAngle)) + 0.33333334f) * 2.0f * (float)Math.PI)) * 0.5f + 0.5f, SubcaelicDuxEntityModel::getGlowingParts));
        this.addLayer(new SubcaelicDuxLayer<SubcaelicDuxEntity, SubcaelicDuxEntityModel>((RenderLayerParent<SubcaelicDuxEntity, SubcaelicDuxEntityModel>)this, GLOW_3_TEXTURE, (dux, tickDelta, animationProgress) -> Mth.sin((float)((0.1f * (float)Math.toRadians(Mth.rotLerp((float)tickDelta, (float)dux.prevTentacleRollAngle, (float)dux.tentacleRollAngle)) - 0.33333334f) * 2.0f * (float)Math.PI)) * 0.5f + 0.5f, SubcaelicDuxEntityModel::getGlowingParts));
    }

    public void render(SubcaelicDuxEntity entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        super.render((LivingEntity)entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
        if (entity.isDeadOrDying()) {
            matrixStack.pushPose();
            matrixStack.scale(7.0f, 7.0f, 7.0f);
            matrixStack.translate(0.0, 0.5, 0.0);
            float l = entity.getExplosionGlowProgress();
            float l2 = l * l * l * l;
            RandomSource random = RandomSource.create((long)432L);
            VertexConsumer vertexConsumer4 = vertexConsumerProvider.getBuffer(OperationStarcleaveRenderLayers.getSkyRay());
            float rayCount = (l + l2) / 2.0f * 90.0f;
            int n = 0;
            while ((float)n < rayCount) {
                matrixStack.pushPose();
                matrixStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f + l * 90.0f));
                float radius = 0.8f + 0.7f * random.nextFloat() + 6.0f * l2;
                float width = 0.3f + 0.2f * random.nextFloat() + 0.3f * l2;
                Matrix4f matrix4f = matrixStack.last().pose();
                int alpha = (int)(255.0f * (1.0f - l2));
                float twopi = (float)Math.PI * 2;
                float red = Mth.sin((float)n) * 0.2f + 0.8f;
                float green = Mth.sin((float)((float)n + 0.33333334f * twopi)) * 0.2f + 0.8f;
                float blue = Mth.sin((float)((float)n + 0.6666667f * twopi)) * 0.2f + 0.8f;
                int r = (int)(red * (float)alpha) & 0xFF;
                int g = (int)(green * (float)alpha) & 0xFF;
                int b = (int)(blue * (float)alpha) & 0xFF;
                SubcaelicDuxEntityRenderer.putDeathLightSourceVertex(vertexConsumer4, matrix4f, r, g, b);
                SubcaelicDuxEntityRenderer.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicDuxEntityRenderer.putDeathLightPositiveXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicDuxEntityRenderer.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicDuxEntityRenderer.putDeathLightSourceVertex(vertexConsumer4, matrix4f, r, g, b);
                SubcaelicDuxEntityRenderer.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicDuxEntityRenderer.putDeathLightPositiveZTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicDuxEntityRenderer.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicDuxEntityRenderer.putDeathLightSourceVertex(vertexConsumer4, matrix4f, r, g, b);
                SubcaelicDuxEntityRenderer.putDeathLightPositiveXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicDuxEntityRenderer.putDeathLightPositiveZTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                SubcaelicDuxEntityRenderer.putDeathLightPositiveXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
                matrixStack.popPose();
                ++n;
            }
            matrixStack.popPose();
        }
    }

    private static void putDeathLightSourceVertex(VertexConsumer buffer, Matrix4f matrix, int r, int g, int b) {
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(r, g, b, 255);
    }

    private static void putDeathLightNegativeXTerminalVertex(VertexConsumer buffer, Matrix4f matrix, float radius, float width) {
        buffer.addVertex(matrix, -HALF_SQRT_3 * width, radius, -0.5f * width).setColor(0, 0, 0, 0);
    }

    private static void putDeathLightPositiveXTerminalVertex(VertexConsumer buffer, Matrix4f matrix, float radius, float width) {
        buffer.addVertex(matrix, HALF_SQRT_3 * width, radius, -0.5f * width).setColor(0, 0, 0, 0);
    }

    private static void putDeathLightPositiveZTerminalVertex(VertexConsumer buffer, Matrix4f matrix, float radius, float width) {
        buffer.addVertex(matrix, 0.0f, radius, 1.0f * width).setColor(0, 0, 0, 0);
    }

    protected void setupRotations(SubcaelicDuxEntity duxEntity, PoseStack matrixStack, float animationProgress, float bodyYaw, float tickDelta, float scale) {
        float i = Mth.rotLerp((float)tickDelta, (float)duxEntity.prevTiltAngle, (float)duxEntity.tiltAngle);
        float j = Mth.rotLerp((float)tickDelta, (float)duxEntity.prevRollAngle, (float)duxEntity.rollAngle);
        matrixStack.translate(0.0f, 2.5f, 0.0f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - bodyYaw));
        matrixStack.mulPose(Axis.XP.rotationDegrees(i));
        matrixStack.mulPose(Axis.YP.rotationDegrees(j));
        matrixStack.translate(0.0f, -4.0f, 0.0f);
    }

    protected void scale(SubcaelicDuxEntity entity, PoseStack matrices, float amount) {
        matrices.scale(5.0f, 5.0f, 5.0f);
    }

    protected float getAttackAnim(SubcaelicDuxEntity entity, float f) {
        if (entity.isDeadOrDying()) {
            float d = (float)entity.ticksSinceDeath / 200.0f;
            return (float)Mth.clamp((double)((double)d * 1.5), (double)0.0, (double)1.0);
        }
        return 0.0f;
    }

    public Vec3 getRenderOffset(SubcaelicDuxEntity entity, float tickDelta) {
        if (entity.isDeadOrDying()) {
            double d = (float)entity.ticksSinceDeath / 200.0f;
            d = d * d * 0.9;
            return new Vec3(this.random.nextGaussian() * d, this.random.nextGaussian() * d, this.random.nextGaussian() * d);
        }
        return super.getRenderOffset((Entity)entity, tickDelta);
    }

    protected float getBob(SubcaelicDuxEntity entity, float tickDelta) {
        float a = Mth.rotLerp((float)tickDelta, (float)entity.prevTentacleRollAngle, (float)entity.tentacleRollAngle);
        return 0.5f + 0.5f * (float)Math.sin(0.02f * a);
    }

    public ResourceLocation getTextureLocation(SubcaelicDuxEntity duxEntity) {
        return TEXTURE;
    }
}

