/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import phanastrae.operation_starcleave.client.render.entity.model.SubcaelicDuxEntityModel;
import phanastrae.operation_starcleave.entity.mob.SubcaelicDuxEntity;

public class SubcaelicDuxLayer<T extends SubcaelicDuxEntity, M extends SubcaelicDuxEntityModel<T>>
extends RenderLayer<T, M> {
    private final ResourceLocation texture;
    private final AnimationAngleAdjuster<T> animationAngleAdjuster;
    private final ModelPartVisibility<T, M> modelPartVisibility;

    public SubcaelicDuxLayer(RenderLayerParent<T, M> context, ResourceLocation texture, AnimationAngleAdjuster<T> animationAngleAdjuster, ModelPartVisibility<T, M> modelPartVisibility) {
        super(context);
        this.texture = texture;
        this.animationAngleAdjuster = animationAngleAdjuster;
        this.modelPartVisibility = modelPartVisibility;
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, T dux, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (((SubcaelicDuxEntity)((Object)dux)).isHollow()) {
            return;
        }
        if (!dux.isInvisible()) {
            this.updateModelPartVisibility();
            VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)this.texture));
            float twopi = (float)Math.PI * 2;
            float f = 0.1f * (float)Math.toRadians(Mth.rotLerp((float)tickDelta, (float)((SubcaelicDuxEntity)((Object)dux)).prevTentacleRollAngle, (float)((SubcaelicDuxEntity)((Object)dux)).tentacleRollAngle));
            float red = Mth.sin((float)(f * twopi)) * 0.3f + 0.6f;
            float green = Mth.sin((float)((f + 0.33333334f) * twopi)) * 0.3f + 0.6f;
            float blue = Mth.sin((float)((f + 0.6666667f) * twopi)) * 0.3f + 0.6f;
            float alpha = this.animationAngleAdjuster.apply(dux, tickDelta, animationProgress);
            int color = FastColor.ARGB32.colorFromFloat((float)(red * alpha), (float)(green * alpha), (float)(blue * alpha), (float)(alpha * alpha * alpha * 0.85f));
            ((SubcaelicDuxEntityModel)this.getParentModel()).renderToBuffer(matrixStack, vertexConsumer, 0xF000F0, LivingEntityRenderer.getOverlayCoords(dux, (float)0.0f), color);
            this.unhideAllModelParts();
        }
    }

    private void updateModelPartVisibility() {
        List<ModelPart> list = this.modelPartVisibility.getPartsToDraw((SubcaelicDuxEntityModel)this.getParentModel());
        ((SubcaelicDuxEntityModel)this.getParentModel()).root().getAllParts().forEach(part -> {
            part.skipDraw = true;
        });
        list.forEach(part -> {
            part.skipDraw = false;
        });
    }

    private void unhideAllModelParts() {
        ((SubcaelicDuxEntityModel)this.getParentModel()).root().getAllParts().forEach(part -> {
            part.skipDraw = false;
        });
    }

    public static interface AnimationAngleAdjuster<T extends SubcaelicDuxEntity> {
        public float apply(T var1, float var2, float var3);
    }

    public static interface ModelPartVisibility<T extends SubcaelicDuxEntity, M extends EntityModel<T>> {
        public List<ModelPart> getPartsToDraw(M var1);
    }
}

