/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityAttachment;

public class PegasusWingsModel<T extends AbstractHorse>
extends EntityModel<T> {
    private final ModelPart body;
    private final ModelPart left_wing;
    private final ModelPart left_wing_end;
    private final ModelPart right_wing;
    private final ModelPart right_wing_end;

    public PegasusWingsModel(ModelPart root) {
        this.body = root.getChild("body");
        this.left_wing = this.body.getChild("left_wing");
        this.left_wing_end = this.left_wing.getChild("left_wing_end");
        this.right_wing = this.body.getChild("right_wing");
        this.right_wing_end = this.right_wing.getChild("right_wing_end");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)11.0f, (float)5.0f));
        PartDefinition left_wing = body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -10.0f, 12.0f, 1.0f, 25.0f), PartPose.offsetAndRotation((float)4.0f, (float)-5.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-1.309f));
        PartDefinition left_wing_end = left_wing.addOrReplaceChild("left_wing_end", CubeListBuilder.create().texOffs(0, 26).addBox(0.0f, -0.5f, -10.0f, 18.0f, 1.0f, 25.0f), PartPose.offsetAndRotation((float)12.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)2.3562f));
        PartDefinition right_wing = body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-12.0f, 0.0f, -10.0f, 12.0f, 1.0f, 25.0f).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)-5.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)1.309f));
        PartDefinition right_wing_end = right_wing.addOrReplaceChild("right_wing_end", CubeListBuilder.create().texOffs(0, 26).mirror().addBox(-18.0f, -0.5f, -10.0f, 18.0f, 1.0f, 25.0f).mirror(false), PartPose.offsetAndRotation((float)-12.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.3562f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float standAnim = entity.getStandAnim(partialTick);
        this.body.xRot = standAnim * -0.7853982f;
        OperationStarcleaveEntityAttachment osea = OperationStarcleaveEntityAttachment.fromEntity(entity);
        float wingSpread = Mth.lerp((float)partialTick, (float)osea.getPrevPegasusWingSpread(), (float)osea.getPegasusWingSpread());
        float wingFlap = Mth.lerp((float)partialTick, (float)osea.getPrevPegasusWingFlap(), (float)osea.getPegasusWingFlap());
        wingSpread = Math.max(wingSpread, wingFlap * 0.25f);
        float age = (float)((AbstractHorse)entity).tickCount + partialTick;
        float groundedRot = Mth.lerp((float)wingSpread, (float)0.08f, (float)0.0f) * Mth.sin((float)(0.2f * limbSwing)) + Mth.lerp((float)wingSpread, (float)0.02f, (float)0.0f) * Mth.sin((float)(age / 40.0f));
        float glidingMainRot = Mth.lerp((float)wingSpread, (float)0.0f, (float)0.14f) * Mth.sin((float)(age / 20.0f)) + Mth.lerp((float)wingFlap, (float)0.0f, (float)0.2f) * Mth.sin((float)(age / 2.0f));
        float glidingEndRot = Mth.lerp((float)wingSpread, (float)0.0f, (float)0.14f) * Mth.sin((float)(age / 20.0f + 0.2f)) + Mth.lerp((float)wingFlap, (float)0.0f, (float)0.2f) * Mth.sin((float)(age / 2.0f + 0.15f));
        float mainWingRot = Mth.lerp((float)wingSpread, (float)-0.9f, (float)-0.25f) + groundedRot + glidingMainRot;
        float endWingRot = Mth.lerp((float)wingSpread, (float)2.4f, (float)0.65f) - 2.0f * groundedRot + glidingEndRot;
        this.left_wing.zRot = mainWingRot;
        this.right_wing.zRot = -mainWingRot;
        this.left_wing_end.zRot = endWingRot;
        this.right_wing_end.zRot = -endWingRot;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.y = 11.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

