/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import phanastrae.operation_starcleave.entity.mob.StarcleaverGolemEntity;

public class StarcleaverGolemEntityModel<T extends StarcleaverGolemEntity>
extends EntityModel<T> {
    private final ModelPart body;
    private final ModelPart drill;
    private final ModelPart legs;
    private final ModelPart drillPivot;
    private final ModelPart drillHead;
    private final ModelPart drillTip;
    private final ModelPart door;

    public StarcleaverGolemEntityModel(ModelPart root) {
        this.body = root.getChild("body");
        this.drill = root.getChild("drill");
        this.legs = root.getChild("legs");
        this.drillPivot = this.drill.getChild("drillpivot");
        this.drillHead = this.drillPivot.getChild("drilltop");
        this.drillTip = this.drillHead.getChild("tip");
        this.door = this.body.getChild("door");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition body = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -3.25f, -2.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition microthrusters = body.addOrReplaceChild("microthrusters", CubeListBuilder.create().texOffs(14, 0).addBox(-3.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.25f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rocketpack = body.addOrReplaceChild("rocketpack", CubeListBuilder.create().texOffs(18, 2).addBox(-2.0f, -2.5f, -1.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(14, 9).addBox(-1.5f, -0.75f, -1.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 9).addBox(0.5f, -0.75f, -1.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 9).addBox(-2.5f, -0.25f, -0.25f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(18, 9).addBox(1.5f, -0.25f, -0.25f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition door = body.addOrReplaceChild("door", CubeListBuilder.create().texOffs(0, 9).addBox(-2.0f, -4.0f, -0.75f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.25f, (float)2.0f));
        PartDefinition drill = modelPartData.addOrReplaceChild("drill", CubeListBuilder.create().texOffs(0, 14).addBox(-1.5f, -3.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)16.75f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition drillpivot = drill.addOrReplaceChild("drillpivot", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-2.25f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition drilltop = drillpivot.addOrReplaceChild("drilltop", CubeListBuilder.create().texOffs(0, 24).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tip = drilltop.addOrReplaceChild("tip", CubeListBuilder.create().texOffs(4, 18).addBox(0.0f, -4.0f, -1.0f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 20).addBox(-1.0f, -4.0f, 0.0f, 2.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition head = tip.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 20).addBox(-0.5f, -1.5f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition legs = modelPartData.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)21.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition frontrightleg = legs.addOrReplaceChild("frontrightleg", CubeListBuilder.create().texOffs(12, 14).mirror().addBox(-0.25f, -0.25f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)0.5f, (float)1.0f, (float)0.5236f, (float)-0.9599f, (float)-0.829f));
        PartDefinition backrightleg = legs.addOrReplaceChild("backrightleg", CubeListBuilder.create().texOffs(12, 18).mirror().addBox(-0.25f, -0.25f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)0.5f, (float)-1.0f, (float)-0.5236f, (float)0.9599f, (float)-0.829f));
        PartDefinition frontleftleg = legs.addOrReplaceChild("frontleftleg", CubeListBuilder.create().texOffs(16, 14).addBox(-0.75f, -0.25f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)0.5f, (float)1.0f, (float)0.5236f, (float)0.9599f, (float)0.829f));
        PartDefinition backleftleg = legs.addOrReplaceChild("backleftleg", CubeListBuilder.create().texOffs(16, 18).addBox(-0.75f, -0.25f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)0.5f, (float)-1.0f, (float)-0.5236f, (float)-0.9599f, (float)0.829f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public void setupAnim(StarcleaverGolemEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float s = (float)entity.getDeltaMovement().lengthSqr();
        s /= 0.2f;
        if ((s *= s * s) < 1.0f) {
            s = 1.0f;
        }
        this.legs.xRot = Mth.cos((float)(limbAngle * 0.6662f)) * limbDistance * 0.25f / s;
        this.legs.zRot = Mth.cos((float)(limbAngle * 1.3324f)) * limbDistance * 0.125f / s;
        this.body.xRot = -headPitch * ((float)Math.PI / 180) * 0.2f + Mth.cos((float)(limbAngle * 0.6662f)) * 0.1f / s;
    }

    public void prepareMobModel(StarcleaverGolemEntity entity, float limbAngle, float limbDistance, float tickDelta) {
        this.drillPivot.xRot = Mth.rotLerp((float)tickDelta, (float)entity.prevDrillBasePitch, (float)entity.drillBasePitch) * ((float)Math.PI / 180);
        this.drillHead.yRot = -Mth.rotLerp((float)tickDelta, (float)entity.prevDrillHeadAngle, (float)entity.drillHeadAngle) * ((float)Math.PI / 180);
        this.drillTip.yRot = -Mth.rotLerp((float)tickDelta, (float)entity.prevDrillTipAngle, (float)entity.drillTipAngle) * ((float)Math.PI / 180);
        this.door.xRot = -Mth.sin((float)Mth.lerp((float)tickDelta, (float)entity.prevDoorProgress, (float)entity.doorProgress)) * (float)Math.PI / 2.0f;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.body.render(matrices, vertices, light, overlay, color);
        this.drill.render(matrices, vertices, light, overlay, color);
        this.legs.render(matrices, vertices, light, overlay, color);
    }
}

