/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.render.firmament;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30C;
import phanastrae.operation_starcleave.world.firmament.Firmament;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegion;
import phanastrae.operation_starcleave.world.firmament.FirmamentSubRegion;
import phanastrae.operation_starcleave.world.firmament.RegionPos;
import phanastrae.operation_starcleave.world.firmament.SubRegionPos;

public class FirmamentTextureStorage {
    private static final FirmamentTextureStorage INSTANCE = new FirmamentTextureStorage();
    private final NativeImage image = new NativeImage(NativeImage.Format.RGBA, 512, 512, true);
    private final DynamicTexture finalTexture = new DynamicTexture(new NativeImage(NativeImage.Format.RGBA, 512, 512, true));
    @Nullable
    private RegionPos lastCamPos = null;
    private final RegionPos[][] regions = new RegionPos[4][4];
    private final boolean[][] filled = new boolean[4][4];
    private final boolean[][] active = new boolean[4][4];
    private final boolean[][] wasFilledAndActiveArray = new boolean[4][4];
    private final List<SubRegionPos> rebuildQueue = new ArrayList<SubRegionPos>();
    private final boolean[][] needsRebuild = new boolean[64][64];
    private boolean needsUpdate = false;
    private final boolean[][] entireRegionHadUpdate = new boolean[4][4];
    private final boolean[][] regionHadUpdate = new boolean[4][4];
    private final boolean[][] subregionHadUpdate = new boolean[64][64];

    private FirmamentTextureStorage() {
    }

    public static FirmamentTextureStorage getInstance() {
        return INSTANCE;
    }

    public void close() {
        this.image.close();
        this.finalTexture.close();
    }

    public void clearData() {
        this.clearRegions();
        this.clearRebuildQueue();
        this.lastCamPos = null;
    }

    public void tick() {
        int j;
        int i;
        Firmament firmament;
        RegionPos camPos;
        Minecraft client = Minecraft.getInstance();
        ProfilerFiller profiler = client.getProfiler();
        profiler.push("starcleave_update_firmament_texture");
        profiler.push("update_position");
        Entity camEntity = Minecraft.getInstance().cameraEntity;
        Level level = camEntity == null ? null : camEntity.level();
        RegionPos regionPos = camPos = camEntity == null ? null : RegionPos.fromEntity(camEntity);
        if (camPos == null && this.lastCamPos != null || camPos != null && (this.lastCamPos == null || camPos.id != this.lastCamPos.id)) {
            this.updateCamPos(camPos, level);
        }
        profiler.popPush("process_queued");
        if (level != null && (firmament = Firmament.fromLevel(level)) != null) {
            this.rebuildQueued(firmament, level);
        }
        profiler.popPush("update_final");
        boolean changed = false;
        NativeImage finalImage = this.finalTexture.getPixels();
        if (finalImage != null) {
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 4; ++j) {
                    boolean isFilledAndActive;
                    boolean wasFilledAndActive = this.wasFilledAndActiveArray[i][j];
                    boolean bl = isFilledAndActive = this.filled[i][j] && this.active[i][j];
                    if (isFilledAndActive) {
                        if (!wasFilledAndActive || this.needsUpdate && this.regionHadUpdate[i][j]) {
                            if (!wasFilledAndActive || this.entireRegionHadUpdate[i][j]) {
                                this.image.copyRect(finalImage, i * 128, j * 128, i * 128, j * 128, 128, 128, false, false);
                                changed = true;
                            } else {
                                for (int x = 0; x < 16; ++x) {
                                    for (int z = 0; z < 16; ++z) {
                                        int sx = i * 16 + x;
                                        int sz = j * 16 + z;
                                        if (!this.subregionHadUpdate[sx][sz]) continue;
                                        this.image.copyRect(finalImage, sx * 8, sz * 8, sx * 8, sz * 8, 8, 8, false, false);
                                        changed = true;
                                    }
                                }
                            }
                        }
                    } else if (wasFilledAndActive) {
                        finalImage.fillRect(i * 128, j * 128, 128, 128, 0);
                        changed = true;
                    }
                    this.wasFilledAndActiveArray[i][j] = isFilledAndActive;
                }
            }
        }
        profiler.popPush("upload");
        if (changed) {
            TextureUtil.prepareImage((int)this.finalTexture.getId(), (int)5, (int)512, (int)512);
            this.finalTexture.upload();
            this.finalTexture.bind();
            GL30C.glGenerateMipmap((int)3553);
        }
        if (this.needsUpdate) {
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 4; ++j) {
                    if (!this.regionHadUpdate[i][j]) continue;
                    this.regionHadUpdate[i][j] = false;
                    this.entireRegionHadUpdate[i][j] = false;
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int sx = i * 16 + x;
                            int sz = j * 16 + z;
                            this.subregionHadUpdate[sx][sz] = false;
                        }
                    }
                }
            }
        }
        this.needsUpdate = false;
        profiler.pop();
        profiler.pop();
    }

    public void queueRebuild(BlockPos blockPos) {
        if (!this.shouldRenderPostOnGraphicsMode()) {
            return;
        }
        SubRegionPos subRegionPos = SubRegionPos.fromWorldCoords(blockPos.getX(), blockPos.getZ());
        RegionPos regionPos = RegionPos.fromSubRegion(subRegionPos);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                RegionPos pos;
                if (!this.filled[i][j] || !this.active[i][j] || (pos = this.regions[i][j]) == null || pos.id != regionPos.id) continue;
                this.queueRebuild(subRegionPos);
                return;
            }
        }
    }

    public void queueRebuild(SubRegionPos subRegionPos) {
        int sx = subRegionPos.srx & 0x3F;
        int sz = subRegionPos.srz & 0x3F;
        if (!this.needsRebuild[sx][sz]) {
            this.needsRebuild[sx][sz] = true;
            this.rebuildQueue.add(subRegionPos);
        }
    }

    public void clearRebuildQueue() {
        for (SubRegionPos subRegionPos : this.rebuildQueue) {
            int sx = subRegionPos.srx & 0x3F;
            int sz = subRegionPos.srz & 0x3F;
            if (!this.needsRebuild[sx][sz]) continue;
            this.needsRebuild[sx][sz] = false;
        }
        this.rebuildQueue.clear();
    }

    public void rebuildQueued(Firmament firmament, Level level) {
        for (SubRegionPos subRegionPos : this.rebuildQueue) {
            FirmamentSubRegion subRegion;
            RegionPos regionPos = RegionPos.fromSubRegion(subRegionPos);
            int x = regionPos.rx;
            int gx = x & 3;
            int z = regionPos.rz;
            int gz = z & 3;
            RegionPos rp = this.regions[gx][gz];
            if (rp == null || rp.id != regionPos.id || (subRegion = firmament.getSubRegionFromId(subRegionPos.id)) == null) continue;
            this.updateRegionData(gx, gz, subRegion, level);
        }
        this.clearRebuildQueue();
    }

    public void updateCamPos(@Nullable RegionPos newCamPos, @Nullable Level level) {
        if (newCamPos == null) {
            this.markAllInactive();
        } else {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    int x = newCamPos.rx + i;
                    int gx = x & 3;
                    int z = newCamPos.rz + j;
                    int gz = z & 3;
                    RegionPos rp = this.regions[gx][gz];
                    if (rp != null && rp.rx == x && rp.rz == z) continue;
                    this.setRegionPos(gx, gz, new RegionPos(x, z), level);
                }
            }
        }
        this.lastCamPos = newCamPos;
    }

    public void markAllInactive() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.active[i][j] = false;
            }
        }
    }

    public void clearRegions() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.regions[i][j] == null) continue;
                this.setRegionPos(i, j, null, null);
                this.clearRegion(i, j);
            }
        }
    }

    public void setRegionPos(int gx, int gz, @Nullable RegionPos regionPos, @Nullable Level level) {
        Firmament firmament;
        this.regions[gx][gz] = regionPos;
        FirmamentRegion region = null;
        if (regionPos != null && (firmament = Firmament.fromLevel(level)) != null) {
            region = firmament.getFirmamentRegion(regionPos);
        }
        this.updateRegionData(gx, gz, region, level);
    }

    public void updateRegionData(int gx, int gz, @Nullable FirmamentRegion region, @Nullable Level level) {
        if (region == null || level == null) {
            this.active[gx][gz] = false;
            return;
        }
        boolean damaged = false;
        for (int i = 0; i < 16 && !damaged; ++i) {
            for (int j = 0; j < 16 && !damaged; ++j) {
                FirmamentSubRegion sr = region.subRegions[i][j];
                if (!sr.hadDamageLastCheck()) continue;
                damaged = true;
            }
        }
        if (!damaged) {
            this.active[gx][gz] = false;
            return;
        }
        int ox = gx * 128;
        int oz = gz * 128;
        for (int cx = 0; cx < 32; ++cx) {
            for (int cz = 0; cz < 32; ++cz) {
                int chunkZ;
                int chunkX = SectionPos.blockToSectionCoord((int)(region.x + 16 * cx));
                LevelChunk chunk = level.hasChunk(chunkX, chunkZ = SectionPos.blockToSectionCoord((int)(region.z + 16 * cz))) ? level.getChunk(chunkX, chunkZ) : null;
                for (int tx = 0; tx < 4; ++tx) {
                    for (int tz = 0; tz < 4; ++tz) {
                        int x = cx * 4 + tx;
                        int z = cz * 4 + tz;
                        int damage = region.getDamage(x << 2, z << 2);
                        int height = FirmamentTextureStorage.getHeight(region.x + 4 * x, region.z + 4 * z, level, chunk);
                        this.image.setPixelRGBA(x + ox, z + oz, FirmamentTextureStorage.getColor(damage, height));
                    }
                }
            }
        }
        this.needsUpdate = true;
        this.regionHadUpdate[gx][gz] = true;
        this.entireRegionHadUpdate[gx][gz] = true;
        this.filled[gx][gz] = true;
        this.active[gx][gz] = true;
    }

    public void updateRegionData(int gx, int gz, FirmamentSubRegion subRegion, Level level) {
        if (!subRegion.hadDamageLastCheck() && !this.filled[gx][gz]) {
            return;
        }
        if (!this.active[gx][gz]) {
            this.clearRegion(gx, gz);
            this.active[gx][gz] = true;
        }
        int ox = gx * 128 + ((subRegion.x & 0x1FF) >> 2);
        int oz = gz * 128 + ((subRegion.z & 0x1FF) >> 2);
        for (int cx = 0; cx < 2; ++cx) {
            for (int cz = 0; cz < 2; ++cz) {
                int chunkZ;
                int chunkX = SectionPos.blockToSectionCoord((int)(subRegion.x + 16 * cx));
                LevelChunk chunk = level.hasChunk(chunkX, chunkZ = SectionPos.blockToSectionCoord((int)(subRegion.z + 16 * cz))) ? level.getChunk(chunkX, chunkZ) : null;
                for (int tx = 0; tx < 4; ++tx) {
                    for (int tz = 0; tz < 4; ++tz) {
                        int x = cx * 4 + tx;
                        int z = cz * 4 + tz;
                        int damage = subRegion.getDamage(x << 2, z << 2);
                        int height = FirmamentTextureStorage.getHeight(subRegion.x + 4 * x, subRegion.z + 4 * z, level, chunk);
                        this.image.setPixelRGBA(x + ox, z + oz, FirmamentTextureStorage.getColor(damage, height));
                    }
                }
            }
        }
        this.needsUpdate = true;
        this.regionHadUpdate[gx][gz] = true;
        int sx = gx * 16 + (subRegion.x >> 5 & 0xF);
        int sz = gz * 16 + (subRegion.z >> 5 & 0xF);
        this.subregionHadUpdate[sx][sz] = true;
        this.filled[gx][gz] = true;
    }

    public void clearRegion(int gx, int gz) {
        if (!this.filled[gx][gz]) {
            return;
        }
        int ox = gx * 128;
        int oz = gz * 128;
        this.image.fillRect(ox, oz, 128, 128, 0);
        this.needsUpdate = true;
        this.regionHadUpdate[gx][gz] = true;
        this.entireRegionHadUpdate[gx][gz] = true;
        this.filled[gx][gz] = false;
        this.active[gx][gz] = false;
    }

    public void onRegionAdded(FirmamentRegion region, Level level) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                RegionPos regionPos = this.regions[i][j];
                if (regionPos == null || regionPos.id != region.regionPos.id) continue;
                this.updateRegionData(i, j, region, level);
            }
        }
    }

    public void onSubRegionUpdated(FirmamentSubRegion subRegion, Level level) {
        RegionPos rp = RegionPos.fromWorldCoords(subRegion.x, subRegion.z);
        long id = rp.id;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                RegionPos regionPos = this.regions[i][j];
                if (regionPos == null || regionPos.id != id) continue;
                this.updateRegionData(i, j, subRegion, level);
            }
        }
    }

    public void onRegionRemoved(long id) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                RegionPos regionPos = this.regions[i][j];
                if (regionPos == null || regionPos.id != id) continue;
                this.active[i][j] = false;
            }
        }
    }

    public DynamicTexture getTexture() {
        return this.finalTexture;
    }

    public boolean isActive(int i, int j) {
        return this.active[i][j];
    }

    public boolean isFilled(int i, int j) {
        return this.filled[i][j];
    }

    public boolean isAnyFilledAndActive() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                FirmamentTextureStorage fts = FirmamentTextureStorage.getInstance();
                if (!fts.isActive(i, j) || !fts.isFilled(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldRenderPostOnGraphicsMode() {
        Minecraft minecraft = Minecraft.getInstance();
        GraphicsStatus graphicsMode = (GraphicsStatus)minecraft.options.graphicsMode().get();
        if (graphicsMode == GraphicsStatus.FAST) {
            return false;
        }
        return graphicsMode != GraphicsStatus.FABULOUS;
    }

    public static int getColor(int damage, int height) {
        if ((height /= 3) > 255) {
            height = 255;
        }
        int r = damage & 7;
        int g = height & 0xFF;
        int b = 0;
        int a = 255;
        return a << 24 | b << 16 | g << 8 | r;
    }

    public static int getHeight(int x, int z, Level level, @Nullable LevelChunk chunk) {
        if (chunk == null) {
            return 765;
        }
        int topY = level.getMaxBuildHeight();
        int bottomY = level.getMinBuildHeight();
        int minY = topY;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int y = chunk.getHeight(Heightmap.Types.MOTION_BLOCKING, x + i & 0xF, z + j & 0xF);
                if (y >= minY) continue;
                minY = y;
            }
        }
        if (minY <= bottomY) {
            return 765;
        }
        return topY - minY;
    }
}

