/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.world.firmament;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.joml.Matrix4f;
import phanastrae.operation_starcleave.client.render.OperationStarcleaveRenderLayers;
import phanastrae.operation_starcleave.client.render.firmament.FirmamentActorRenderable;
import phanastrae.operation_starcleave.world.firmament.Firmament;
import phanastrae.operation_starcleave.world.firmament.FirmamentActor;

public class FirmamentDamageGlowActor
extends FirmamentActor
implements FirmamentActorRenderable {
    int age = 0;
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public FirmamentDamageGlowActor(Firmament firmament, int originX, int originZ) {
        super(firmament, originX, originZ);
    }

    @Override
    public void tick() {
        ++this.age;
        if (this.age > 100) {
            this.discard();
            return;
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, float tickDelta, Camera camera) {
        double xOffset = (double)this.originX + 0.5 - camera.getPosition().x;
        double yOffset = (double)this.firmament.getY() - camera.getPosition().y;
        double zOffset = (double)this.originZ + 0.5 - camera.getPosition().z;
        double distance = Math.sqrt(xOffset * xOffset + zOffset * zOffset);
        if (distance > 512.0) {
            return;
        }
        float distanceMultiplier = (float)Math.min(1.0, Math.max(0.0, (512.0 - distance) / 256.0));
        distanceMultiplier *= distanceMultiplier;
        matrixStack.pushPose();
        matrixStack.translate(xOffset, yOffset, zOffset);
        matrixStack.scale(8.0f, 8.0f, 8.0f);
        float l = ((float)this.age + tickDelta) / 100.0f;
        matrixStack.scale(1.0f + 8.0f * l * l, 1.0f, 1.0f + 8.0f * l * l);
        matrixStack.translate(0.0f, l + l * l, 0.0f);
        float m = l * l;
        RandomSource random = RandomSource.create((long)432L);
        VertexConsumer vertexConsumer4 = vertexConsumerProvider.getBuffer(OperationStarcleaveRenderLayers.getSkyRay());
        float rayCount = (l + l * l) / 2.0f * 60.0f;
        rayCount *= 5.0f;
        if (rayCount > 80.0f) {
            rayCount = 80.0f;
        }
        rayCount *= distanceMultiplier;
        int n = 0;
        while ((float)n < rayCount) {
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f + l * l * l * l * l * 8.0f * (random.nextFloat() + 2.0f)));
            matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f + (90.0f - 60.0f * random.nextFloat()) * (l * l * l)));
            float radius = random.nextFloat() * 20.0f + 5.0f + m * 10.0f;
            float width = random.nextFloat() * 2.0f + 1.0f + m * 2.0f;
            Matrix4f matrix4f = matrixStack.last().pose();
            int alpha = (int)(255.0f * (1.0f - m));
            alpha = (int)((double)((float)alpha * (1.0f - l * l) * distanceMultiplier) * 0.1);
            float twopi = (float)Math.PI * 2;
            float red = Mth.sin((float)n) * 0.2f + 0.8f;
            float green = Mth.sin((float)((float)n + 0.33333334f * twopi)) * 0.2f + 0.8f;
            float blue = Mth.sin((float)((float)n + 0.6666667f * twopi)) * 0.2f + 0.8f;
            int r = (int)(red * (float)alpha) & 0xFF;
            int g = (int)(green * (float)alpha) & 0xFF;
            int b = (int)(blue * (float)alpha) & 0xFF;
            FirmamentDamageGlowActor.putDeathLightSourceVertex(vertexConsumer4, matrix4f, r, g, b);
            FirmamentDamageGlowActor.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
            FirmamentDamageGlowActor.putDeathLightPositiveXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
            FirmamentDamageGlowActor.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
            FirmamentDamageGlowActor.putDeathLightSourceVertex(vertexConsumer4, matrix4f, r, g, b);
            FirmamentDamageGlowActor.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
            FirmamentDamageGlowActor.putDeathLightPositiveZTerminalVertex(vertexConsumer4, matrix4f, radius, width);
            FirmamentDamageGlowActor.putDeathLightNegativeXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
            FirmamentDamageGlowActor.putDeathLightSourceVertex(vertexConsumer4, matrix4f, r, g, b);
            FirmamentDamageGlowActor.putDeathLightPositiveXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
            FirmamentDamageGlowActor.putDeathLightPositiveZTerminalVertex(vertexConsumer4, matrix4f, radius, width);
            FirmamentDamageGlowActor.putDeathLightPositiveXTerminalVertex(vertexConsumer4, matrix4f, radius, width);
            matrixStack.popPose();
            ++n;
        }
        matrixStack.popPose();
    }

    private static void putDeathLightSourceVertex(VertexConsumer buffer, Matrix4f matrix, int r, int g, int b) {
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(r, g, b, 255);
    }

    private static void putDeathLightNegativeXTerminalVertex(VertexConsumer buffer, Matrix4f matrix, float radius, float width) {
        buffer.addVertex(matrix, -HALF_SQRT_3 * width, radius, -0.5f * width).setColor(0, 0, 0, 0);
    }

    private static void putDeathLightPositiveXTerminalVertex(VertexConsumer buffer, Matrix4f matrix, float radius, float width) {
        buffer.addVertex(matrix, HALF_SQRT_3 * width, radius, -0.5f * width).setColor(0, 0, 0, 0);
    }

    private static void putDeathLightPositiveZTerminalVertex(VertexConsumer buffer, Matrix4f matrix, float radius, float width) {
        buffer.addVertex(matrix, 0.0f, radius, 1.0f * width).setColor(0, 0, 0, 0);
    }
}

