/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.client.world.starbleach;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.world.firmament.Firmament;

public class StarbleachParticles {
    public static void spawnParticles(ClientLevel level, int centerX, int centerY, int centerZ) {
        RandomSource random = level.random;
        Firmament firmament = Firmament.fromLevel((Level)level);
        if (firmament == null) {
            return;
        }
        SimpleParticleType particleEffect = OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER;
        int radius = 32;
        int firmamentY = firmament.getY();
        int minBuildHeight = level.getMinBuildHeight();
        for (int n = 0; n < 14; ++n) {
            int k;
            int damage;
            int z;
            int x = centerX + random.nextInt(radius) - random.nextInt(radius);
            int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z = centerZ + random.nextInt(radius) - random.nextInt(radius));
            if (surfaceY > centerY + 16 || (damage = firmament.getDamage(x, z)) < 5) continue;
            int damageAboveThreshold = damage - 5;
            float x2 = (float)x + random.nextFloat();
            float z2 = (float)z + random.nextFloat();
            if (surfaceY > minBuildHeight && Math.abs(surfaceY - centerY) <= 16) {
                for (int k2 = 0; k2 < 1 + damageAboveThreshold * 2; ++k2) {
                    level.addParticle((ParticleOptions)particleEffect, (double)x2, (double)surfaceY, (double)z2, (double)random.nextFloat() * 0.07 - 0.035, 0.03 + (double)random.nextFloat() * 0.04, (double)random.nextFloat() * 0.07 - 0.035);
                }
            }
            int aboveSurfaceY = surfaceY + 16;
            float f = random.nextFloat();
            float y2 = Mth.lerp((float)(f * f), (float)aboveSurfaceY, (float)firmamentY);
            if (Math.abs(y2 - (float)centerY) <= 32.0f) {
                for (k = 0; k < 1 + damageAboveThreshold * 2; ++k) {
                    level.addParticle((ParticleOptions)particleEffect, (double)x2, (double)y2, (double)z2, (double)random.nextFloat() * 0.1 - 0.05, -0.07 + (double)random.nextFloat() * -0.1, (double)random.nextFloat() * 0.1 - 0.05);
                }
            }
            if (Math.abs(firmamentY - centerY) > 32) continue;
            for (k = 0; k < 3 + damageAboveThreshold * 2; ++k) {
                level.addParticle((ParticleOptions)particleEffect, (double)x2, (double)firmamentY, (double)z2, (double)random.nextFloat() * 0.1 - 0.05, -0.07 + (double)random.nextFloat() * -0.12, (double)random.nextFloat() * 0.1 - 0.05);
            }
        }
    }
}

