/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.entity.mob;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.advancement.criterion.OperationStarcleaveAdvancementCriteria;
import phanastrae.operation_starcleave.entity.ai.goal.FollowFavoriteGoal;
import phanastrae.operation_starcleave.entity.projectile.SplashStarbleachEntity;
import phanastrae.operation_starcleave.item.FirmamentManipulatorItem;
import phanastrae.operation_starcleave.item.OperationStarcleaveItems;
import phanastrae.operation_starcleave.sound.OperationStarcleaveSoundEvents;
import phanastrae.operation_starcleave.world.OperationStarcleaveGameRules;
import phanastrae.operation_starcleave.world.firmament.Firmament;

public class StarcleaverGolemEntity
extends AbstractGolem
implements Bucketable {
    private static final EntityDataAccessor<Boolean> IGNITED = SynchedEntityData.defineId(StarcleaverGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PLUMMETING = SynchedEntityData.defineId(StarcleaverGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> GUNPOWDER_TICKS = SynchedEntityData.defineId(StarcleaverGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> FAVORITE_UUID = SynchedEntityData.defineId(StarcleaverGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> BUCKETABLE = SynchedEntityData.defineId(StarcleaverGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float drillBasePitch = -45.0f;
    public float prevDrillBasePitch = -45.0f;
    public float drillHeadAngle = 0.0f;
    public float prevDrillHeadAngle = 0.0f;
    public float drillTipAngle = 0.0f;
    public float prevDrillTipAngle = 0.0f;
    public boolean openingDoor;
    public float doorProgress;
    public float prevDoorProgress;
    private final List<UUID> launcherUuids = new ArrayList<UUID>();

    public StarcleaverGolemEntity(EntityType<? extends AbstractGolem> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_NUGGET}), false));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), false));
        this.goalSelector.addGoal(4, (Goal)new FollowFavoriteGoal(this, 1.2, 8.0f, 4.0f, 64.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.ARMOR, 8.0).add(Attributes.MOVEMENT_SPEED, 0.32).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.ARMOR_TOUGHNESS, 3.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IGNITED, (Object)false);
        builder.define(PLUMMETING, (Object)false);
        builder.define(GUNPOWDER_TICKS, (Object)0);
        builder.define(FAVORITE_UUID, Optional.empty());
        builder.define(BUCKETABLE, (Object)true);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("Ignited", this.isIgnited());
        nbt.putBoolean("Plummeting", this.isPlummeting());
        nbt.putInt("GunpowderTicks", this.getGunpowderTicks());
        if (this.getFavoriteUuid() != null) {
            nbt.putUUID("Favorite", this.getFavoriteUuid());
        }
        nbt.putBoolean("Bucketable", this.isBucketable());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readLegacy(nbt);
        if (nbt.contains("Ignited", 1)) {
            this.setIgnited(nbt.getBoolean("Ignited"));
        }
        if (nbt.contains("Plummeting", 1)) {
            this.setPlummeting(nbt.getBoolean("Plummeting"));
        }
        if (nbt.contains("GunpowderTicks", 3)) {
            this.setGunpowderTicks(nbt.getInt("GunpowderTicks"));
        }
        if (nbt.hasUUID("Favorite")) {
            UUID uUID = nbt.getUUID("Favorite");
            try {
                this.setFavoriteUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (nbt.contains("Bucketable", 1)) {
            this.setBucketable(nbt.getBoolean("Bucketable"));
        }
    }

    public void readLegacy(CompoundTag nbt) {
        if (nbt.getBoolean("ignited")) {
            this.setIgnited(true);
        }
        if (nbt.getBoolean("plummeting")) {
            this.setPlummeting(true);
        }
        if (nbt.contains("gunpowderTicks", 3)) {
            this.setGunpowderTicks(nbt.getInt("gunpowderTicks"));
        }
    }

    public void tick() {
        Level world = this.level();
        if (this.isAlive()) {
            if (this.isIgnited()) {
                this.push(0.0, 0.085 + Mth.clamp((double)(this.getDeltaMovement().y - 0.1), (double)0.0, (double)4.0) * 0.03, 0.0);
                if (this.getGunpowderTicks() > 0) {
                    this.setGunpowderTicks(this.getGunpowderTicks() - 1);
                }
                if (this.getGunpowderTicks() <= 0) {
                    this.setIgnited(false);
                }
                if (world.isClientSide) {
                    world.addParticle((ParticleOptions)ParticleTypes.FIREWORK, this.getX() + (double)Mth.sin((float)((float)Math.toRadians(this.yBodyRot))) * 0.25, this.getY(), this.getZ() - (double)Mth.cos((float)((float)Math.toRadians(this.yBodyRot))) * 0.25, this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
                }
                if (!world.isClientSide) {
                    boolean collided = false;
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            float hw = this.getBbWidth() * 0.501f;
                            Vec3 drillTarget = this.position().add((double)(hw * (float)i), (double)this.getBbHeight() + 0.125, (double)(hw * (float)j));
                            BlockPos blockPos = new BlockPos(Mth.floor((double)drillTarget.x), Mth.floor((double)drillTarget.y), Mth.floor((double)drillTarget.z));
                            BlockState state = world.getBlockState(blockPos);
                            if (state.getCollisionShape((BlockGetter)world, blockPos).isEmpty()) continue;
                            if (this.canDestroy(state, blockPos)) {
                                world.destroyBlock(blockPos, true, (Entity)this);
                                int g = this.getGunpowderTicks() - 10;
                                if (g < 0) {
                                    g = 0;
                                }
                                this.setGunpowderTicks(g);
                                continue;
                            }
                            collided = true;
                        }
                    }
                    if (collided) {
                        this.setIgnited(false);
                        this.clearLaunchers();
                    }
                }
                if (!world.isClientSide && this.position().y > (double)(world.getMaxBuildHeight() + 16)) {
                    this.cleave();
                }
            }
            if (this.isPlummeting()) {
                int i;
                if (!world.isClientSide && this.onGround()) {
                    this.setPlummeting(false);
                    world.explode((Entity)this, this.getX(), this.getY(), this.getZ(), 3.0f, Level.ExplosionInteraction.MOB);
                    if (this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                        for (i = 0; i < 6; ++i) {
                            BlockPos pos = this.blockPosition().offset(this.random.nextInt(7) - 3, this.random.nextInt(7) - 3, this.random.nextInt(7) - 3);
                            SplashStarbleachEntity.starbleach(pos, this.level());
                        }
                    }
                }
                if (world.isClientSide) {
                    for (i = 0; i < 8; ++i) {
                        world.addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY() - 0.25, this.getZ(), this.random.nextGaussian() * 0.75, this.getDeltaMovement().y * -0.95, this.random.nextGaussian() * 0.75);
                    }
                }
            }
            if (world.isClientSide) {
                this.updateAnimations();
            }
        }
        super.tick();
    }

    public void updateAnimations() {
        this.prevDrillBasePitch = this.drillBasePitch;
        this.prevDrillTipAngle = this.drillTipAngle;
        this.prevDrillHeadAngle = this.drillHeadAngle;
        if (this.isIgnited() || this.isPlummeting()) {
            this.drillBasePitch += 5.0f;
            if (this.drillBasePitch > 0.0f) {
                this.drillBasePitch = 0.0f;
            }
        } else {
            this.drillBasePitch -= 5.0f;
            if (this.drillBasePitch < -45.0f) {
                this.drillBasePitch = -45.0f;
            }
        }
        if (this.isIgnited()) {
            this.drillHeadAngle += 15.0f;
            if (this.drillHeadAngle > 360.0f) {
                this.drillHeadAngle %= 360.0f;
            }
            this.drillTipAngle += 10.0f;
            if (this.drillTipAngle > 360.0f) {
                this.drillTipAngle %= 360.0f;
            }
        } else {
            if (this.drillHeadAngle > 0.0f) {
                this.drillHeadAngle += 6.0f;
                if (this.drillHeadAngle > 360.0f) {
                    this.drillHeadAngle = 0.0f;
                }
            }
            if (this.drillTipAngle > 0.0f) {
                this.drillTipAngle += 4.0f;
                if (this.drillTipAngle > 360.0f) {
                    this.drillTipAngle = 0.0f;
                }
            }
        }
        this.prevDoorProgress = this.doorProgress;
        if (this.openingDoor) {
            this.doorProgress += 0.25f;
            if (this.doorProgress >= 1.0f) {
                this.doorProgress = 1.0f;
                this.openingDoor = false;
            }
        } else {
            this.doorProgress -= 0.25f;
            if (this.doorProgress <= 0.0f) {
                this.doorProgress = 0.0f;
            }
        }
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        if (damageSource.is(DamageTypeTags.IS_EXPLOSION)) {
            return true;
        }
        return super.isInvulnerableTo(damageSource);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.isAlive()) {
            return InteractionResult.FAIL;
        }
        Level world = this.level();
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.BUCKET) && this.isAlive() && !this.isIgnited() && !this.isPlummeting() && this.isBucketable()) {
            this.playSound(this.getPickupSound(), 1.0f, 1.0f);
            ItemStack itemStack2 = this.getBucketItemStack();
            this.saveToBucketTag(itemStack2);
            ItemStack itemStack3 = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)itemStack2, (boolean)false);
            player.setItemInHand(hand, itemStack3);
            if (!world.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemStack2);
            }
            this.discard();
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        if (itemStack.is(Items.GOLD_NUGGET)) {
            boolean consumeItem = false;
            if (!this.isFavorite((LivingEntity)player)) {
                this.setFavorite(player);
                consumeItem = true;
            }
            float oldHealth = this.getHealth();
            this.heal(10.0f);
            if (this.getHealth() != oldHealth) {
                consumeItem = true;
            }
            if (!consumeItem) {
                return InteractionResult.PASS;
            }
            float g = 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.playSound(this.getAmbientSound(), 1.0f, g);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
            this.sendOpenDoor();
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (itemStack.is(Items.GUNPOWDER) && this.getGunpowderTicks() + 60 <= 600) {
            SoundEvent soundEvent = SoundEvents.SAND_PLACE;
            world.playSound(player, this.getX(), this.getY(), this.getZ(), soundEvent, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!world.isClientSide) {
                this.setGunpowderTicks(this.getGunpowderTicks() + 60);
            }
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            this.sendOpenDoor();
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (player.getAbilities().mayBuild && this.getGunpowderTicks() > 20 && !this.isIgnited() && !this.isPlummeting() && itemStack.is(ItemTags.CREEPER_IGNITERS)) {
            SoundEvent soundEvent = itemStack.is(Items.FIRE_CHARGE) ? SoundEvents.FIRECHARGE_USE : SoundEvents.FLINTANDSTEEL_USE;
            world.playSound(player, this.getX(), this.getY(), this.getZ(), soundEvent, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!world.isClientSide) {
                this.setIgnited(true);
                if (!itemStack.isDamageableItem()) {
                    itemStack.shrink(1);
                } else {
                    itemStack.hurtAndBreak(1, (LivingEntity)player, StarcleaverGolemEntity.getSlotForHand((InteractionHand)hand));
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                    OperationStarcleaveAdvancementCriteria.LAUNCH_STARCLEAVER_GOLEM.trigger(serverPlayerEntity);
                    this.addLauncher(serverPlayerEntity);
                }
                for (ServerPlayer serverPlayerEntity : world.getEntitiesOfClass(ServerPlayer.class, this.getBoundingBox().inflate(5.0))) {
                    if (serverPlayerEntity == player) continue;
                    OperationStarcleaveAdvancementCriteria.LAUNCH_STARCLEAVER_GOLEM.trigger(serverPlayerEntity);
                    this.addLauncher(serverPlayerEntity);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public boolean isOnFire() {
        return this.isPlummeting();
    }

    public boolean isIgnited() {
        return (Boolean)this.entityData.get(IGNITED);
    }

    public void setIgnited(boolean val) {
        this.entityData.set(IGNITED, (Object)val);
    }

    public boolean isPlummeting() {
        return (Boolean)this.entityData.get(PLUMMETING);
    }

    public void setPlummeting(boolean val) {
        this.entityData.set(PLUMMETING, (Object)val);
    }

    public int getGunpowderTicks() {
        return (Integer)this.entityData.get(GUNPOWDER_TICKS);
    }

    public void setGunpowderTicks(int val) {
        this.entityData.set(GUNPOWDER_TICKS, (Object)val);
    }

    @Nullable
    public UUID getFavoriteUuid() {
        return ((Optional)this.entityData.get(FAVORITE_UUID)).orElse(null);
    }

    public void setFavoriteUuid(@Nullable UUID uuid) {
        this.entityData.set(FAVORITE_UUID, Optional.ofNullable(uuid));
    }

    public void setFavorite(@Nullable Player player) {
        this.setFavoriteUuid(player == null ? null : player.getUUID());
    }

    @Nullable
    public LivingEntity getFavorite() {
        UUID uUID = this.getFavoriteUuid();
        return uUID == null ? null : this.level().getPlayerByUUID(uUID);
    }

    public boolean isFavorite(LivingEntity entity) {
        return entity == this.getFavorite();
    }

    public boolean isBucketable() {
        return (Boolean)this.entityData.get(BUCKETABLE);
    }

    public void setBucketable(boolean val) {
        this.entityData.set(BUCKETABLE, (Object)val);
    }

    public void addLauncher(ServerPlayer serverPlayerEntity) {
        this.launcherUuids.add(serverPlayerEntity.getUUID());
    }

    public void forEachLauncher(Consumer<ServerPlayer> method) {
        for (UUID uuid : this.launcherUuids) {
            Player e = this.level().getPlayerByUUID(uuid);
            if (!(e instanceof ServerPlayer)) continue;
            ServerPlayer spe = (ServerPlayer)e;
            method.accept(spe);
        }
    }

    public void clearLaunchers() {
        this.launcherUuids.clear();
    }

    public boolean canDestroy(BlockState blockState, BlockPos blockPos) {
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        return !blockState.is(BlockTags.WITHER_IMMUNE);
    }

    public void cleave() {
        Firmament firmament;
        boolean canFracture = this.level().getGameRules().getBoolean(OperationStarcleaveGameRules.ALLOW_STARCLEAVER_GOLEM_FIRMAMENT_FRACTURING);
        if (canFracture && (firmament = Firmament.fromLevel(this.level())) != null) {
            FirmamentManipulatorItem.fractureFirmament(firmament, this.getBlockX(), this.getBlockZ(), this.getRandom());
        }
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 7.0f, Level.ExplosionInteraction.MOB);
        float angle = this.random.nextFloat() * ((float)Math.PI * 2);
        this.setDeltaMovement(2.0f * Mth.sin((float)angle), -3.0, 2.0f * Mth.cos((float)angle));
        this.setIgnited(false);
        this.setPlummeting(true);
        this.forEachLauncher(arg_0 -> ((PlayerTrigger)OperationStarcleaveAdvancementCriteria.CLEAVE_FIRMAMENT).trigger(arg_0));
        this.clearLaunchers();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(OperationStarcleaveSoundEvents.ENTITY_STARCLEAVER_GOLEM_STEP, 0.45f, 0.8f + this.random.nextFloat() * 0.4f);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return OperationStarcleaveSoundEvents.ENTITY_STARCLEAVER_GOLEM_AMBIENT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return OperationStarcleaveSoundEvents.ENTITY_STARCLEAVER_GOLEM_DEATH;
    }

    public boolean fromBucket() {
        return false;
    }

    public void setFromBucket(boolean fromBucket) {
    }

    public void saveToBucketTag(ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, nbt -> {
            nbt.putInt("GunpowderTicks", this.getGunpowderTicks());
            if (this.getFavoriteUuid() != null) {
                nbt.putUUID("Favorite", this.getFavoriteUuid());
            }
        });
    }

    public void loadFromBucketTag(CompoundTag nbt) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)nbt);
        if (nbt.contains("GunpowderTicks", 3)) {
            this.setGunpowderTicks(nbt.getInt("GunpowderTicks"));
        }
        if (nbt.hasUUID("Favorite")) {
            UUID uUID = nbt.getUUID("Favorite");
            try {
                this.setFavoriteUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ItemStack getBucketItemStack() {
        return OperationStarcleaveItems.STARCLEAVER_GOLEM_BUCKET.getDefaultInstance();
    }

    public SoundEvent getPickupSound() {
        return OperationStarcleaveSoundEvents.ENTITY_STARCLEAVER_GOLEM_AMBIENT;
    }

    public void handleEntityEvent(byte status) {
        if (status == 7) {
            this.showEmoteParticle(true);
        } else if (status == 6) {
            this.showEmoteParticle(false);
        } else if (status == 9) {
            this.openingDoor = true;
        } else {
            super.handleEntityEvent(status);
        }
    }

    public void sendOpenDoor() {
        this.level().broadcastEntityEvent((Entity)this, (byte)9);
    }

    protected void showEmoteParticle(boolean positive) {
        SimpleParticleType particleEffect = ParticleTypes.HEART;
        if (!positive) {
            particleEffect = ParticleTypes.SMOKE;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double e = this.random.nextGaussian() * 0.02;
            double f = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particleEffect, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d, e, f);
        }
    }

    public boolean canStandOnFluid(FluidState state) {
        return !state.isEmpty();
    }

    public void setLastHurtByMob(@Nullable LivingEntity attacker) {
        if (attacker != null && this.level() instanceof ServerLevel && this.isAlive() && attacker instanceof Player && this.isFavorite(attacker)) {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
            this.setFavorite(null);
        }
        super.setLastHurtByMob(attacker);
    }
}

