/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.entity.mob;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.block.PhlogisticFireBlock;
import phanastrae.operation_starcleave.block.StellarFarmlandBlock;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityTypes;
import phanastrae.operation_starcleave.entity.mob.AbstractSubcaelicEntity;
import phanastrae.operation_starcleave.entity.mob.SubcaelicTorpedoEntity;
import phanastrae.operation_starcleave.entity.projectile.PhlogisticSparkEntity;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.world.firmament.Firmament;

public class SubcaelicDuxEntity
extends AbstractSubcaelicEntity
implements NeutralMob {
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)15, (int)25);
    public static final int MAX_ADOPTED_GROUP_SIZE = 14;
    public static final int MAX_NATURAL_GROUP_SIZE = 7;
    private static final EntityDataAccessor<Boolean> HOLLOW = SynchedEntityData.defineId(SubcaelicDuxEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float haloAngle;
    public float prevHaloAngle;
    private final List<SubcaelicTorpedoEntity> torpedos = new ArrayList<SubcaelicTorpedoEntity>();
    public int ticksSinceDeath;
    private int angerTime;
    @Nullable
    private UUID angryAt;

    public SubcaelicDuxEntity(EntityType<? extends SubcaelicDuxEntity> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 20;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.ARMOR, 8.0).add(Attributes.ARMOR_TOUGHNESS, 4.0).add(Attributes.MOVEMENT_SPEED, 0.9).add(Attributes.FOLLOW_RANGE, 192.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOLLOW, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new AscendGoal(this));
        this.goalSelector.addGoal(2, (Goal)new SendTorpedoGoal(this));
        this.goalSelector.addGoal(3, (Goal)new SpawnTorpedoGoal(this));
        this.goalSelector.addGoal(4, (Goal)new AbstractSubcaelicEntity.SwimNearTargetGoal(this));
        this.goalSelector.addGoal(5, (Goal)new AbstractSubcaelicEntity.SwimWanderGoal(this));
        this.targetSelector.addGoal(1, (Goal)new TargetAttackerGoal(this, SubcaelicDuxEntity.class, SubcaelicTorpedoEntity.class));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((SubcaelicDuxEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 30, true, false, entity -> entity.getType().is(EntityTypeTags.UNDEAD)));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.addPersistentAngerSaveData(nbt);
        nbt.putInt("DuxDeathTime", this.ticksSinceDeath);
        nbt.putBoolean("Hollow", this.isHollow());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readPersistentAngerSaveData(this.level(), nbt);
        if (nbt.contains("DuxDeathTime", 3)) {
            this.ticksSinceDeath = nbt.getInt("DuxDeathTime");
        }
        if (nbt.contains("Hollow", 1)) {
            this.setHollow(nbt.getBoolean("Hollow"));
        }
    }

    public void tick() {
        boolean starlit;
        Firmament firmament;
        super.tick();
        if (this.getTarget() != null) {
            if (this.level().getDifficulty().equals((Object)Difficulty.PEACEFUL)) {
                this.setTarget(null);
            } else if (this.getTarget().isRemoved() || this.getTarget().isDeadOrDying() || this.distanceTo((Entity)this.getTarget()) > 128.0f) {
                this.setTarget(null);
            }
        }
        if (this.level().isClientSide && (firmament = Firmament.fromLevel(this.level())) != null && (starlit = StellarFarmlandBlock.isStarlit((LevelReader)this.level(), this.blockPosition(), firmament))) {
            Vec3 spawnCenter = this.position().add(0.0, (double)this.getBbHeight() * 0.5, 0.0);
            double f = this.getBbWidth();
            int count = (int)(this.getBbWidth() * 8.0f);
            for (int i = 0; i < count; ++i) {
                double x = spawnCenter.x + (this.random.nextDouble() - 0.5) * f;
                double y = spawnCenter.y + (this.random.nextDouble() - 0.5) * (double)this.getBbHeight();
                double z = spawnCenter.z + (this.random.nextDouble() - 0.5) * f;
                this.level().addParticle((ParticleOptions)OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER, x, y, z, this.getDeltaMovement().x, this.getDeltaMovement().y + 0.2, this.getDeltaMovement().z);
            }
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), false);
        } else {
            this.prevHaloAngle = this.haloAngle;
            float h = this.getHealthFraction();
            this.haloAngle += 2.5f + 40.0f * (1.0f - h * h);
        }
        if (this.isDeadOrDying()) {
            float d = this.getExplosionGlowProgress();
            this.rollAngle += (float)Math.PI * d * 5.0f;
            this.tentacleRollAngle += (float)Math.PI * d * 20.0f;
        }
        if (this.isHollow()) {
            this.tiltAngle = (float)((double)this.tiltAngle + (180.0 - (double)this.tiltAngle) * 0.05);
            this.setDeltaMovement(this.getDeltaMovement().x * 0.8, this.getDeltaMovement().y * 0.98 - 0.05, this.getDeltaMovement().z * 0.8);
        }
    }

    protected void customServerAiStep() {
        boolean starlit;
        Firmament firmament = Firmament.fromLevel(this.level());
        if (firmament != null && (starlit = StellarFarmlandBlock.isStarlit((LevelReader)this.level(), this.blockPosition(), firmament)) && this.tickCount % 20 == 0) {
            this.heal(1.0f);
        }
    }

    protected void tickDeath() {
        Level level = this.level();
        boolean doMobLoot = level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
        boolean doMobGriefing = level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        ++this.ticksSinceDeath;
        if (this.ticksSinceDeath >= 200 && !this.isHollow()) {
            this.becomeHollow();
        }
        if (!level.isClientSide && this.isHollow() && doMobGriefing && (this.getRandom().nextInt(8) == 0 || this.ticksSinceDeath % 49 == 0)) {
            this.spewSparks(3 + this.getRandom().nextInt(4), true);
        }
        if (level.isClientSide && this.getRandom().nextInt(8) == 0) {
            this.spawnSmokeBurst();
            level.playLocalSound((Entity)this, SoundEvents.FIRECHARGE_USE, SoundSource.HOSTILE, 4.0f, 0.7f + 0.5f * this.getRandom().nextFloat());
        }
        if (!this.isRemoved() && (this.ticksSinceDeath >= 400 || this.ticksSinceDeath >= 240 && this.onGround())) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (doMobLoot) {
                    ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)this.position(), (int)this.getBaseExperienceReward());
                }
                this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                serverLevel.explode((Entity)this, this.getX(), this.getY(), this.getZ(), 10.0f, false, Level.ExplosionInteraction.MOB);
                if (doMobGriefing) {
                    for (int i = 0; i < 7; ++i) {
                        this.spewSparks(5 + this.getRandom().nextInt(4), false);
                    }
                    BlockPos thisPos = this.blockPosition();
                    RandomSource random = this.getRandom();
                    for (int i = 0; i < 800; ++i) {
                        Vec3i offset = new Vec3i(random.nextInt(17) - 8, random.nextInt(17) - 8, random.nextInt(17) - 8);
                        double distSqr = offset.distSqr(Vec3i.ZERO);
                        if (!(distSqr < 72.25)) continue;
                        BlockPos targetPos = thisPos.offset(offset);
                        boolean hitWater = level.getBlockState(targetPos).is(Blocks.WATER);
                        if (!level.isEmptyBlock(targetPos) && !hitWater) continue;
                        level.setBlockAndUpdate(targetPos, (BlockState)PhlogisticFireBlock.getState((BlockGetter)this.level(), targetPos).setValue((Property)PhlogisticFireBlock.WATERLOGGED, (Comparable)Boolean.valueOf(hitWater)));
                    }
                }
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void spewSparks(int sparkCount, boolean hasOwner) {
        float yaw = (float)((double)this.getRandom().nextFloat() * (Math.PI * 2));
        float pitch = (float)((double)(this.getRandom().nextFloat() * 0.7f - 0.3f) * Math.PI);
        for (int i = 0; i < sparkCount; ++i) {
            float sparkYaw = yaw + (float)(((double)this.getRandom().nextFloat() - 0.5) * 0.2 * (Math.PI * 2));
            float sparkPitch = pitch + (float)(((double)this.getRandom().nextFloat() - 0.5) * 0.1 * (Math.PI * 2));
            float cosYaw = Mth.cos((float)sparkYaw);
            float sinYaw = Mth.sin((float)sparkYaw);
            float cosPitch = Mth.cos((float)sparkPitch);
            float sinPitch = Mth.sin((float)sparkPitch);
            Vec3 targetDirection = new Vec3((double)(cosYaw * cosPitch), (double)sinPitch, (double)(sinYaw * cosPitch));
            float posOffset = 1.2f;
            PhlogisticSparkEntity spark = new PhlogisticSparkEntity(this.getX() + targetDirection.x * (double)posOffset, this.getY() + targetDirection.y * (double)posOffset, this.getZ() + targetDirection.z * (double)posOffset, targetDirection, this.level());
            if (hasOwner) {
                spark.setOwner((Entity)this);
            }
            this.level().addFreshEntity((Entity)spark);
        }
        this.level().playSound(null, this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.HOSTILE, 7.0f, 0.4f + 0.5f * this.getRandom().nextFloat());
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        if (this.isDeadOrDying()) {
            return false;
        }
        if (this.isAngry()) {
            return false;
        }
        if (distanceToClosestPlayer < 128.0) {
            return false;
        }
        return super.removeWhenFarAway(distanceToClosestPlayer);
    }

    protected boolean isImmobile() {
        return this.isHollow();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() instanceof AbstractSubcaelicEntity) {
            return false;
        }
        return super.hurt(source, amount);
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.angerTime = angerTime;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angryAt;
    }

    public boolean isAngryAtAllPlayers(Level world) {
        return this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    public void playerDied(Player player) {
    }

    public void remove(Entity.RemovalReason reason) {
        this.orphanTorpedos();
        super.remove(reason);
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    public AABB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().inflate((double)this.getBbWidth() * 0.6);
    }

    @Override
    protected boolean shouldTickAngles() {
        return !this.isHollow();
    }

    @Override
    public double getTurnFactor() {
        return this.getTarget() != null ? 0.12 : 0.04;
    }

    @Override
    public void spawnTrailParticles() {
        Vec3 spawnCenter = this.position().add(0.0, (double)this.getBbHeight() * 0.5, 0.0).subtract(this.getLookAngle().scale((double)this.getBbWidth() * 0.5));
        double f = (double)this.getBbWidth() * 0.2;
        int count = (int)((double)(this.getBbWidth() * 4.0f) * Math.min(1.0, 2.0 * this.getDeltaMovement().length()));
        for (int i = 0; i < count; ++i) {
            double x = spawnCenter.x + (this.random.nextDouble() - 0.5) * f;
            double y = spawnCenter.y + (this.random.nextDouble() - 0.5) * f;
            double z = spawnCenter.z + (this.random.nextDouble() - 0.5) * f;
            this.level().addParticle((ParticleOptions)OperationStarcleaveParticleTypes.LARGE_GLIMMER_SMOKE, true, x, y, z, this.getDeltaMovement().x * -1.5, this.getDeltaMovement().y * -1.5, this.getDeltaMovement().z * -1.5);
        }
    }

    public void spawnSmokeBurst() {
        RandomSource random = this.getRandom();
        float height = this.getBbHeight();
        float width = this.getBbWidth();
        Vec3 offset = new Vec3((double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5).normalize().multiply((double)width, (double)height, (double)width);
        for (int i = 0; i < 240; ++i) {
            double speed = 0.15f + random.nextFloat() * 0.15f;
            double variation = 0.3f;
            this.level().addParticle((ParticleOptions)OperationStarcleaveParticleTypes.LARGE_GLIMMER_SMOKE, false, this.getX(), this.getY(), this.getZ(), this.getDeltaMovement().x + offset.x * speed + random.nextGaussian() * variation, this.getDeltaMovement().y + offset.y * speed + random.nextGaussian() * variation, this.getDeltaMovement().z + offset.z * speed + random.nextGaussian() * variation);
        }
    }

    public boolean isHollow() {
        return (Boolean)this.entityData.get(HOLLOW);
    }

    private void setHollow(boolean value) {
        this.entityData.set(HOLLOW, (Object)value);
    }

    public void becomeHollow() {
        this.setHollow(true);
        this.ticksSinceDeath = 200;
    }

    public float getExplosionGlowProgress() {
        if (this.isDeadOrDying()) {
            return (float)this.ticksSinceDeath / 400.0f;
        }
        return 0.0f;
    }

    protected void addTorpedo(SubcaelicTorpedoEntity torpedo) {
        this.torpedos.add(torpedo);
    }

    protected void removeTorpedo(SubcaelicTorpedoEntity torpedo) {
        this.torpedos.remove((Object)torpedo);
    }

    public boolean canAdoptTorpedo() {
        return this.torpedos.size() < 14;
    }

    public void orphanTorpedos() {
        for (SubcaelicTorpedoEntity torpedo : this.torpedos) {
            torpedo.dux = null;
            torpedo.inGroup = false;
        }
        this.torpedos.clear();
    }

    public float getHealthFraction() {
        if (this.getMaxHealth() == 0.0f) {
            return 0.0f;
        }
        float f = this.getHealth() / this.getMaxHealth();
        return Mth.clamp((float)f, (float)0.0f, (float)1.0f);
    }

    static class AscendGoal
    extends Goal {
        private final SubcaelicDuxEntity dux;

        public AscendGoal(SubcaelicDuxEntity dux) {
            this.dux = dux;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.dux.isDeadOrDying() && !this.dux.isHollow();
        }

        public void tick() {
            int maxHeight;
            Level world = this.dux.level();
            double x = this.dux.getX();
            double z = this.dux.getZ();
            LivingEntity target = this.dux.getTarget();
            if (target != null) {
                x = target.getX();
                z = target.getZ();
            }
            int topY = world.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z);
            Firmament firmament = Firmament.fromLevel(world);
            int goalHeight = topY + 80;
            if (firmament != null && goalHeight > (maxHeight = firmament.getY() - 12)) {
                goalHeight = maxHeight;
            }
            this.dux.moveControl.setWantedPosition(x, (double)goalHeight, z, 1.5);
            if (this.dux.getY() > (double)goalHeight && this.dux.ticksSinceDeath > 60) {
                this.dux.becomeHollow();
            }
        }
    }

    static class SendTorpedoGoal
    extends Goal {
        private final SubcaelicDuxEntity dux;
        private int cooldown;

        public SendTorpedoGoal(SubcaelicDuxEntity dux) {
            this.dux = dux;
        }

        public boolean canUse() {
            if (this.dux.torpedos.isEmpty()) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            if (this.dux.level().getDifficulty().equals((Object)Difficulty.PEACEFUL)) {
                return false;
            }
            this.cooldown = SendTorpedoGoal.reducedTickDelay((int)(8 + (int)(Math.sqrt(this.dux.getHealthFraction()) * (double)(22 + this.dux.getRandom().nextInt(20)))));
            LivingEntity target = this.dux.getTarget();
            if (target == null) {
                return false;
            }
            if (!target.isAlive()) {
                return false;
            }
            return !(target instanceof Player) || !target.isSpectator() && !((Player)target).isCreative();
        }

        public void tick() {
            LivingEntity target = this.dux.getTarget();
            if (target != null) {
                int torpedoReciprocalChance = 1 + (int)(Math.sqrt(this.dux.getHealthFraction()) * 3.5);
                for (SubcaelicTorpedoEntity torpedo : this.dux.torpedos) {
                    if (!torpedo.isAlive() || torpedo.isPrimed() || torpedo.getRandom().nextInt(torpedoReciprocalChance) != 0) continue;
                    torpedo.primeAndTarget(target, 1.0f - 0.25f * this.dux.getHealthFraction());
                }
                this.dux.torpedos.removeIf(SubcaelicTorpedoEntity::isPrimed);
            }
        }
    }

    static class SpawnTorpedoGoal
    extends Goal {
        private static final double TORPEDO_CHECK_RANGE = 256.0;
        private static final int MAX_NEARBY_TORPEDOES = 48;
        private final SubcaelicDuxEntity dux;
        private int cooldown;

        public SpawnTorpedoGoal(SubcaelicDuxEntity dux) {
            this.dux = dux;
        }

        public boolean canUse() {
            if (this.dux.torpedos.size() >= 7) {
                return false;
            }
            if (this.cooldown > 0 && (this.dux.isAlive() || this.cooldown <= SpawnTorpedoGoal.reducedTickDelay((int)20))) {
                --this.cooldown;
                return false;
            }
            this.cooldown = this.dux.isDeadOrDying() ? SpawnTorpedoGoal.reducedTickDelay((int)20) : SpawnTorpedoGoal.reducedTickDelay((int)(6 + (int)(Math.sqrt(this.dux.getHealthFraction()) * (double)(14 + this.dux.getRandom().nextInt(20)))));
            int nearbyTorpedoes = this.dux.level().getEntities(OperationStarcleaveEntityTypes.SUBCAELIC_TORPEDO, this.dux.getBoundingBox().inflate(256.0), Entity::isAlive).size();
            return nearbyTorpedoes < 48;
        }

        public void tick() {
            boolean deadDux = this.dux.isDeadOrDying();
            LivingEntity target = this.dux.getTarget();
            if (deadDux && target == null) {
                return;
            }
            Level world = this.dux.level();
            int torpedoCount = this.dux.isDeadOrDying() ? (this.dux.random.nextBoolean() ? 4 : 3) : 1;
            Vec3 rv = this.dux.getLookAngle().scale((double)this.dux.getBbWidth() * 0.5);
            for (int i = 0; i < torpedoCount; ++i) {
                SubcaelicTorpedoEntity torpedo = (SubcaelicTorpedoEntity)OperationStarcleaveEntityTypes.SUBCAELIC_TORPEDO.create(world);
                if (torpedo == null) continue;
                torpedo.moveTo(this.dux.getX() - rv.x, this.dux.getY() + (double)(this.dux.getBbHeight() / 2.0f) - rv.y, this.dux.getZ() - rv.z, this.dux.getYRot(), this.dux.getXRot());
                torpedo.setDeltaMovement(this.dux.getDeltaMovement());
                torpedo.joinGroupOf(this.dux);
                if (deadDux) {
                    torpedo.setDeltaMovement(target.position().subtract(torpedo.position()).normalize().scale(1.5).add(this.dux.random.nextGaussian() * 0.4, this.dux.random.nextGaussian() * 0.4, this.dux.random.nextGaussian() * 0.4));
                    torpedo.primeAndTarget(target, 1.5f);
                    torpedo.leaveGroup(false);
                }
                world.addFreshEntity((Entity)torpedo);
            }
        }
    }

    static class TargetAttackerGoal
    extends TargetGoal {
        private static final TargetingConditions VALID_AVOIDABLES_PREDICATE = TargetingConditions.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
        private int lastAttackedTime;
        private final Class<?>[] noRevengeTypes;
        private final SubcaelicDuxEntity dux;

        public TargetAttackerGoal(SubcaelicDuxEntity dux, Class<?> ... noRevengeTypes) {
            super((Mob)dux, true);
            this.dux = dux;
            this.noRevengeTypes = noRevengeTypes;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            int i = this.mob.getLastHurtByMobTimestamp();
            LivingEntity livingEntity = this.mob.getLastHurtByMob();
            if (i != this.lastAttackedTime && livingEntity != null) {
                for (Class<?> class_ : this.noRevengeTypes) {
                    if (!class_.isAssignableFrom(livingEntity.getClass())) continue;
                    return false;
                }
                return this.canAttack(livingEntity, VALID_AVOIDABLES_PREDICATE);
            }
            return false;
        }

        public void start() {
            LivingEntity target = this.mob.getLastHurtByMob();
            if (target instanceof Player) {
                this.dux.forgetCurrentTargetAndRefreshUniversalAnger();
                this.lastAttackedTime = this.mob.getLastHurtByMobTimestamp();
            } else {
                this.mob.setTarget(target);
                this.targetMob = this.mob.getTarget();
                this.lastAttackedTime = this.mob.getLastHurtByMobTimestamp();
                this.unseenMemoryTicks = 300;
            }
            super.start();
        }
    }
}

