/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.block.PhlogisticFireBlock;
import phanastrae.operation_starcleave.entity.OperationStarcleaveDamageTypes;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityAttachment;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityTypes;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;

public class PhlogisticSparkEntity
extends AbstractHurtingProjectile {
    public PhlogisticSparkEntity(EntityType<? extends PhlogisticSparkEntity> entityType, Level level) {
        super(entityType, level);
        this.accelerationPower = 0.04;
    }

    protected PhlogisticSparkEntity(double x, double y, double z, Level level) {
        super(OperationStarcleaveEntityTypes.PHLOGISTIC_SPARK, level);
    }

    public PhlogisticSparkEntity(double x, double y, double z, Vec3 movement, Level level) {
        super(OperationStarcleaveEntityTypes.PHLOGISTIC_SPARK, x, y, z, movement, level);
        this.accelerationPower = 0.04;
    }

    public PhlogisticSparkEntity(LivingEntity owner, Vec3 movement, Level level) {
        super(OperationStarcleaveEntityTypes.PHLOGISTIC_SPARK, owner, movement, level);
        this.accelerationPower = 0.04;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public boolean isOnFire() {
        return true;
    }

    protected boolean shouldBurn() {
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return OperationStarcleaveParticleTypes.GLIMMER_SMOKE;
    }

    protected double getDefaultGravity() {
        return 0.025f;
    }

    public void tick() {
        Vec3 deltaMovement = this.getDeltaMovement();
        this.setDeltaMovement(deltaMovement.add(0.0, -this.getGravity(), 0.0));
        super.tick();
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity target = result.getEntity();
            OperationStarcleaveEntityAttachment osea = OperationStarcleaveEntityAttachment.fromEntity(target);
            Entity owner = this.getOwner();
            int remainingFireTicks = osea.getPhlogisticFireTicks();
            DamageSource damageSource = OperationStarcleaveDamageTypes.phlogisticSpark((Level)serverLevel, this, owner);
            osea.setOnPhlogisticFireFor(5.0f);
            if (!target.hurt(damageSource, 5.0f)) {
                osea.setPhlogisticFireTicks(remainingFireTicks);
            } else {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)damageSource);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        Entity entity;
        Level level = this.level();
        super.onHitBlock(result);
        if (!(level.isClientSide || (entity = this.getOwner()) instanceof Mob && !level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING))) {
            BlockPos pos = result.getBlockPos().relative(result.getDirection());
            boolean hitWater = level.getBlockState(pos).is(Blocks.WATER);
            if (level.isEmptyBlock(pos) || hitWater) {
                level.setBlockAndUpdate(pos, (BlockState)PhlogisticFireBlock.getState((BlockGetter)this.level(), pos).setValue((Property)PhlogisticFireBlock.WATERLOGGED, (Comparable)Boolean.valueOf(hitWater)));
            }
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected void onDeflection(@Nullable Entity entity, boolean deflectedByPlayer) {
        super.onDeflection(entity, deflectedByPlayer);
        this.accelerationPower = deflectedByPlayer ? 0.1 : 0.04;
    }
}

