/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.entity.projectile;

import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityTypes;
import phanastrae.operation_starcleave.item.OperationStarcleaveItems;
import phanastrae.operation_starcleave.network.packet.StarbleachedPearlLaunchPayload;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.services.XPlatInterface;

public class StarbleachedPearlEntity
extends ThrowableItemProjectile {
    public StarbleachedPearlEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public StarbleachedPearlEntity(Level world, LivingEntity owner) {
        super(OperationStarcleaveEntityTypes.STARBLEACHED_PEARL, owner, world);
    }

    public StarbleachedPearlEntity(Level world, double x, double y, double z) {
        super(OperationStarcleaveEntityTypes.STARBLEACHED_PEARL, x, y, z, world);
    }

    protected Item getDefaultItem() {
        return OperationStarcleaveItems.STARBLEACHED_PEARL;
    }

    public void handleEntityEvent(byte status) {
        if (status == 3) {
            for (int i = 0; i < 1000; ++i) {
                this.level().addParticle((ParticleOptions)OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.12, this.random.nextGaussian() * 0.12, this.random.nextGaussian() * 0.12);
            }
        }
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        Vec3 pos = hitResult.getLocation();
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            pos = pos.add(this.position().subtract(pos).scale(0.3));
        }
        if (!this.level().isClientSide && !this.isRemoved()) {
            StarbleachedPearlEntity.repel(pos, 8.0f, 1.5f, this.level(), (Entity)this, 0.6f);
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    public void tick() {
        Level world = this.level();
        if (world != null && world.isClientSide) {
            Vec3 vel = this.getDeltaMovement();
            RandomSource random = this.random;
            for (int i = 0; i < 18; ++i) {
                world.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER, this.getX(), this.getY(), this.getZ(), vel.x * -0.2 + (double)random.nextFloat() * 0.06 - 0.03, vel.y * -0.2 + (double)random.nextFloat() * 0.06 - 0.03, vel.z * -0.2 + (double)random.nextFloat() * 0.06 - 0.03);
            }
        }
        super.tick();
    }

    public static void repel(Vec3 pos, float radius, float maxAddedSpeed, Level world, @Nullable Entity entity, float audioMultiplier) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.players().forEach(playerEntity -> {
                float radiusBig;
                double distance;
                ServerPlayer e = playerEntity;
                Entity vehicle = playerEntity.getControlledVehicle();
                if (vehicle != null) {
                    e = vehicle;
                }
                if ((distance = e.position().subtract(pos).length()) < (double)(radiusBig = radius * 1.25f + 4.0f)) {
                    XPlatInterface.INSTANCE.sendPayload((ServerPlayer)playerEntity, new StarbleachedPearlLaunchPayload(pos, radius, maxAddedSpeed, entity != null, entity == null ? -1 : entity.getId()));
                }
            });
        }
        StarbleachedPearlEntity.doRepulsion(pos, radius, maxAddedSpeed, world, entity);
        if (!world.isClientSide) {
            RandomSource random = world.getRandom();
            world.playSound(null, pos.x(), pos.y(), pos.z(), SoundEvents.TRIDENT_THUNDER, SoundSource.PLAYERS, audioMultiplier, 0.9f + random.nextFloat() * 0.3f);
        }
    }

    public static void doRepulsion(Vec3 pos, float radius, float maxAddedSpeed, Level world, @Nullable Entity entity) {
        StarbleachedPearlEntity.doRepulsion(pos, radius, maxAddedSpeed, world, entity, EntitySelector.NO_SPECTATORS);
    }

    public static void doRepulsion(Vec3 pos, float radius, float maxAddedSpeed, Level world, @Nullable Entity entity, Predicate<? super Entity> predicate) {
        for (Entity e : world.getEntities(entity, AABB.unitCubeFromLowerCorner((Vec3)pos).inflate((double)radius), predicate)) {
            boolean doRepel = e instanceof Player ? !world.isClientSide : e.isControlledByLocalInstance();
            if (!doRepel) continue;
            StarbleachedPearlEntity.repelEntity(e, pos, radius, maxAddedSpeed);
        }
    }

    public static void repelEntity(Entity e, Vec3 pos, float radius, float maxAddedSpeed) {
        Vec3 pos2;
        double dist;
        if (e instanceof Player) {
            Player player = (Player)e;
            if (player.getAbilities().flying) {
                return;
            }
        }
        if ((dist = (pos2 = e.position().add(0.0, (double)(e.getBbHeight() / 2.0f), 0.0)).distanceTo(pos)) > (double)radius) {
            return;
        }
        double f = ((double)radius - dist) / (double)radius;
        f = 1.0 - (1.0 - f) * (1.0 - f);
        Vec3 offset = pos2.subtract(pos).normalize();
        e.push(offset.scale(f * (double)maxAddedSpeed));
        e.hurtMarked = true;
        e.fallDistance = -5.0f;
    }
}

